#ifdef SYSTEMC
/*
 * $Id: Register_Address_Translation_unit_function_depth_save_genMealy_rename.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Register_Address_Translation_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::function_depth_save_genMealy_rename"
  void Register_Address_Translation_unit::function_depth_save_genMealy_rename (void)
  {
    log_begin(Register_Address_Translation_unit,FUNCTION);
    log_function(Register_Address_Translation_unit,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) != 0)
      {
        bool rat_gpr_speculative_valid [_param->_nb_front_end][_param->_max_nb_context][_param->_max_nb_branch_speculated][_param->_nb_general_register_logic];
        bool rat_spr_speculative_valid [_param->_nb_front_end][_param->_max_nb_context][_param->_max_nb_branch_speculated][_param->_nb_special_register_logic];
        // bool reg_save_rat              [_param->_nb_front_end][_param->_max_nb_context];

        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
            {
              // reg_save_rat [i][j] = reg_SAVE_RAT [i][j];
              for (uint32_t k=0; k<_param->_nb_branch_speculated[i][j]; ++k)
                {
                  for (uint32_t l=0; l<_param->_nb_general_register_logic; ++l)
                    rat_gpr_speculative_valid [i][j][k][l] = RAT_GPR_SPECULATIVE_VALID [i][j][k][l];
                  for (uint32_t l=0; l<_param->_nb_special_register_logic; ++l)
                    rat_spr_speculative_valid [i][j][k][l] = RAT_SPR_SPECULATIVE_VALID [i][j][k][l];
                }
            }

        for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
          {
            if (PORT_READ(in_RENAME_VAL [i])) // not in sensitive list : it's to have valide value to array access
              {
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * RENAME [%d]",i);
                
                Tcontext_t front_end_id = (_param->_have_port_front_end_id)?PORT_READ(in_RENAME_FRONT_END_ID [i]):0;
                Tcontext_t context_id   = (_param->_have_port_context_id  )?PORT_READ(in_RENAME_CONTEXT_ID   [i]):0;
                
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end_id       : %d",front_end_id);
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * context_id         : %d",context_id);

                Tdepth_t   depth_min    = (_param->_have_port_depth)?PORT_READ(in_DEPTH_MIN[front_end_id][context_id]):0;
                Tdepth_t   depth_max    = (_param->_have_port_depth)?PORT_READ(in_DEPTH_MAX[front_end_id][context_id]):0;
                Tcontrol_t depth_full   = PORT_READ(in_DEPTH_FULL [front_end_id][context_id]);

                Tdepth_t   depth        = (_param->_have_port_depth       )?PORT_READ(in_RENAME_DEPTH        [i]):0;
                // Tcontrol_t save_rat     = PORT_READ(in_RENAME_SAVE_RAT [i]);
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * depth/min/max/full : %d - [%d:%d] - %d",depth,depth_min,depth_max,depth_full);
                // log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * save_rat (new)     : %d",save_rat);
                // log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * save_rat (old)     : %d",reg_save_rat [front_end_id][context_id]);
                
                // if (reg_save_rat [front_end_id][context_id])
                //   {
                //     for (uint32_t num_reg_log=0; num_reg_log<_param->_nb_general_register_logic; num_reg_log++)
                //       rat_gpr_speculative_valid [front_end_id][context_id][depth][num_reg_log] = false;
                //     for (uint32_t num_reg_log=0; num_reg_log<_param->_nb_special_register_logic; num_reg_log++)
                //       rat_spr_speculative_valid [front_end_id][context_id][depth][num_reg_log] = false;
                //   }
                
                // reg_save_rat[front_end_id][context_id] = save_rat;
                
                Tgeneral_address_t num_reg_ra_log    = PORT_READ(in_RENAME_NUM_REG_RA_LOG [i]); //%_param->_nb_general_register;
                Tgeneral_address_t num_reg_rb_log    = PORT_READ(in_RENAME_NUM_REG_RB_LOG [i]); //%_param->_nb_general_register;
                Tspecial_address_t num_reg_rc_log    = PORT_READ(in_RENAME_NUM_REG_RC_LOG [i]); //%_param->_nb_special_register;
                Tgeneral_address_t num_reg_rd_log    = PORT_READ(in_RENAME_NUM_REG_RD_LOG [i]); //%_param->_nb_general_register;
                Tspecial_address_t num_reg_re_log    = PORT_READ(in_RENAME_NUM_REG_RE_LOG [i]); //%_param->_nb_special_register;
                
                Tgeneral_address_t num_reg_ra_phy    ;
                Tgeneral_address_t num_reg_rb_phy    ;
                Tspecial_address_t num_reg_rc_phy    ;
                Tgeneral_address_t num_reg_rd_phy_old;
                Tspecial_address_t num_reg_re_phy_old;
                        
                bool find_ra = false;
                bool find_rb = false;
                bool find_rc = false;
                bool find_rd = false;
                bool find_re = false;
                
                for (uint32_t num_branch=0; num_branch<_param->_nb_branch_speculated[front_end_id][context_id]; ++num_branch)
                  {
                    uint32_t index = (depth-num_branch)%_param->_nb_branch_speculated[front_end_id][context_id];

                    if (not find_ra and rat_gpr_speculative_valid [front_end_id][context_id][index][num_reg_ra_log])
                      {
                        find_ra            = true;
                        num_reg_ra_phy     = RAT_GPR_SPECULATIVE[front_end_id][context_id][index][num_reg_ra_log];
                      }
                    
                    if (not find_rb and rat_gpr_speculative_valid [front_end_id][context_id][index][num_reg_rb_log])
                      {
                        find_rb            = true;
                        num_reg_rb_phy     = RAT_GPR_SPECULATIVE[front_end_id][context_id][index][num_reg_rb_log];
                      }
                    
                    if (not find_rc and rat_spr_speculative_valid [front_end_id][context_id][index][num_reg_rc_log])
                      {
                        find_rc            = true;
                        num_reg_rc_phy     = RAT_SPR_SPECULATIVE[front_end_id][context_id][index][num_reg_rc_log];
                      }
                    
                    if (not find_rd and rat_gpr_speculative_valid [front_end_id][context_id][index][num_reg_rd_log])
                      {
                        find_rd            = true;
                        num_reg_rd_phy_old = RAT_GPR_SPECULATIVE[front_end_id][context_id][index][num_reg_rd_log];
                      }
                    
                    if (not find_re and rat_spr_speculative_valid [front_end_id][context_id][index][num_reg_re_log])
                      {
                        find_re            = true;
                        num_reg_re_phy_old = RAT_SPR_SPECULATIVE[front_end_id][context_id][index][num_reg_re_log];
                      }

                    // if index == depth_min, stop because depth_min is the not speculative.
                    // if (index == depth_min)
                    //   break;
                  }
                
                if (not find_ra)
                  num_reg_ra_phy     = RAT_GPR_NOT_SPECULATIVE[front_end_id][context_id][num_reg_ra_log];
                if (not find_rb)
                  num_reg_rb_phy     = RAT_GPR_NOT_SPECULATIVE[front_end_id][context_id][num_reg_rb_log];
                if (not find_rc)
                  num_reg_rc_phy     = RAT_GPR_NOT_SPECULATIVE[front_end_id][context_id][num_reg_rc_log];
                if (not find_rd)
                  num_reg_rd_phy_old = RAT_GPR_NOT_SPECULATIVE[front_end_id][context_id][num_reg_rd_log];
                if (not find_re)
                  num_reg_re_phy_old = RAT_SPR_NOT_SPECULATIVE[front_end_id][context_id][num_reg_re_log];
                
                // if rat_SPECULATIVE is valid, 
                // then read rat_SPECULATIVE have the most valid alias register
                // else, they have an previous event, the rat_NOT_SPECULATIVE have the valid register
                
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_ra         : %d -> %d",num_reg_ra_log,num_reg_ra_phy    );
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rb         : %d -> %d",num_reg_rb_log,num_reg_rb_phy    );
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rc         : %d -> %d",num_reg_rc_log,num_reg_rc_phy    );
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd         : %d -> %d",num_reg_rd_log,num_reg_rd_phy_old);
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re         : %d -> %d",num_reg_re_log,num_reg_re_phy_old);
                
                PORT_WRITE(out_RENAME_NUM_REG_RA_PHY     [i], num_reg_ra_phy    );
                PORT_WRITE(out_RENAME_NUM_REG_RB_PHY     [i], num_reg_rb_phy    );
                PORT_WRITE(out_RENAME_NUM_REG_RC_PHY     [i], num_reg_rc_phy    );
                PORT_WRITE(out_RENAME_NUM_REG_RD_PHY_OLD [i], num_reg_rd_phy_old);
                PORT_WRITE(out_RENAME_NUM_REG_RE_PHY_OLD [i], num_reg_re_phy_old);
              }
          }
      }

    log_end(Register_Address_Translation_unit,FUNCTION);
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
