/*
 * $Id: RegisterFile_Internal_Banked_allocation.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Internal_Banked/include/RegisterFile_Internal_Banked.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_internal_banked    {

  void RegisterFile_Internal_Banked::allocation (void)
  {
    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name                   
					     ,"RegisterFile_Internal_Banked"
#ifdef POSITION
					     ,REGISTER                 
#endif
					      );
    
    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 , IN
							 ,SOUTH
							 ,_("Generalist interface")
#endif
							 );
      
      in_CLOCK              = interface->set_signal_clk              ("clock" ,1);
      in_NRESET             = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    { 
      ALLOC1_INTERFACE_BEGIN("read",IN,WEST,_("Interface Read"),_param->_nb_port_read);

      ALLOC1_VALACK_IN ( in_READ_VAL    ,VAL);
      ALLOC1_VALACK_OUT(out_READ_ACK    ,ACK);
      ALLOC1_SIGNAL_IN ( in_READ_ADDRESS,"address",Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_OUT(out_READ_DATA   ,"data"   ,Tdata_t   ,_param->_size_word);

      ALLOC1_INTERFACE_END(_param->_nb_port_read);
    }

    // ~~~~~[ Interface : "write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("write",IN,EAST,_("Interface Write"),_param->_nb_port_write);

      ALLOC1_VALACK_IN ( in_WRITE_VAL    ,VAL);
      ALLOC1_VALACK_OUT(out_WRITE_ACK    ,ACK);
      ALLOC1_SIGNAL_IN ( in_WRITE_ADDRESS,"address",Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_WRITE_DATA   ,"data"   ,Tdata_t   ,_param->_size_word);

      ALLOC1_INTERFACE_END(_param->_nb_port_write);
    }

    if (usage_is_set(_usage,USE_SYSTEMC))
      ALLOC1(reg_DATA,Tdata_t,_param->_nb_word);
    
#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif
  };

}; // end namespace registerfile_internal_banked
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
