#!/bin/bash

#-----------------------------------------------------------
# $Id: xilinx_extract_info.sh 145 2010-10-13 18:15:51Z rosiere $
#-----------------------------------------------------------

##-----[ usage ]---------------------------------------------
#function usage ()
#{
#    echo "Usage     : ${0} [files]";
#    echo "Arguments : ";
#    echo ' * files : lists of files. If empty, take *.fpga.log';
##   echo "Notes     :";
##   echo " * Morpheo's environnement must be positionned.";
#
#    exit;
#}

#-----[ xilinx_extract_info_usage ]-------------------------
function xilinx_extract_info_usage()
{
    echo "${0} option [files]";
    echo "Arguments : ";
    echo ' * files : lists of files. If empty, take *.fpga.log';
    echo " * -s : print summary section";
    echo " * -t : print timing section";
    exit 1;
}

#-----[ xilinx_extract_info_summary ]-----------------------
function xilinx_extract_info_summary ()
{
    summary_line_begin=$(grep -n "Device utilization summary:" ${1} | cut -d : -f 1);
    summary_line_end=$(grep -n "Partition Resource Summary:"   ${1} | cut -d : -f 1);

    if test "${summary_line_begin}" != "" -a "${summary_line_end}" != ""; then
        head -n $(($summary_line_end-1)) ${1} | tail -n $(($summary_line_end-$summary_line_begin));
    fi;
}

#-----[ xilinx_extract_info_timing ]------------------------
function xilinx_extract_info_timing ()
{
    timing_line_begin=$(grep -n "Timing Summary:"              ${1} | cut -d : -f 1);
    timing_line_end=$(grep -n "Timing Detail:"                 ${1} | cut -d : -f 1);

    if test "${timing_line_begin}" != "" -a "${timing_line_end}" != ""; then
        head -n $(($timing_line_end-1))  ${1} | tail -n $(($timing_line_end-$timing_line_begin));
    fi;
}

#-----[ main ]----------------------------------------------
function xilinx_extract_info()
{
    local summary=0;
    local timing=0;
    local nb_params=$#;
    set -- $(getopt :tsh "$@")
    for arg
    do	case "$arg" in
	    -t)	timing=1;  nb_params=$((nb_params-1));;
	    -s)	summary=1; nb_params=$((nb_params-1));;
            -h) xilinx_extract_info_usage   ${*}; break;;
	    --)	if test ${summary} -eq 0 -a ${timing} -eq 0; then
                    summary=1;
                    timing=1;
                fi;

	esac
    done

    if test $nb_params -eq 0; then
        files="*.fpga.log";
    else
        files="$*";
    fi;

    for i in $files; do
        if test -f ${i}; then
            echo "===================| ${i}";

            if test ${summary} -ne 0; then
                xilinx_extract_info_summary  $i;
            fi;
            if test ${timing} -ne 0; then
                xilinx_extract_info_timing  $i;
            fi;
        fi;
    done
}

#-----[ Corps ]---------------------------------------------
xilinx_extract_info ${*}

