#ifdef VHDL
/*
 * $Id: RegisterFile_Internal_Banked_vhdl_declaration.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Internal_Banked/include/RegisterFile_Internal_Banked.h"
#include "Behavioural/include/Vhdl.h"
#include "Common/include/ToString.h"
namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_internal_banked    {

  void RegisterFile_Internal_Banked::vhdl_declaration (Vhdl * & vhdl)
  {
    vhdl->set_type ("Tregfile", "array " + _std_logic_range(_param->_nb_word) + " of " + std_logic(_param->_size_word));

    for (uint32_t num_write=0; num_write<_param->_nb_port_write; ++num_write)
      for (uint32_t num_read=0; num_read<_param->_nb_port_read; ++num_read)
        vhdl->set_signal ("reg_DATA_"+toString(num_write)+"_"+toString(num_read), "Tregfile");

    if (_param->_size_ptr_write > 0)
      {
        for (uint32_t num_read=0; num_read<_param->_nb_port_read; ++num_read)
          vhdl->set_signal ("READ_NUM_BANK_"+toString(num_read), _param->_size_ptr_write);
      }
#ifdef PTR_IS_REGFILE
    if (_param->_size_ptr_write > 0)
      {
    vhdl->set_type ("Tptr_write", "array " + _std_logic_range(_param->_nb_word) + " of " + std_logic(_param->_size_ptr_write));
    vhdl->set_signal ("reg_PTR_WRITE", "Tptr_write");
      }
#else
    if (_param->_size_ptr_write > 0)
      for (uint32_t num_word=0; num_word<_param->_nb_word; ++num_word)
        vhdl->set_signal ("reg_PTR_WRITE_"+toString(num_word), _param->_size_ptr_write);
#endif
  };

}; // end namespace registerfile_internal_banked
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
