#!/bin/bash

declare distcc_env_is_subshell;
declare distcc_env_file="${HOME}/.distcc_env";

#-----[ distcc_env_usage ]---------------------------------
function distcc_env_usage()
{
    echo "${0} option";
    echo "  -h : print this message";
    echo "  -d : load default DISTCC_HOSTS";
    echo "  -t : from DISTCC_HOSTS, test hosts";
    echo "  -s : save DISTCC_HOSTS in file ${distcc_env_file} (if -t, save after test host)";
    echo "  -l : load file ${distcc_env_file} and set DISTCC_HOSTS";
    echo "";
    echo " 2 methode to set DISTCC_HOSTS : ";
    echo "   * 1) \". $0\"";
    echo "   * 2) DISTCC_HOSTS=\$($0);";

#    exit 1;
}

#-----[ distcc_env_default ]-------------------------------
function distcc_env_default ()
{
    export DISTCC_HOSTS="";
    export DISTCC_HOSTS="${DISTCC_HOSTS} houla/16,lzo"    ; # serveur recherche
    export DISTCC_HOSTS="${DISTCC_HOSTS} hop/16,lzo"      ; # serveur recherche
    export DISTCC_HOSTS="${DISTCC_HOSTS} fox/8,lzo"      ; # serveur recherche
    export DISTCC_HOSTS="${DISTCC_HOSTS} trot/8,lzo"     ; # serveur recherche
    export DISTCC_HOSTS="${DISTCC_HOSTS} bip/8,lzo"      ; # serveur recherche
    export DISTCC_HOSTS="${DISTCC_HOSTS} bop/8,lzo"      ; # serveur recherche
   #export DISTCC_HOSTS="${DISTCC_HOSTS} polka/8,lzo"    ; # serveur recherche    - rserv  
   #export DISTCC_HOSTS="${DISTCC_HOSTS} debussy/8,lzo"  ; # serveur enseignement            
    export DISTCC_HOSTS="${DISTCC_HOSTS} do/8,lzo"       ; # serveur recherche               
    export DISTCC_HOSTS="${DISTCC_HOSTS} re/8,lzo"       ; # serveur recherche               
    export DISTCC_HOSTS="${DISTCC_HOSTS} mi/8,lzo"       ; # serveur recherche               
    export DISTCC_HOSTS="${DISTCC_HOSTS} fa/8,lzo"       ; # serveur recherche               
    export DISTCC_HOSTS="${DISTCC_HOSTS} fusion/8,lzo"   ; # serveur recherche               
    export DISTCC_HOSTS="${DISTCC_HOSTS} heavy/4,lzo"    ; # serveur recherche               
   #export DISTCC_HOSTS="${DISTCC_HOSTS} berlioz/4,lzo"  ; # serveur enseignement - g++ 3.4.6
    export DISTCC_HOSTS="${DISTCC_HOSTS} roll/4,lzo"     ; # serveur recherche               
   #export DISTCC_HOSTS="${DISTCC_HOSTS} rock/2,lzo"     ; # serveur recherche    - g++ 3.4.6
    export DISTCC_HOSTS="${DISTCC_HOSTS} waller/2,lzo"   ; # desktop
    export DISTCC_HOSTS="${DISTCC_HOSTS} lin/2,lzo"      ; # desktop
    export DISTCC_HOSTS="${DISTCC_HOSTS} eric/2,lzo"     ; # desktop
    export DISTCC_HOSTS="${DISTCC_HOSTS} amouri/2,lzo"   ; # desktop
    export DISTCC_HOSTS="${DISTCC_HOSTS} nemu/2,lzo"     ; # desktop
   #export DISTCC_HOSTS="${DISTCC_HOSTS} cherry/2,lzo"   ; # desktop
    export DISTCC_HOSTS="${DISTCC_HOSTS} gamoudi/2,lzo"  ; # desktop
   #export DISTCC_HOSTS="${DISTCC_HOSTS} grunge/2,lzo"   ; # desktop
   #export DISTCC_HOSTS="${DISTCC_HOSTS} mitra/2,lzo"    ; # desktop
   #export DISTCC_HOSTS="${DISTCC_HOSTS} pronky/2,lzo"   ; # desktop
   #export DISTCC_HOSTS="${DISTCC_HOSTS} babylone/2,lzo" ; # desktop  

    if test ${1} -eq 1; then
        echo "${DISTCC_HOSTS}";
    fi;
}

#-----[ distcc_env_load ]----------------------------------
function distcc_env_load ()
{
    if test -f ${distcc_env_file}; then
        DISTCC_HOSTS=$(cat ${distcc_env_file});
    fi;
}

#-----[ distcc_env_save ]----------------------------------
function distcc_env_save ()
{
    echo ${DISTCC_HOSTS} > ${distcc_env_file};
}

#-----[ distcc_env_test ]----------------------------------
function distcc_env_test ()
{
    local hosts="${DISTCC_HOSTS}";

    # re init DISTCC_HOSTS

    export DISTCC_HOSTS="";
    for line in ${hosts}; do
        host=$(echo ${line} | cut -d/ -f1);

        if test ${1} -eq 0; then
            echo -n " * station : ${host} ... ";
        fi;
        
        # ping host ...
        ping -w 1 ${host} &> /dev/null;

        if test "$?" -eq "0"; then
            # ... if ok, reinsert
            if test ${1} -eq 0; then
                echo "online";
            fi;
            export DISTCC_HOSTS="${DISTCC_HOSTS} ${line}";
        else
            if test ${1} -eq 0; then
                echo "offline";
            fi;
        fi;
    done;

    if test ${1} -eq 1; then
        echo "${DISTCC_HOSTS}";
    fi;
}

#-----[ distcc_env ]---------------------------------------
function distcc_env ()
{
    if test "${0}" = "$(basename ${SHELL})"; then
        distcc_env_is_subshell=0;
    else
        distcc_env_is_subshell=1;
    fi;
    
    local exec_distcc_env_default=0;
    local exec_distcc_env_test=0;
    local exec_distcc_env_save=0;
    local exec_distcc_env_load=0;
    local exec_distcc_env_usage=0;
    local no_option=1;
    
    set -- $(getopt :sldth "$@")
    for arg
    do	case "$arg" in
            -d) exec_distcc_env_default=1; no_option=0; ;;
            -t)	exec_distcc_env_test=1;    no_option=0; ;;
            -s) exec_distcc_env_save=1;    no_option=0; ;;
            -l) exec_distcc_env_load=1;    no_option=0; ;;
            -h) exec_distcc_env_usage=1;   break; ;;
            --)	if test $no_option -eq 1; then
                    exec_distcc_env_usage=1;
                fi;
                break;;
        esac
    done


    if test $exec_distcc_env_usage -eq 1; then
        distcc_env_usage ${*};
        
        if test ${distcc_env_is_subshell} -eq 1; then
            exit 1;
        fi;
    else
        if test $exec_distcc_env_default -eq 1; then
            if test $exec_distcc_env_test    -eq 1; then
                distcc_env_default 0;
            else
                distcc_env_default ${distcc_env_is_subshell};
            fi;
        fi;
        if test $exec_distcc_env_load    -eq 1; then
            distcc_env_load;
        fi;
        if test $exec_distcc_env_test    -eq 1; then
            distcc_env_test ${distcc_env_is_subshell};
        fi;
        if test $exec_distcc_env_save   -eq 1; then
            distcc_env_save;
        fi;
    fi;
    
    unset distcc_env_file;
    unset distcc_env_is_subshell;
}

#-----[ Corps ]---------------------------------------------
distcc_env ${*};