#!/bin/bash

function usage ()
{
    echo "usage : $0 [name_src] name_dest";
    exit;
}

function copy_test ()
{
    # Test usage
    if test ${#} -eq 2; then
	name_src=${1};
	name_dest=${2};
    elif test ${#} -eq 1; then
	name_src="x01_w01_00";
	name_dest=${1};
    else
	usage ${*};
    fi;
    
    # Test directory source
    if test ! -d ${name_src}; then
	echo "${name_src} is an invalid directory";
	exit;
    fi;
    
    # Test directoru dest : if don't exist, create it
    if test ! -d ${name_dest}; then
	mkdir ${name_dest};
    fi;
    
    # Copy and sed
    for i in ${name_src}/*; do
	sed s/Instance_${name_src}/Instance_${name_dest}/ ${i} > tmp;
	mv tmp ${name_dest}/$(basename ${i});
    done
}

copy_test ${*}