// $Id: main.c 145 2010-10-13 18:15:51Z rosiere $

/*
 * All thread execute this routine
 * Initialize the thread and attribute a Workload at each thread
 */

#include <stdlib.h>
#include <stdio.h>

/* #define TEST_ERROR */

#define NB_ITERATION 50

//=====[ my_rand ]==============================================================


static unsigned long my_rand_next = 1;

#define MY_RAND_MAX 32768

int my_rand(void) 
{
  my_rand_next = my_rand_next * 1103515245 + 12345;
  return((unsigned)(my_rand_next/65536) % MY_RAND_MAX);
}

void my_srand(unsigned grain) 
{
  my_rand_next = grain;
}

//=====[ test ]=================================================================

void test_take (int x, int * take, int * not_take)
{
  if ((x&1) == 1) // !!!!
    (*take) ++;
  else
    (*not_take) ++;
}

void test_no_take (int x, int * take, int * not_take)
{
  if ((x&1) != 0) // !!!!
    (*take) ++;
  else
    (*not_take) ++;
}

//=====[ f ]====================================================================

int f (int nb_iteration)
{
#ifdef TEST_ERROR
#define NB_VALUE 1000
  
  const int res_my_rand [NB_VALUE] = // to grain = 1
    {
      16838,  5758, 10113, 17515, 31051,  5627, 23010,  7419, 16212,  4086, 
       2749, 12767,  9084, 12060, 32225, 17543, 25089, 21183, 25137, 25566, 
      26966,  4978, 20495, 10311, 11367, 30054, 17031, 13145, 19882, 25736, 
      30524, 28505, 28394, 22102, 24851, 19067, 12754, 11653,  6561, 27096, 
      13628, 15188, 32085,  4143,  6967, 31406, 24165, 13403, 25562, 24834, 
      31353,   920, 10444, 24803,  7962, 19318,  1422, 31327, 10457,  1945, 
      14479, 29983, 18751,  3894, 18670,  8259, 16248,  7757, 15629, 13306, 
      28606, 13990, 11738, 12516,  1414,  5262, 17116, 22825,  3181, 13134, 
      25343,  8022, 11233,  7536,  9760,  9979, 29071,  1201, 21336, 13061, 
      22160, 24005, 30729,  7644, 27475, 31693, 25514, 14139, 22088, 26521,

       5202,  9171,  4434, 28317, 24582,  6815,  4586,  9653, 26306,  7174, 
      18451, 23448,  6473, 32434,  8193, 14110, 24748, 28210, 29320, 32049, 
      12956, 14162,  4166, 14997,  7793, 32310, 21391, 19799,  7926, 14905, 
      25885,  2582, 15610,  5000,  8052, 30965, 20120, 32380, 15639, 26204, 
      24385, 12475, 15725, 17265,  3214, 19471, 11376,  4697, 25543, 23297, 
      14619, 23087,  3123, 31549, 18065, 24256, 18973, 20901, 25613,  6157, 
       9899,  9267, 22413,  9598, 18526, 13711, 10046, 14566, 18536, 15988, 
      19878, 13626,  4273,  8387,  1171, 32017,  3752, 12388, 21191, 11483, 
      18122, 11744, 18528, 15585,  5363, 20159,  5641, 18176,  9575, 28578, 
      27363, 27685, 29344, 19489, 17713,  5511, 21461, 22626,  8645,  3496, 

      26703,  6270, 13870, 11529, 27499,  4500,  8607,  5808, 15725, 12457, 
      16542, 16474, 11531, 17222,  3952, 17024, 19894, 24015, 18247, 11276,
      26278, 19365,  8746, 21976, 18092, 25851, 29088, 29163,  2231, 26233, 
      29732, 21106,  5411,  9874,  5448,  9344, 27589, 17574,  1191,  6789, 
        695, 11735, 20364, 17040, 17892,  5035, 26979,  1092,   850, 12390, 
      20195,   668, 20531, 29989, 12281, 23902, 12970, 32186, 19571,  3680, 
       7261, 26187, 28529, 24190,   446, 24233, 13708, 11863,  6681,  6001, 
       2499,  3786,  5214, 25829,  1322, 25907, 19628, 13192,  7505,  5990, 
      20129, 10875, 19829, 31591, 12388,  6042,  9833,  1775,  4719,   342, 
      28994, 31392, 20509, 31313, 20677,  1282, 11511,  4795,  3474,  6469, 

       2750,   879, 30989, 30134, 29752, 28364,  4880,  5629,  2235, 21332, 
      24145,  3356,  5243,  3079,  3988,   807, 24979, 31357,   914, 21187, 
       3540, 14022, 10149,   609, 29009, 24833, 16696,  5432, 24999, 28863, 
      16369, 28676, 24077,  7701,  1691, 19840, 28703, 16515, 22229, 32420, 
      19817, 16264, 19324, 29343,  1462, 28929,  3546, 17043, 18967,   325, 
      12683, 15634,  6322, 16642, 25395, 11612, 22864, 29910, 21985, 23126, 
      13988,   685,  6978, 31050, 16476,  6365, 21126,  4193,  8681, 11011, 
      23058,  1249, 31247, 24731, 28650, 20774,  7980, 20833, 27868,  7778, 
      23624, 11115,  1645, 15892, 29408,  7939, 17285, 16202, 28018, 11334, 
       4058,  7062,  3784, 11901,  6684, 14289, 27141, 16702, 26853, 13458, 

      28528, 23363, 21087, 19052, 31235, 15109, 17075, 11755, 10675,   288, 
      32053, 14157,  5758,  5222, 17488, 18945, 10294, 11200,  5171, 14305, 
       7951,  6601, 23608,  7214,  6377, 13865, 25369, 27215,  8030,   177, 
      16849, 11337,  2699, 23099,  8531, 11517, 17567, 28479,  9966,  2597, 
      14885, 12341, 15227, 27149,   785, 29615,  6476, 20753,  4236,  7730, 
      19668, 21210, 27519, 27608,  5142,  6999, 20449, 14246, 18638,  2941, 
      12481, 23726, 16738, 26047, 28947,  3300, 21639, 17996, 23866, 14785, 
      27571, 25356, 12633, 27289, 20551, 20312, 14426,  7357,  8056, 16252, 
      20410,  2384,  4353,  2029, 23579, 27882, 31882, 21577, 31368, 11502, 
      18902, 21012, 31365, 30379, 14256, 19244, 27870, 13365,  9619, 27665, 

      21293, 29441, 19484, 12759, 15400,  6211,  4144, 15335, 22704, 32520, 
      23789, 32121, 21913, 23571, 12369,  2770,  1594,   887, 18093, 32317, 
      11188, 27640,  4295, 12490, 25859,  3106, 24786, 17097,  5062, 27943, 
      31247, 12292, 16846,  3962, 28479, 27584, 21352, 32044, 31695, 16498, 
       4714,  9737, 17346, 28482, 24064, 24946,  9822, 19265,  2868, 12792, 
       3990, 19561, 16959,  9917, 29754, 22104, 25745, 30347, 25825, 11980, 
      18338, 12465, 25490, 24541, 20599,  8097, 26677,   510, 15347, 14667, 
      16316, 10673,  8163, 14647, 12817, 29965, 28871, 16485,  6846, 29937, 
       6241,  5861, 24670, 28166, 26879, 27445, 30407, 11638, 31113, 11101, 
      22516, 28014, 13898, 21452,  8117,  1364, 12926, 20465, 13845, 25032, 

       1696, 18585, 13455,    92, 18288, 31755, 29167, 27412, 25030, 31717, 
      24842, 28572, 26393, 27828, 11805,  3660,  5838,  9046, 18182, 23772, 
      12354, 15377, 14885, 22759, 22934,  1903,  6159, 26145, 10045, 26847, 
      17401, 29783,  4167,   781, 24287,  2347, 23402, 19964, 14711, 10637, 
      20693, 29417, 30937, 24313, 15541,  2528, 23019, 21618,  3716,  5402, 
      16270, 18242,  8468, 22045, 30602, 18286, 30559, 22674, 25146,  1019, 
      31243, 20197, 26870,  7908,   448,  7327, 28485, 17622, 14890, 10883, 
      10943,  1201, 10701, 24682,  3524,  8895, 27276, 24798, 12511, 25522, 
      24311, 25209, 26359,  2912, 28759, 17148, 26683,  2877,  8571, 12334, 
      16331,  7324,   577,   635, 26663, 17061, 20451,  9544, 16984, 28693, 

      19975, 10519, 21472, 19641,  9349, 23391, 30563, 22184, 19958,    41, 
      27666, 23363, 25344,  2410, 28635,  1006, 20068, 26660, 20562, 29323, 
      13764, 21307,  7773, 10683,  9013,  8216, 28834, 15571, 15241,  2303, 
      24754,   928,  3417, 32048, 12018, 19931, 17621, 22209, 14669, 21098, 
      20555,  4662, 12444, 22109, 16760, 25574, 14544, 18339, 30610, 18189, 
      24549, 18320, 24081, 25264,  6022, 24847, 19521, 24628,  7552, 26278, 
      20873,  4029, 32489, 13359, 31352, 30279,  8717, 20560, 23189,  8583, 
        795, 10687, 26339, 23935,  3988, 27703, 27958, 10212, 19567, 10553, 
      13368, 32047, 13068, 20611,  4154, 23429, 28895, 13393, 30908,  5960, 
      30169,  5462, 27323, 23929, 32149, 29305,  9149, 32724, 32584,  6224, 

        413, 26281, 12389, 11357,  4887, 17532,  1555, 12299,  9490, 26460, 
      24911, 14183, 22704, 17412, 20961, 20382,  3608,  5811,  7168, 20794, 
      12286, 13771, 27844,  6684, 11255, 29227, 26960, 27448,  9086,  8526, 
       1211, 26131,  8645, 11552, 18627, 26110, 25149, 17828, 32048, 12559, 
      29668,  4167, 23050, 15588, 17746, 28929, 12410,   791, 25985, 18737, 
      13952,  8576,  1375, 18485, 24922, 16941,  1557, 10700, 31408,  1826, 
       8213, 32301, 23680, 30161, 28390, 22500, 32716,  7768, 28079, 31599, 
      18949, 31357, 12421, 27804, 17717, 16490, 26228, 30112, 12016,  9512, 
      28751,  1015,  2553, 19164,  6200, 30464,  7859, 22212, 13806, 15444,
       5710, 27377, 19417, 21994,  7341, 32706, 26839,  9707, 13593, 22820, 

      23236,  7254, 11688,  5003, 32203,  8788, 23915,  1199, 13424, 24408, 
       6490, 27655, 21593, 13310,  3072, 12038,  5087,  1697, 23526,  7448, 
      17497, 15802, 19649, 30555, 25891,  1020, 18267, 14366, 23408, 12848, 
      29762, 22042, 23252, 31440, 21810, 32626, 19088, 13158,  2370,  2156, 
      13213, 22434, 10193,  2541,   887,  8766, 24112, 27574, 12206, 22418, 
      15373, 22113,  1582,  7670, 23202, 18714, 13897, 32731, 19105, 20253, 
      24201, 29608, 29918,  4338, 11064,  1366, 22970, 15723, 20907, 32202, 
      23379,  1626, 29779,  9206, 32365, 11539, 15233, 29614, 19999, 23205, 
      12028, 26186, 20029, 16343,  7237, 10497, 10377, 14564,  5540, 23808, 
        152, 28918, 22011, 15693,  6790, 16740,  5446, 18015, 16473, 18604
    };
#endif

#ifdef TEST_ERROR
  if (nb_iteration>NB_VALUE)
    {
      printf("Invalid iteration number.\n");
      exit(1);
    }
#endif
  
  my_srand(1);

  int take     = 0;
  int not_take = 0;
  
  for (int i=0; i<nb_iteration; ++i)
    {
      int x = my_rand();
#ifdef TEST_ERROR
      int y = res_my_rand [i];
      
      if (x != y)
        {
          printf("Invalid value\n");
          exit(2);
        }
#endif

      test_take   (x, &take, &not_take);
      test_no_take(x, &take, &not_take);
    }

#ifdef TEST_ERROR
  if ((take+not_take)!=(nb_iteration<<1))
    {
      printf("Invalid sum\n");
      exit(3);
    }
#endif
  
  return take>>1;
}

//=====[ main ]=================================================================

int main()
{
  int take = 0;

  take+=f(NB_ITERATION);

  /* printf("Result : %d/%d\n",take,NB_ITERATION); */

  exit (0);

  while (1);
}
