#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_commit_unit_Parameters_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_commit_unit_Parameters_h

/*
 * $Id: Parameters.h 145 2010-10-13 18:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Types.h"
#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t               _nb_front_end                       ;
  public : uint32_t             * _nb_context                         ;//[nb_front_end]
  public : uint32_t               _nb_rename_unit                     ;
  public : uint32_t               _size_queue                         ;
  public : uint32_t               _nb_bank                            ;
  public : Tretire_ooo_scheme_t   _retire_ooo_scheme                  ;
  public : uint32_t             * _nb_inst_insert                     ;//[nb_rename_unit]
  public : uint32_t             * _nb_inst_retire	                    ;//[nb_rename_unit]
  public : uint32_t               _nb_inst_commit                     ;
  public : uint32_t               _nb_inst_reexecute                  ;
  public : uint32_t               _nb_inst_branch_complete            ;
  public : uint32_t            ** _nb_branch_speculated               ;//[nb_front_end][nb_context]
//public : uint32_t               _size_general_data                  ;
//public : uint32_t               _size_store_queue_ptr               ;
//public : uint32_t               _size_load_queue_ptr                ;
//public : uint32_t               _size_general_register              ;
//public : uint32_t               _size_special_register              ;
  public : Trat_scheme_t        * _rat_scheme                         ;//[nb_rename_unit]
  public : std::vector<uint32_t>* _link_front_end_with_rename_unit    ;//[nb_rename_unit]

  public : Tpriority_t            _priority                           ;
  public : Tload_balancing_t      _load_balancing                     ;
  public : uint32_t               _nb_rename_unit_select              ;
  public : uint32_t               _nb_thread                          ;
  public : uint32_t            ** _translate_num_context_to_num_thread;//[nb_front_end][nb_context]
  public : Trat_scheme_t        * _front_end_rat_scheme               ;//[nb_front_end]
  public : const uint32_t         _nb_bank_access_commit              ;
                               
  public : uint32_t               _max_nb_context          ;
  public : uint32_t               _max_nb_inst_insert      ;
  public : uint32_t               _max_nb_inst_retire      ;
//public : uint32_t               _size_address            ;
//public : uint32_t               _size_front_end_id       ;
//public : uint32_t               _size_context_id         ;
  public : uint32_t               _size_rename_unit_id     ;    
  public : uint32_t               _size_bank               ;
//public : uint32_t               _size_nb_inst            ;
//public : uint32_t               _size_packet_id          ;
  public : uint32_t            ** _array_size_depth        ;//[nb_front_end][nb_context]
//public : uint32_t               _max_size_depth          ;
                               
//public : Tpacket_t              _shift_num_bank          ;
  public : Tpacket_t              _mask_num_bank           ;
  public : Tpacket_t              _shift_num_slot          ;
//public : Tpacket_t              _mask_num_slot           ;
                             
                             
//public : bool                 _have_port_front_end_id  ;
//public : bool                 _have_port_context_id    ;
//public : bool                 _have_port_packet_id     ;
  public : bool                 _have_port_rename_unit_id;
//public : bool                 _have_port_load_queue_ptr;
//public : bool                 _have_port_max_depth     ;
//public : bool              ** _have_port_depth         ;//[nb_front_end][nb_context]
                             
  public : bool               * _have_thread             ;//[nb_thread]

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t               nb_front_end                       ,
			uint32_t             * nb_context                         ,//[nb_front_end]
			uint32_t               nb_rename_unit                     ,
			uint32_t               size_queue                         ,
			uint32_t               nb_bank                            ,
                        Tretire_ooo_scheme_t   retire_ooo_scheme                  ,
			uint32_t             * nb_inst_insert                     ,//[nb_rename_unit]
			uint32_t             * nb_inst_retire                     ,//[nb_rename_unit]
			uint32_t               nb_inst_commit                     ,
			uint32_t               nb_inst_reexecute                  ,
			uint32_t               nb_inst_branch_complete            ,
			uint32_t            ** nb_branch_speculated               ,//[nb_front_end][nb_context]
                        uint32_t               size_nb_inst_decod                 ,
			uint32_t               size_general_data                  ,
			uint32_t               size_store_queue_ptr               ,
			uint32_t               size_load_queue_ptr                ,
			uint32_t               size_general_register              ,
			uint32_t               size_special_register              ,
                        Trat_scheme_t        * rat_scheme                         ,//[nb_rename_unit]
                        std::vector<uint32_t>* link_front_end_with_rename_unit    ,//[nb_rename_unit]
                        Tpriority_t            priority                           ,
			Tload_balancing_t      load_balancing                     ,
			uint32_t               nb_rename_unit_select              ,
                        uint32_t               nb_thread                          ,
                        uint32_t            ** translate_num_context_to_num_thread, //[nb_front_end][nb_context]
                        bool                   is_toplevel=false
			);
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters (void) ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
                                              morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Parameters & x);
  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
