#ifdef SYSTEMC
/*
 * $Id: Register_Address_Translation_unit_function_depth_save_transition.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Register_Address_Translation_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::function_depth_save_transition"
  void Register_Address_Translation_unit::function_depth_save_transition (void)
  {
    log_begin(Register_Address_Translation_unit,FUNCTION);
    log_function(Register_Address_Translation_unit,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) == 0)
      {
	uint32_t gpr = 1;
	uint32_t spr = 0;

	for (uint32_t i=0; i<_param->_nb_front_end; i++)
	  for (uint32_t j=0; j<_param->_nb_context[i]; j++)
	    {
	      RAT_GPR_NOT_SPECULATIVE   [i][j][0]    = 0;
              RAT_GPR_SPECULATIVE_VALID [i][j][0][0] = false;
              RAT_GPR_SPECULATIVE       [i][j][0][0] = 0    ; // not necessary

	      for (uint32_t k=1; k<_param->_nb_general_register_logic; k++)
                {
                  RAT_GPR_NOT_SPECULATIVE    [i][j][k]    = gpr++;
                  for (uint32_t l=0; l<_param->_nb_branch_speculated[i][j]; ++l)
                    {
                      RAT_GPR_SPECULATIVE_VALID  [i][j][l][k] = false;
                      RAT_GPR_SPECULATIVE        [i][j][l][k] = 0    ; // not necessary
                    }
                }
	      for (uint32_t k=0; k<_param->_nb_special_register_logic; k++)
                {
                  RAT_SPR_NOT_SPECULATIVE    [i][j][k]    = spr++;
                  for (uint32_t l=0; l<_param->_nb_branch_speculated[i][j]; ++l)
                    {
                      RAT_SPR_SPECULATIVE_VALID  [i][j][l][k] = false;
                      RAT_SPR_SPECULATIVE        [i][j][l][k] = 0    ; // not necessary
                    }
                }

              for (uint32_t k=0; k<_param->_nb_branch_speculated[i][j]; ++k)
                reg_RAT_USE [i][j][k] = false;
              reg_SAVE_RAT [i][j] = false;
	    }
      }
    else
      {
	// Note : GPR[0] is never write (in decod's stage : write_rd = 0 when num_reg_rd_log == 0)
        bool free_rat [_param->_nb_front_end][_param->_max_nb_context][_param->_max_nb_branch_speculated];
	for (uint32_t i=0; i<_param->_nb_front_end; i++)
	  for (uint32_t j=0; j<_param->_nb_context[i]; j++)
            for (uint32_t k=0; k<_param->_nb_branch_speculated[i][j]; ++k)
              free_rat [i][j][k] = false;

	// =====================================================
	// ====[ RETIRE_EVENT ]=================================
	// =====================================================
        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
            if (PORT_READ(in_RETIRE_EVENT_VAL [i][j]) and internal_RETIRE_EVENT_ACK [i][j])
              {
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * RETIRE_EVENT [%d][%d]",i,j);

                // Test if event have just occure
                //   * if exception -> reset valid table (rat_NOT_SPECULATIVE have the good value)
                
                if (PORT_READ(in_RETIRE_EVENT_STATE [i][j]) == EVENT_STATE_EVENT)
                  switch (PORT_READ(in_RETIRE_EVENT_TYPE [i][j]))
                    {
                    case EVENT_TYPE_BRANCH_MISS_SPECULATION :
                      {
                        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * BRANCH_MISS_SPECULATION - Reset Update Table");

                        reg_SAVE_RAT [i][j] = true;
                        
                        Tdepth_t   depth      = (_param->_have_port_depth)?PORT_READ(in_RETIRE_EVENT_DEPTH[i][j]):0;
                        Tdepth_t   depth_min  = (_param->_have_port_depth)?PORT_READ(in_DEPTH_MIN[i][j]):0;
                        Tdepth_t   depth_max  = (_param->_have_port_depth)?PORT_READ(in_DEPTH_MAX[i][j]):0;
                        Tcontrol_t depth_full = PORT_READ(in_DEPTH_FULL [i][j]);
                        
                        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * depth      : %d",depth);
                        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * depth_min  : %d",depth_min);
                        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * depth_max  : %d",depth_max);
                        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * depth_full : %d",depth_full);

                        Tdepth_t   it        = depth_min;
                        
                        for (uint32_t k=0; k<_param->_nb_branch_speculated[i][j]; ++k)
                          {
                            it = (it-1)%_param->_nb_branch_speculated[i][j];

                            if (it == depth)
                              break;
                            
                            log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"        * flush    : %d",it);
                            
                            free_rat[i][j][it] = true;
                          }
                        
                        break;
                      }
                    case EVENT_TYPE_EXCEPTION :
                      {
                        log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * EXCEPTION - Reset Update Table");
                        
                        reg_SAVE_RAT [i][j] = true;

                        // Reset validity table
                        for (uint32_t k=0; k<_param->_nb_branch_speculated[i][j]; ++k)
                          free_rat [i][j][k] = true;
                        
                        break;
                      }
                    default :
                      {
                        break;
                      }
                    }
              }

	// =====================================================
	// ====[ INSERT ]=======================================
	// =====================================================
	// First : interface insert
        // this instruction is speculative !!!
	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	  // Test transaction
	  if (PORT_READ(in_INSERT_VAL [i]) and internal_INSERT_ACK  [i])
	    {
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * INSERT [%d]",i);

	      Tcontext_t front_end_id = (_param->_have_port_front_end_id)?PORT_READ(in_RENAME_FRONT_END_ID [i]):0;
	      Tcontext_t context_id   = (_param->_have_port_context_id  )?PORT_READ(in_RENAME_CONTEXT_ID   [i]):0;
              Tcontrol_t write_rd     = PORT_READ(in_INSERT_WRITE_RD [i]);
              Tcontrol_t write_re     = PORT_READ(in_INSERT_WRITE_RE [i]);
              Tdepth_t   depth        = (_param->_have_port_depth       )?PORT_READ(in_RENAME_DEPTH        [i]):0;
              Tcontrol_t save_rat     = reg_SAVE_RAT[front_end_id][context_id];
              // TODO SAVE_RAT

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end          : %d",front_end_id);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * context            : %d",context_id);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * depth              : %d",depth);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * save_rat (old)     : %d",save_rat);

              if (save_rat)
                {
// #ifdef DEBUG_TEST
//                   if (reg_RAT_USE[front_end_id][context_id][depth])
//                     throw ERRORMORPHEO(FUNCTION,toString(_("Invalid RAT and need save_rat (%d).\n"),depth));
// #endif
                  reg_RAT_USE[front_end_id][context_id][depth] = true;
                  
                  // new branch, new RAT
                  for (uint32_t num_reg_log=0; num_reg_log<_param->_nb_general_register_logic; num_reg_log++)
                    RAT_GPR_SPECULATIVE_VALID [front_end_id][context_id][depth][num_reg_log] = false;
                  for (uint32_t num_reg_log=0; num_reg_log<_param->_nb_special_register_logic; num_reg_log++)
                    RAT_SPR_SPECULATIVE_VALID [front_end_id][context_id][depth][num_reg_log] = false;
                }

              save_rat = PORT_READ(in_RENAME_SAVE_RAT [i]);
              reg_SAVE_RAT[front_end_id][context_id] = save_rat;

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * save_rat (new)     : %d",save_rat);
	      
	      // Test if write and modifie RAT
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_rd           : %d",write_rd);
	      if (write_rd == 1)
                {
                  Tgeneral_address_t num_reg_rd_log = PORT_READ(in_INSERT_NUM_REG_RD_LOG [i]);
                  Tgeneral_address_t num_reg_rd_phy = PORT_READ(in_INSERT_NUM_REG_RD_PHY [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_log     : %d",num_reg_rd_log);
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_phy     : %d",num_reg_rd_phy);

                  RAT_GPR_SPECULATIVE       [front_end_id][context_id][depth][num_reg_rd_log] = num_reg_rd_phy;
                  RAT_GPR_SPECULATIVE_VALID [front_end_id][context_id][depth][num_reg_rd_log] = true;
                }

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_re           : %d",write_re);
	      if (write_re == 1)
                {
                  Tspecial_address_t num_reg_re_log = PORT_READ(in_INSERT_NUM_REG_RE_LOG [i]);
                  Tspecial_address_t num_reg_re_phy = PORT_READ(in_INSERT_NUM_REG_RE_PHY [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_log     : %d",num_reg_re_log);
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_phy     : %d",num_reg_re_phy);

                  RAT_SPR_SPECULATIVE       [front_end_id][context_id][depth][num_reg_re_log] = num_reg_re_phy;
                  RAT_SPR_SPECULATIVE_VALID [front_end_id][context_id][depth][num_reg_re_log] = true;
                }
	    }

	// =====================================================
	// ====[ RETIRE ]=======================================
	// =====================================================
	// Second : interface retire
	// if event AND event is exception, restore rat_NOT_SPECULATIVE

        for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
          if (PORT_READ(in_RETIRE_VAL [i]) and internal_RETIRE_ACK [i])
            {
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * RETIRE [%d]",i);

              Tcontext_t front_end_id = (_param->_have_port_front_end_id)?PORT_READ(in_RETIRE_FRONT_END_ID [i]):0;
              Tcontext_t context_id   = (_param->_have_port_context_id  )?PORT_READ(in_RETIRE_CONTEXT_ID   [i]):0;
              Tcontrol_t write_rd     = PORT_READ(in_RETIRE_WRITE_RD [i]);
              Tcontrol_t write_re     = PORT_READ(in_RETIRE_WRITE_RE [i]);
              Tcontrol_t restore      = PORT_READ(in_RETIRE_RESTORE  [i]);

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end_id       : %d",front_end_id);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * context_id         : %d",context_id  );
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * restore            : %d",restore     );

              // Test if write and have not a previous update
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_rd           : %d",write_rd);
              if (write_rd == 1)
                {
                  Tgeneral_address_t num_reg_rd_log     = PORT_READ(in_RETIRE_NUM_REG_RD_LOG     [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_log     : %d",num_reg_rd_log    );

                  if (not restore)
                    {
                  Tgeneral_address_t num_reg_rd_phy_new = PORT_READ(in_RETIRE_NUM_REG_RD_PHY_NEW [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_phy_new : %d",num_reg_rd_phy_new);

                  RAT_GPR_NOT_SPECULATIVE [front_end_id][context_id][num_reg_rd_log] = num_reg_rd_phy_new;
                    }
                }

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_re           : %d",write_re);
              if (write_re == 1)
                {
                  Tspecial_address_t num_reg_re_log     = PORT_READ(in_RETIRE_NUM_REG_RE_LOG     [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_log     : %d",num_reg_re_log    );

                  if (not restore)
                    {
                  Tspecial_address_t num_reg_re_phy_new = PORT_READ(in_RETIRE_NUM_REG_RE_PHY_NEW [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_phy_new : %d",num_reg_re_phy_new);

                  RAT_SPR_NOT_SPECULATIVE [front_end_id][context_id][num_reg_re_log] = num_reg_re_phy_new;
                    }
                }
            }

	// =====================================================
	// ====[ DEPTH ]========================================
	// =====================================================
#if 1
        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
            {
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * DEPTH[%d][%d]",i,j);

              Tdepth_t   depth_min  = (_param->_have_port_depth)?PORT_READ(in_DEPTH_MIN[i][j]):0;
              Tdepth_t   depth_max  = (_param->_have_port_depth)?PORT_READ(in_DEPTH_MAX[i][j]):0;
              Tcontrol_t depth_full = PORT_READ(in_DEPTH_FULL [i][j]);

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * depth_min  : %d",depth_min);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * depth_max  : %d",depth_max);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * depth_full : %d",depth_full);
              
              if (not depth_full)
                {
                  Tdepth_t depth     = depth_max;

                  for (uint32_t k=0; k<_param->_nb_branch_speculated[i][j]; ++k)
                    {
                      if (depth == depth_min)
                        break;

                      if (reg_RAT_USE[i][j][depth])
                        {
                          log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * flush    : %d",depth);
                  
                          free_rat [i][j][depth] = true;
                          // reg_RAT_USE[i][j][depth] = false;

                          // for (uint32_t l=0; l<_param->_nb_general_register_logic; l++)
                          //   RAT_GPR_SPECULATIVE_VALID  [i][j][depth][l] = false;
                          // for (uint32_t l=0; l<_param->_nb_special_register_logic; l++)
                          //   RAT_SPR_SPECULATIVE_VALID  [i][j][depth][l] = false;
                        }

                      depth = (depth+1)%_param->_nb_branch_speculated[i][j];
                    }
                }
            }
#endif
	// =====================================================
	// ====[ FREE RAT ]=====================================
	// =====================================================
        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
            for (uint32_t k=0; k<_param->_nb_branch_speculated[i][j]; ++k)
              if (free_rat[i][j][k])
                {
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * Free RAT : [%d][%d][%d]",i,j,k);
                  
                  reg_RAT_USE[i][j][k] = false;
                  
                  for (uint32_t l=0; l<_param->_nb_general_register_logic; l++)
                    RAT_GPR_SPECULATIVE_VALID  [i][j][k][l] = false;
                  for (uint32_t l=0; l<_param->_nb_special_register_logic; l++)
                    RAT_SPR_SPECULATIVE_VALID  [i][j][k][l] = false;
                }

      }

#if (DEBUG >= DEBUG_TRACE) and (DEBUG_Register_Address_Translation_unit == true)
    {
      uint32_t limit = 4;
      
      log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * Dump RAT (Register_Address_Translation_unit)");
      for (uint32_t i=0; i<_param->_nb_front_end; ++i)
        for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
          {
            log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end[%d].context[%d] - SAVE_RAT : %d",i,j,reg_SAVE_RAT[i][j]);
              
            for (uint32_t l=0; l<_param->_nb_general_register_logic; l+=limit)
              {
                std::string str = "";
                for (uint32_t x=0; x<limit; x++)
                  {
                    uint32_t index = l+x;
                    if (index >= _param->_nb_general_register_logic)
                      break;
                    else
                      str+=toString("GPR[%.4d]       -   %.5d | ",index,RAT_GPR_NOT_SPECULATIVE [i][j][index]);
                  }
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * %s",str.c_str());
              }

            for (uint32_t k=0; k<_param->_nb_branch_speculated[i][j]; ++k)
              {
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * GPR      [%.4d] - USE : %d",k,reg_RAT_USE [i][j][k]);

                for (uint32_t l=0; l<_param->_nb_general_register_logic; l+=limit)
                  {
                    std::string str = "";
                    for (uint32_t x=0; x<limit; x++)
                      {
                        uint32_t index = l+x;
                        if (index >= _param->_nb_general_register_logic)
                          break;
                        else
                          str+=toString("GPR[%.4d][%.4d] - %.1d %.5d | ",index,k,RAT_GPR_SPECULATIVE_VALID [i][j][k][index],RAT_GPR_SPECULATIVE [i][j][k][index]);
                      }
                    log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * %s",str.c_str());
                  }
              }

            for (uint32_t l=0; l<_param->_nb_special_register_logic; l+=limit)
              {
                std::string str = "";
                
                for (uint32_t x=0; x<limit; x++)
                  {
                    uint32_t index = l+x;
                    if (index >= _param->_nb_special_register_logic)
                      break;
                    else
                      str+=toString("SPR[%.4d]       -   %.5d | ",index,RAT_SPR_NOT_SPECULATIVE [i][j][index]);
                  }
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * %s",str.c_str());
              }

      
            for (uint32_t k=0; k<_param->_nb_branch_speculated[i][j]; ++k)
              {
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * SPR      [%.4d] - USE : %d",k,reg_RAT_USE [i][j][k]);
                
                for (uint32_t l=0; l<_param->_nb_special_register_logic; l+=limit)
                  {
                    std::string str = "";
                    
                    for (uint32_t x=0; x<limit; x++)
                      {
                        uint32_t index = l+x;
                        if (index >= _param->_nb_special_register_logic)
                          break;
                        else
                          str+=toString("SPR[%.4d][%.4d] - %.1d %.5d | ",index,k,RAT_SPR_SPECULATIVE_VALID [i][j][k][index],RAT_SPR_SPECULATIVE [i][j][k][index]);
                      }
                    log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * %s",str.c_str());
                  }
              }
          }
    }
#endif

    log_end(Register_Address_Translation_unit,FUNCTION);
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
