#ifdef SYSTEMC
/*
 * $Id: Register_Address_Translation_unit_function_one_save_transition.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Register_Address_Translation_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::function_one_save_transition"
  void Register_Address_Translation_unit::function_one_save_transition (void)
  {
    log_begin(Register_Address_Translation_unit,FUNCTION);
    log_function(Register_Address_Translation_unit,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) == 0)
      {
	uint32_t gpr = 1;
	uint32_t spr = 0;

	for (uint32_t i=0; i<_param->_nb_front_end; i++)
	  for (uint32_t j=0; j<_param->_nb_context[i]; j++)
	    {
	      RAT_GPR_NOT_SPECULATIVE   [i][j][0]    = 0;
              RAT_GPR_SPECULATIVE_VALID [i][j][0][0] = false;
              RAT_GPR_SPECULATIVE       [i][j][0][0] = 0    ; // not necessary

	      for (uint32_t k=1; k<_param->_nb_general_register_logic; k++)
                {
                  RAT_GPR_NOT_SPECULATIVE    [i][j][k]    = gpr++;
                  RAT_GPR_SPECULATIVE_VALID  [i][j][0][k] = false;
                  RAT_GPR_SPECULATIVE        [i][j][0][k] = 0    ; // not necessary
                }
	      for (uint32_t k=0; k<_param->_nb_special_register_logic; k++)
                {
                  RAT_SPR_NOT_SPECULATIVE    [i][j][k]    = spr++;
                  RAT_SPR_SPECULATIVE_VALID  [i][j][0][k] = false;
                  RAT_SPR_SPECULATIVE        [i][j][0][k] = 0    ; // not necessary
                }
	    }
      }
    else
      {
	// Note : GPR[0] is never write (in decod's stage : write_rd = 0 when num_reg_rd_log == 0)

	// =====================================================
	// ====[ RETIRE_EVENT ]=================================
	// =====================================================
        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
            if (PORT_READ(in_RETIRE_EVENT_VAL [i][j]) and internal_RETIRE_EVENT_ACK [i][j])
              // Test if event have just occure
              if (PORT_READ(in_RETIRE_EVENT_STATE [i][j]) == EVENT_STATE_EVENT)
                {
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * Reset Update Table");
                  
                  // Reset validity table
                  for (uint32_t k=0; k<_param->_nb_general_register_logic; k++)
                    RAT_GPR_SPECULATIVE_VALID [i][j][0][k] = false;
                  for (uint32_t k=0; k<_param->_nb_special_register_logic; k++)
                    RAT_SPR_SPECULATIVE_VALID [i][j][0][k] = false;
                }

	// =====================================================
	// ====[ INSERT ]=======================================
	// =====================================================
	// First : interface insert
        // this instruction is speculative !!!
	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	  // Test transaction
	  if (PORT_READ(in_INSERT_VAL [i]) and internal_INSERT_ACK  [i])
	    {
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * INSERT [%d]",i);

	      Tcontext_t front_end_id = (_param->_have_port_front_end_id)?PORT_READ(in_RENAME_FRONT_END_ID [i]):0;
	      Tcontext_t context_id   = (_param->_have_port_context_id  )?PORT_READ(in_RENAME_CONTEXT_ID   [i]):0;
              Tcontrol_t write_rd     = PORT_READ(in_INSERT_WRITE_RD [i]);
              Tcontrol_t write_re     = PORT_READ(in_INSERT_WRITE_RE [i]);

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end          : %d",front_end_id);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * context            : %d",context_id);
	      
	      // Test if write and modifie RAT
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_rd           : %d",write_rd);
	      if (write_rd == 1)
                {
                  Tgeneral_address_t num_reg_rd_log = PORT_READ(in_INSERT_NUM_REG_RD_LOG [i]);
                  Tgeneral_address_t num_reg_rd_phy = PORT_READ(in_INSERT_NUM_REG_RD_PHY [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_log     : %d",num_reg_rd_log);
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_phy     : %d",num_reg_rd_phy);

                  RAT_GPR_SPECULATIVE       [front_end_id][context_id][0][num_reg_rd_log] = num_reg_rd_phy;
                  RAT_GPR_SPECULATIVE_VALID [front_end_id][context_id][0][num_reg_rd_log] = true;
                }

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_re           : %d",write_re);
	      if (write_re == 1)
                {
                  Tspecial_address_t num_reg_re_log = PORT_READ(in_INSERT_NUM_REG_RE_LOG [i]);
                  Tspecial_address_t num_reg_re_phy = PORT_READ(in_INSERT_NUM_REG_RE_PHY [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_log     : %d",num_reg_re_log);
                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_phy     : %d",num_reg_re_phy);

                  RAT_SPR_SPECULATIVE       [front_end_id][context_id][0][num_reg_re_log] = num_reg_re_phy;
                  RAT_SPR_SPECULATIVE_VALID [front_end_id][context_id][0][num_reg_re_log] = true;
                }
	    }

	// =====================================================
	// ====[ RETIRE ]=======================================
	// =====================================================
	// Second : interface retire
	//  (because if an event on the same thread : the instruction is already renamed)
	for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	  if (PORT_READ(in_RETIRE_VAL [i]) and internal_RETIRE_ACK [i])
	    {
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * RETIRE [%d]",i);

	      // if no event : no effect, because the RAT content the most recently register
	      // but if they have a event (exception or miss speculation), the rat must restore the oldest value
	      // To restore the oldest valid value, we use the rat_update_table. if the bit is unset, also they have none update on this register
	      // the retire interface became of the Re Order Buffer, also is in program sequence !

              Tcontext_t front_end_id = (_param->_have_port_front_end_id)?PORT_READ(in_RETIRE_FRONT_END_ID [i]):0;
              Tcontext_t context_id   = (_param->_have_port_context_id  )?PORT_READ(in_RETIRE_CONTEXT_ID   [i]):0;
              Tcontrol_t write_rd     = PORT_READ(in_RETIRE_WRITE_RD [i]);
              Tcontrol_t write_re     = PORT_READ(in_RETIRE_WRITE_RE [i]);
              Tcontrol_t restore      = PORT_READ(in_RETIRE_RESTORE  [i]);

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end_id       : %d",front_end_id);
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * context_id         : %d",context_id  );
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * restore            : %d",restore     );

              // Test if write and have not a previous update
              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_rd           : %d",write_rd);
              if (write_rd == 1)
                {
                  Tgeneral_address_t num_reg_rd_log     = PORT_READ(in_RETIRE_NUM_REG_RD_LOG     [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_log     : %d",num_reg_rd_log    );

                  if (not restore)
                    {
                  Tgeneral_address_t num_reg_rd_phy_new = PORT_READ(in_RETIRE_NUM_REG_RD_PHY_NEW [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_rd_phy_new : %d",num_reg_rd_phy_new);

                  RAT_GPR_NOT_SPECULATIVE [front_end_id][context_id][num_reg_rd_log] = num_reg_rd_phy_new;
                    }
                }

              log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * write_re           : %d",write_re);
              if (write_re == 1)
                {
                  Tspecial_address_t num_reg_re_log     = PORT_READ(in_RETIRE_NUM_REG_RE_LOG     [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_log     : %d",num_reg_re_log    );

                  if (not restore)
                    {
                  Tspecial_address_t num_reg_re_phy_new = PORT_READ(in_RETIRE_NUM_REG_RE_PHY_NEW [i]);

                  log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * num_reg_re_phy_new : %d",num_reg_re_phy_new);

                  RAT_SPR_NOT_SPECULATIVE [front_end_id][context_id][num_reg_re_log] = num_reg_re_phy_new;
                    }
                }

	    }
      }

#if (DEBUG >= DEBUG_TRACE) and (DEBUG_Register_Address_Translation_unit == true)
    {
      uint32_t limit = 4;
      
      log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"  * Dump RAT (Register_Address_Translation_unit)");
      for (uint32_t i=0; i<_param->_nb_front_end; ++i)
        for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
          {
            log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"    * front_end[%d].context[%d]",i,j);
          
            for (uint32_t k=0; k<_param->_nb_general_register_logic; k+=limit)
              {
                std::string str = "";
                for (uint32_t x=0; x<limit; x++)
                  {
                    uint32_t index = k+x;
                    if (index >= _param->_nb_general_register_logic)
                      break;
                    else
                      str+=toString("GPR[%.4d] - %.1d %.5d (%.5d) | ",index,RAT_GPR_SPECULATIVE_VALID [i][j][0][index],RAT_GPR_SPECULATIVE [i][j][0][index],RAT_GPR_NOT_SPECULATIVE [i][j][index]);
                  }
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * %s",str.c_str());
              }
      
            for (uint32_t k=0; k<_param->_nb_special_register_logic; k+=limit)
              {
                std::string str = "";
                
                for (uint32_t x=0; x<limit; x++)
                  {
                    uint32_t index = k+x;
                    if (index >= _param->_nb_special_register_logic)
                      break;
                    else
                      str+=toString("SPR[%.4d] - %.1d %.5d (%.5d) | ",index,RAT_SPR_SPECULATIVE_VALID [i][j][0][index],RAT_SPR_SPECULATIVE [i][j][0][index],RAT_SPR_NOT_SPECULATIVE [i][j][index]);
                  }
                log_printf(TRACE,Register_Address_Translation_unit,FUNCTION,"      * %s",str.c_str());
              }
          }
    }
#endif

#ifdef DEBUG_TEST
# if 1
    {
      for (uint32_t i=0; i<_param->_nb_front_end; ++i)
        for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
          {
            for (uint32_t x=0; x<_param->_nb_general_register_logic; ++x)
              for (uint32_t y=x+1; y<_param->_nb_general_register_logic; ++y)
                {
                  if (RAT_GPR_SPECULATIVE_VALID [i][j][0][x] and
                      RAT_GPR_SPECULATIVE_VALID [i][j][0][y] and
                      (RAT_GPR_SPECULATIVE[i][j][0][x] == RAT_GPR_SPECULATIVE[i][j][0][y]))
                    throw ERRORMORPHEO (FUNCTION,toString(_("In RAT, RAT_GPR_SPECULATIVE[%d][%d][0][%d] == RAT_GPR_SPECULATIVE[%d][%d][0][%d] == %d"),i,j,x,i,j,y,RAT_GPR_SPECULATIVE[i][j][0][x]));
                  if (RAT_GPR_NOT_SPECULATIVE[i][j][x] == RAT_GPR_NOT_SPECULATIVE[i][j][y])
                    throw ERRORMORPHEO (FUNCTION,toString(_("In RAT, RAT_GPR_NOT_SPECULATIVE[%d][%d][%d] == RAT_GPR_NOT_SPECULATIVE[%d][%d][%d] == %d"),i,j,x,i,j,y,RAT_GPR_NOT_SPECULATIVE[i][j][x]));
                  
                }
            for (uint32_t x=0; x<_param->_nb_special_register_logic; ++x)
              for (uint32_t y=x+1; y<_param->_nb_special_register_logic; ++y)
                {
                  if(RAT_SPR_SPECULATIVE_VALID [i][j][0][x] and
                     RAT_SPR_SPECULATIVE_VALID [i][j][0][y] and
                     (RAT_SPR_SPECULATIVE[i][j][0][x] == RAT_SPR_SPECULATIVE[i][j][0][y]))
                    throw ERRORMORPHEO (FUNCTION,toString(_("In RAT, RAT_SPR_SPECULATIVE[%d][%d][0][%d] == RAT_SPR_SPECULATIVE[%d][%d][0][%d] == %d"),i,j,x,i,j,y,RAT_SPR_SPECULATIVE[i][j][0][x]));
                  if (RAT_SPR_NOT_SPECULATIVE[i][j][x] == RAT_SPR_NOT_SPECULATIVE[i][j][y])
                    throw ERRORMORPHEO (FUNCTION,toString(_("In RAT, RAT_SPR_NOT_SPECULATIVE[%d][%d][%d] == RAT_SPR_NOT_SPECULATIVE[%d][%d][%d] == %d"),i,j,x,i,j,y,RAT_SPR_NOT_SPECULATIVE[i][j][x]));
                  
                }
          }
      
    }
# endif
#endif

    log_end(Register_Address_Translation_unit,FUNCTION);
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
