/*
 * $Id: Register_Address_Translation_unit.cpp 145 2010-10-13 18:15:51Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Register_Address_Translation_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::Register_Address_Translation_unit"
  Register_Address_Translation_unit::Register_Address_Translation_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"Begin");

// #if DEBUG_Register_Address_Translation_unit == true
//     log_printf(INFO,Register_Address_Translation_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        // Function pointer
        switch (_param->_rat_scheme)
          {
          case RAT_NO_SAVE    :
            {
              // function_constant        = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Register_Address_Translation_unit::function_no_save_constant       ;
              // function_transition      = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Register_Address_Translation_unit::function_no_save_transition     ;
              // function_genMealy_rename = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Register_Address_Translation_unit::function_no_save_genMealy_rename;

              break;
            }

          case RAT_ONE_SAVE   :
            {
              function_constant        = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Register_Address_Translation_unit::function_one_save_constant       ;
              function_transition      = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Register_Address_Translation_unit::function_one_save_transition     ;
              function_genMealy_rename = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Register_Address_Translation_unit::function_one_save_genMealy_rename;

              break;
            }

          case RAT_DEPTH_SAVE :
            {
              function_constant        = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Register_Address_Translation_unit::function_depth_save_constant       ;
              function_transition      = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Register_Address_Translation_unit::function_depth_save_transition     ;
              function_genMealy_rename = &morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Register_Address_Translation_unit::function_depth_save_genMealy_rename;

              break;
            }

          default             :
            {
              break;
            }
          }

#ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Method - constant");

	SC_METHOD (constant);
// 	dont_initialize ();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
#endif

	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Method - genMealy_rename");

	SC_METHOD (genMealy_rename);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg() // need internal register
		  << (*(in_NRESET));

        for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
          {
            if (_param->_have_port_front_end_id) 
            sensitive << (*(in_RENAME_FRONT_END_ID   [i]));
            if (_param->_have_port_context_id  )
            sensitive << (*(in_RENAME_CONTEXT_ID     [i]));
            
            sensitive << (*(in_RENAME_VAL            [i])) // Not necessary
                      << (*(in_RENAME_NUM_REG_RA_LOG [i]))
                      << (*(in_RENAME_NUM_REG_RB_LOG [i]))
                      << (*(in_RENAME_NUM_REG_RC_LOG [i]))
                      << (*(in_RENAME_NUM_REG_RD_LOG [i]))
                      << (*(in_RENAME_NUM_REG_RE_LOG [i]));

            if (_param->_rat_scheme == RAT_DEPTH_SAVE)
            sensitive << (*(in_RENAME_SAVE_RAT       [i]));
          }
        for (uint32_t i=0; i<_param->_nb_front_end; ++i)
          for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
            {
              sensitive << (*(in_RETIRE_EVENT_VAL   [i][j]))
                        << (*(in_RETIRE_EVENT_STATE [i][j]))
                        << (*(in_DEPTH_FULL         [i][j]));
              if (_param->_have_port_depth)
              sensitive << (*(in_DEPTH_MIN          [i][j]))
                        << (*(in_DEPTH_MAX          [i][j]));
            }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::~Register_Address_Translation_unit"
  Register_Address_Translation_unit::~Register_Address_Translation_unit (void)
  {
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Register_Address_Translation_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"End");
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
