#ifdef SYSTEMC
/*
 * $Id: RegisterFile_deallocation.cpp 146 2011-02-01 20:57:54Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/include/RegisterFile.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {


  void RegisterFile::deallocation (void)
  {
    log_printf(FUNC,RegisterFile,"deallocation","Begin");

#ifdef SYSTEMCASS_SPECIFIC
    delete in_CLOCK;
    delete in_NRESET;
    // ----- Interface Read
    for (uint32_t i=0; i<_param->_nb_port_read; i++)
      {
    delete     in_READ_VAL    [i];
    delete    out_READ_ACK    [i];
    if (_param->_have_port_address == true)
    delete     in_READ_ADDRESS[i];
    delete    out_READ_DATA   [i];
      }

    delete []  in_READ_VAL    ;
    delete [] out_READ_ACK    ;
    if (_param->_have_port_address == true)
    delete []  in_READ_ADDRESS;
    delete [] out_READ_DATA   ;

    // ----- Interface Write
    for (uint32_t i=0; i<_param->_nb_port_write; i++)
      {
    delete     in_WRITE_VAL    [i];
    delete    out_WRITE_ACK    [i];
    if (_param->_have_port_address == true)
    delete     in_WRITE_ADDRESS[i];
    delete     in_WRITE_DATA   [i];
      }

    delete []  in_WRITE_VAL    ;
    delete [] out_WRITE_ACK    ;
    if (_param->_have_port_address == true)
    delete []  in_WRITE_ADDRESS;
    delete []  in_WRITE_DATA   ;
#endif

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

//   delete _component;

    if (_param->_instance == instance_RegisterFile_Monolithic)
      delete component_RegisterFile_Monolithic;
    else
      {
	if (_param->_instance == instance_RegisterFile_Internal_Banked)
	  delete component_RegisterFile_Internal_Banked;
	else
	  delete component_RegisterFile_Multi_Banked;
      }

    log_printf(FUNC,RegisterFile,"deallocation","End");
  };

}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
