#!/bin/bash

function usage ()
{
    echo "${0} params";
    echo "erase line with params";
    exit 1;
}

function del_param ()
{
    local file=${1};
    shift;
    local -a params=(${*});

    # no separator
    SAVEIFS=${IFS};
    IFS="";

    while read line; do

        local find=0;

        for param in ${params[*]}; do 
            local count=$(echo  "${line}"| grep -c ${param});

            if test ${count} -ne 0; then
                find=1;
                break;
            fi;
        done;

        if test ${find} -eq 0; then
            echo "${line}";
        fi;

    done < ${file};

    IFS=${SAVEIFS};
}

function del_file ()
{
    local file=${1};

    echo "  * ${file}";
    del_param ${*} > tmp;
    mv tmp ${file};
}

function del_files ()
{
    for file in *.cfg; do 
        del_file ${file} ${*};
    done 
}

function main ()
{
    if test ${#} -eq 0; then
        usage ${*};
    fi;
    
    echo "delete parameters : ${*}";

#   del_param debug.cfg ${*};
    del_files ${1};
}

main ${*};
#del_param debug.cfg ;

