/*
 * $Id: main.cpp 146 2011-02-01 20:57:54Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/SelfTest/include/test.h"

#define NB_PARAMS 28

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * predictor_scheme           (Tpredictor_t )\n"));
  err (_(" * nb_inst_predict            (uint32_t     )\n"));
  err (_(" * nb_inst_update             (uint32_t     )\n"));
  err (_(" * size_address               (uint32_t     )\n"));
  err (_(" * have_bht               [3] (bool         )\n"));
  err (_(" * bht_size_shifter       [3] (uint32_t     )\n"));
  err (_(" * bht_nb_shifter         [3] (uint32_t     )\n"));
  err (_(" * have_pht               [3] (bool         )\n"));
  err (_(" * pht_size_counter       [3] (uint32_t     )\n"));
  err (_(" * pht_nb_counter         [3] (uint32_t     )\n"));
  err (_(" * pht_size_address_share [3] (uint32_t     )\n"));
  err (_(" * pht_scheme             [3] (Tpht_scheme_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  Tpredictor_t  _predictor_scheme = fromString<Tpredictor_t>(argv[x++]);
  uint32_t      _nb_inst_predict  = fromString<uint32_t    >(argv[x++]);
  uint32_t      _nb_inst_update   = fromString<uint32_t    >(argv[x++]);
  uint32_t      _size_address     = fromString<uint32_t    >(argv[x++]);
  bool          _have_bht               [3];
  uint32_t      _bht_size_shifter       [3];
  uint32_t      _bht_nb_shifter         [3];
  bool          _have_pht               [3];
  uint32_t      _pht_size_counter       [3];
  uint32_t      _pht_nb_counter         [3];
  uint32_t      _pht_size_address_share [3];
  Tpht_scheme_t _pht_scheme             [3];

  for (uint32_t i=0; i<3; i++)
    {
      _have_bht               [i] = fromString<bool          >(argv[x++]);
      _bht_size_shifter       [i] = fromString<uint32_t      >(argv[x++]);
      _bht_nb_shifter         [i] = fromString<uint32_t      >(argv[x++]);
      _have_pht               [i] = fromString<bool          >(argv[x++]);
      _pht_size_counter       [i] = fromString<uint32_t      >(argv[x++]);
      _pht_nb_counter         [i] = fromString<uint32_t      >(argv[x++]);
      _pht_size_address_share [i] = fromString<uint32_t      >(argv[x++]);
      _pht_scheme             [i] = fromString<Tpht_scheme_t >(argv[x++]);
    }
  
  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::Parameters
	(_predictor_scheme      ,
	 _nb_inst_predict       ,
	 _nb_inst_update        ,
	 _size_address          ,
	 _have_bht              ,
	 _bht_size_shifter      ,
	 _bht_nb_shifter        ,
	 _have_pht              ,
	 _pht_size_counter      ,
	 _pht_nb_counter        ,
	 _pht_size_address_share,
	 _pht_scheme            ,
         true // is_toplevel
         );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
