/*
 * $Id: RegisterFile.cpp 146 2011-02-01 20:57:54Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/include/RegisterFile.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {


  RegisterFile::RegisterFile (
#ifdef SYSTEMC
			      sc_module_name name,
#else
			      std::string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics             * param_statistics,
#endif
			      morpheo::behavioural::generic::registerfile::Parameters * param,
			      Tusage_t usage):
    _name              (name)
    ,_param            (param)
    ,_usage (usage)
  {
    log_printf(FUNC,RegisterFile,"RegisterFile","Begin");

#ifdef SYSTEMC
    log_printf(INFO,RegisterFile,"RegisterFile","Allocation");

    allocation (
# ifdef STATISTICS
		param_statistics
# endif
		);
#endif

#ifdef STATISTICS
    if (_param->_instance == instance_RegisterFile_Monolithic)
      _stat = component_RegisterFile_Monolithic->_stat;
    else
      {
	if (_param->_instance == instance_RegisterFile_Internal_Banked)
	  _stat = component_RegisterFile_Internal_Banked->_stat;
	else
	  _stat = component_RegisterFile_Multi_Banked->_stat;
      }
#endif

    log_printf(FUNC,RegisterFile,"RegisterFile","End");
  };
  
  RegisterFile::~RegisterFile (void)
  {
    log_printf(FUNC,RegisterFile,"~RegisterFile","Begin");

#ifdef SYSTEMC
    log_printf(INFO,RegisterFile,"~RegisterFile","Deallocation");

    deallocation ();
#endif

    log_printf(FUNC,RegisterFile,"~RegisterFile","End");
  };

}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
