#ifndef morpheo_behavioural_Stat_type_h
#define morpheo_behavioural_Stat_type_h

#include <string>
#include <map>
#include <utility>
#include <cassert>
#include <stdint.h>

namespace morpheo {
namespace behavioural {

  typedef double counter_t ;

  typedef enum{add, sub, mul, div, inc, dec} operator_t;

#ifdef STATISTICS

  typedef enum{TYPE_VARIABLE, TYPE_COUNTER} counter_type_t;

//typedef std::pair<operator_t, std::string> pair_operator_string_t;
//typedef std::pair<std::string, operator_t> pair_string_operator_t;

  class counters_t
  {
  private : const uint32_t     _nb_counter;
  private :       counter_t ** _counter;

  public  : counters_t (uint32_t nb_counter):
    _nb_counter (nb_counter+1)
    {
      assert(nb_counter>0);

      _counter = new counter_t * [_nb_counter];
    }

  // public : counters_t (const counters_t & x):
  //   _nb_counter (x._nb_counter)
  //   {
  //     _counter = new counter_t [_nb_counter];
      
  //     for (uint32_t i=0; i<_nb_counter; ++i)
  //       _counter[i] = x._counter[i];
  //   }
    
  public  : ~counters_t (void)
    {
      delete [] _counter;
    }

  public  : void set_counter (counter_t * counter,
                              uint32_t    index)
    {
      assert((index >= 0) and (index < _nb_counter));

      _counter [index] = counter;
    }

  // public : friend const counters_t  operator+ (const counters_t & left,
  //                                              const uint32_t     right)
  //   {
  //     assert((right >= 0) and (right <= left._nb_counter));
      
  //     counters_t tmp=left;
      
  //     tmp._counter[right] ++;
    
  //     return tmp;
  //   }

  public : const counters_t & operator+= (const uint32_t value)
    {
      assert((value >= 0) and (value <= _nb_counter));
      
      (*_counter[value]) ++;
      
      return *this;
    }

  };

#endif

};
};
#endif
