/*
 * $Id: Write_unit.cpp 146 2011-02-01 20:57:54Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/include/Write_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {


#undef  FUNCTION
#define FUNCTION "Write_unit::Write_unit"
  Write_unit::Write_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Write_unit,FUNCTION);

// #if DEBUG_Write_unit == true
//     log_printf(INFO,Write_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Write_unit,FUNCTION,_("<%s> Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Write_unit,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Write_unit,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Write_unit,FUNCTION,_("<%s> Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
      }
# endif
#endif
    log_end(Write_unit,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Write_unit::~Write_unit"
  Write_unit::~Write_unit (void)
  {
    log_begin(Write_unit,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Write_unit,FUNCTION,_("<%s> Generate Statistics file"),_name.c_str());

	delete _stat;
      }
#endif

    log_printf(INFO,Write_unit,FUNCTION,_("<%s> Deallocation"),_name.c_str());
    deallocation ();

    log_end(Write_unit,FUNCTION);
  };

}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
