#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_Parameters_h

/*
 * $Id: Parameters.h 146 2011-02-01 20:57:54Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/include/Types.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Parameters.h"
#include <set>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
    // unit occurence
  public : uint32_t              _nb_read_unit                                  ;
  public : uint32_t              _nb_functionnal_unit                           ;
  public : uint32_t              _nb_load_store_unit                            ;
  public : uint32_t              _nb_write_unit                                 ;
    // generic parameters                                                             
  public : uint32_t              _nb_context                                    ;
  public : uint32_t              _nb_front_end                                  ;
  public : uint32_t              _nb_ooo_engine                                 ;
  public : uint32_t              _nb_packet                                     ;
//public : uint32_t              _size_general_data                             ;
//public : uint32_t              _size_special_data                             ;
    // specific parameters                                                            
    //  * functionnal_unit                                                            
  public : uint32_t            * _nb_inst_functionnal_unit                      ; //[nb_functionnal_unit]
  public : execute_timing_t  *** _timing                                        ; //[nb_functionnal_unit][nb_type][nb_operation]
  public : morpheo::behavioural::custom::custom_information_t (*_get_custom_information) (void);

    //  * load_store_unit    
  public : uint32_t            * _size_store_queue                              ; //[nb_load_store_unit]
  public : uint32_t            * _size_load_queue                               ; //[nb_load_store_unit]
  public : uint32_t            * _size_speculative_access_queue                 ; //[nb_load_store_unit]
  public : uint32_t            * _nb_store_queue_bank                           ; //[nb_load_store_unit]
  public : uint32_t            * _nb_load_queue_bank                            ; //[nb_load_store_unit]
  public : uint32_t            * _nb_port_check                                 ; //[nb_load_store_unit]
  public : Tspeculative_load_t * _speculative_load                              ; //[nb_load_store_unit]
  public : Tpredictor_t        * _speculative_commit_predictor_scheme           ; //[nb_load_store_unit]
  /* public : uint32_t           ** _lsu_pht_size_counter                          ; //[nb_load_store_unit][1] */
  /* public : uint32_t           ** _lsu_pht_nb_counter                            ; //[nb_load_store_unit][1] */
  public : uint32_t            * _nb_bypass_memory                              ; //[nb_load_store_unit]
  public : uint32_t            * _nb_cache_port                                 ; //[nb_load_store_unit]
  public : uint32_t            * _nb_inst_memory                                ; //[nb_load_store_unit]
    //  * read_unit                                                                   
  public : uint32_t            * _nb_inst_read                                  ; //[nb_read_unit]
  public : uint32_t            * _size_read_queue                               ; //[nb_read_unit]
  public : uint32_t            * _size_reservation_station                      ; //[nb_read_unit]
  public : uint32_t            * _nb_inst_retire                                ; //[nb_read_unit]
  public : uint32_t            * _read_unit_nb_register_write                   ; //[nb_read_unit]
  public : uint32_t            * _read_unit_nb_bypass_write                     ; //[nb_read_unit]
  public : uint32_t            * _read_unit_nb_bypass_memory                    ; //[nb_read_unit]
  public : bool              *** _link_read_unit_with_load_store_unit           ; //[nb_read_unit][nb_load_store_unit][nb_inst_memory]
  public : bool               ** _link_read_unit_with_write_unit                ; //[nb_read_unit][nb_write_unit]
  public : bool               ** _link_read_unit_with_thread                    ; //[nb_read_unit][nb_thread]
    //  * write_unit                                                                  
  public : uint32_t            * _nb_inst_write                                 ; //[nb_write_unit]
  public : uint32_t            * _size_write_queue                              ; //[nb_write_unit]
  public : uint32_t            * _size_execute_queue                            ; //[nb_write_unit]
  public : uint32_t            * _nb_bypass_write                               ; //[nb_write_unit]
  public : multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t * _write_queue_scheme; //[nb_write_unit]

    //  * register_unit                                                               
  public : uint32_t              _nb_gpr_read                                   ;
  public : uint32_t              _nb_gpr_write                                  ;
  public : uint32_t              _nb_gpr_bank                                   ;
  public : uint32_t              _nb_gpr_port_read_by_bank                      ;
  public : uint32_t              _nb_gpr_port_write_by_bank                     ;
  public : uint32_t              _nb_spr_read                                   ;
  public : uint32_t              _nb_spr_write                                  ;
  public : uint32_t              _nb_spr_bank                                   ;
  public : uint32_t              _nb_spr_port_read_by_bank                      ;
  public : uint32_t              _nb_spr_port_write_by_bank                     ;
  public : uint32_t            * _nb_general_register                           ; //[nb_ooo_engine]
  public : uint32_t            * _nb_special_register                           ; //[nb_ooo_engine]
//public : uint32_t            * _nb_inst_insert_rob                            ; //[nb_ooo_engine]
//public : uint32_t            * _nb_inst_retire_rob                            ; //[nb_ooo_engine]
    //  * network
  public : Tpriority_t           _execution_unit_to_write_unit_priority         ;
  public : bool              *** _execution_unit_to_write_unit_table_routing    ; //[nb_execute_unit][nb_execute_unit_port][nb_write_unit]
  public : bool               ** _execution_unit_to_write_unit_table_thread     ; //[nb_write_unit][nb_thread]

  public : Tpriority_t           _read_unit_to_execution_unit_priority          ;
  public : bool              *** _read_unit_to_execution_unit_table_routing     ; //[nb_read_unit][nb_execute_unit][nb_execute_unit_port]
  public : bool               ** _read_unit_to_execution_unit_table_execute_type; //[nb_execute_unit][nb_type]
  public : bool               ** _read_unit_to_execution_unit_table_thread      ; //[nb_execute_unit][nb_thread]

  public : bool                * _is_load_store_unit                            ; //[nb_execute_unit]
  public : uint32_t            * _translate_num_execute_unit                    ; //[nb_execute_unit]

  public : bool                * _num_thread_valid                              ; //[nb_thread]

  public : uint32_t              _nb_thread                    ;
  public : uint32_t              _nb_execute_unit              ;
  public : uint32_t            * _nb_execute_unit_port         ;

//public : uint32_t              _size_context_id              ;
//public : uint32_t              _size_front_end_id            ;
//public : uint32_t              _size_ooo_engine_id           ;
//public : uint32_t              _size_packet_id               ;
//public : bool                  _have_port_context_id         ;
//public : bool                  _have_port_front_end_id       ;
//public : bool                  _have_port_ooo_engine_id      ;
//public : bool                  _have_port_packet_id          ;
//public : bool                  _have_port_load_queue_ptr     ;
  public : bool                  _have_port_dcache_context_id  ;
    
  public : uint32_t              _max_nb_inst_memory     ;
  public : uint32_t              _max_nb_general_register;
  public : uint32_t              _max_nb_special_register;
  public : uint32_t              _max_size_store_queue   ;
  public : uint32_t              _max_size_load_queue    ;

//public : uint32_t              _size_general_register        ;
//public : uint32_t              _size_special_register        ;

  public : uint32_t              _max_size_dcache_context_id;
  public : uint32_t              _max_size_dcache_packet_id ;

  public : std::set<uint32_t>  * _set_read_unit_source_register_write ; //[nb_read_unit]
  public : std::set<uint32_t>  * _set_read_unit_source_bypass_write   ; //[nb_read_unit]
  public : std::set<uint32_t>  * _set_read_unit_source_bypass_memory  ; //[nb_read_unit]

  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::execute_loop_glue::                                 Parameters  * _param_glue;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::                        Parameters ** _param_read_unit;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::functionnal_unit::Parameters ** _param_functionnal_unit;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit:: Parameters ** _param_load_store_unit;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::                      Parameters ** _param_write_unit;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::              Parameters  * _param_read_unit_to_execution_unit;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::network::execution_unit_to_write_unit::             Parameters  * _param_execution_unit_to_write_unit;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::                                     Parameters  * _param_register_unit;
    
    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t              nb_read_unit                                  ,
                        uint32_t              nb_functionnal_unit                           ,
                        uint32_t              nb_load_store_unit                            ,
                        uint32_t              nb_write_unit                                 ,
                        
                        uint32_t              nb_context                                    ,
                        uint32_t              nb_front_end                                  ,
                        uint32_t              nb_ooo_engine                                 ,
                        uint32_t              nb_packet                                     ,
                        uint32_t              size_general_data                             ,
                        uint32_t              size_special_data                             ,
                        
                        uint32_t            * nb_inst_read                                  ,//[nb_read_unit]
                        uint32_t            * size_read_queue                               ,//[nb_read_unit]
                        uint32_t            * size_reservation_station                      ,//[nb_read_unit]
                        uint32_t            * nb_inst_retire                                ,//[nb_read_unit]
                        
                        uint32_t            * nb_inst_functionnal_unit                      ,//[nb_functionnal_unit]
                        execute_timing_t  *** timing                                        ,//[nb_functionnal_unit][nb_type][nb_operation]
                        morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void),
                        
                        uint32_t            * size_store_queue                              ,//[nb_load_store_unit]
                        uint32_t            * size_load_queue                               ,//[nb_load_store_unit]
                        uint32_t            * size_speculative_access_queue                 ,//[nb_load_store_unit]
                        uint32_t            * nb_store_queue_bank                           ,//[nb_load_store_unit]
                        uint32_t            * nb_load_queue_bank                            ,//[nb_load_store_unit]
                        uint32_t            * nb_port_check                                 ,//[nb_load_store_unit]
                        Tspeculative_load_t * speculative_load                              ,//[nb_load_store_unit]
                        Tpredictor_t        * speculative_commit_predictor_scheme           ,//[nb_load_store_unit]
                        /* uint32_t           ** lsu_pht_size_counter                          ,//[nb_load_store_unit][1] */
                        /* uint32_t           ** lsu_pht_nb_counter                            ,//[nb_load_store_unit][1] */
                        uint32_t            * nb_bypass_memory                              ,//[nb_load_store_unit]
                        uint32_t            * nb_cache_port                                 ,//[nb_load_store_unit]
                        uint32_t            * nb_inst_memory                                ,//[nb_load_store_unit]
                        
                        uint32_t            * nb_inst_write                                 ,//[nb_write_unit]
                        uint32_t            * size_write_queue                              ,//[nb_write_unit]
                        uint32_t            * size_execute_queue                            ,//[nb_write_unit]
                        uint32_t            * nb_bypass_write                               ,//[nb_write_unit]
			multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t * write_queue_scheme,//[nb_write_unit]

                        uint32_t              nb_gpr_bank                                   ,
                        uint32_t              nb_gpr_port_read_by_bank                      ,
                        uint32_t              nb_gpr_port_write_by_bank                     ,
                        uint32_t              nb_spr_bank                                   ,
                        uint32_t              nb_spr_port_read_by_bank                      ,
                        uint32_t              nb_spr_port_write_by_bank                     ,
                        uint32_t            * nb_general_register                           ,//[nb_ooo_engine]
                        uint32_t            * nb_special_register                           ,//[nb_ooo_engine]
//                      uint32_t            * nb_inst_insert_rob                            ,//[nb_ooo_engine]
//                      uint32_t            * nb_inst_retire_rob                            ,//[nb_ooo_engine]
                        
                        Tpriority_t           execution_unit_to_write_unit_priority         ,
                        bool              *** execution_unit_to_write_unit_table_routing    ,//[nb_execute_unit][nb_execute_unit_port][nb_write_unit]
                        bool               ** execution_unit_to_write_unit_table_thread     ,//[nb_write_unit][nb_thread]
                        
                        Tpriority_t           read_unit_to_execution_unit_priority          ,
                        bool              *** read_unit_to_execution_unit_table_routing     ,//[nb_read_unit][nb_execute_unit][nb_execute_unit_port]
                        bool               ** read_unit_to_execution_unit_table_thread      ,//[nb_execute_unit][nb_thread]

                        bool                * is_load_store_unit                            ,//[nb_execute_unit]
                        uint32_t            * translate_num_execute_unit                    ,//[nb_execute_unit]

                        bool                * num_thread_valid                              ,//[nb_thread]

                        bool                  is_toplevel=false
                        );
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters (void) ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
                                              morpheo::behavioural::core::multi_execute_loop::execute_loop::Parameters & x);
  };

}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
