#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_Parameters_h

/*
 * $Id: Parameters.h 146 2011-02-01 20:57:54Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t       _nb_context                    ;
  public : uint32_t       _nb_decod_unit                 ;
  public : uint32_t       _size_address                  ;
  public : uint32_t *     _nb_instruction                ;//[nb_context]
  public : uint32_t *     _nb_inst_decod                 ;//[nb_decod_unit]
  public : uint32_t       _nb_inst_branch_predict        ;
  public : uint32_t       _nb_inst_branch_decod          ;
  public : uint32_t       _nb_inst_branch_update         ;
  public : uint32_t       _nb_inst_branch_complete       ;
  public : uint32_t       _btb_size_queue                ;
  public : uint32_t       _btb_associativity             ;
  public : uint32_t       _btb_size_counter              ;
  public : Tvictim_t      _btb_victim_scheme             ;
  public : Tpredictor_t   _dir_predictor_scheme          ;
  public : bool           _dir_have_bht               [3];
  public : uint32_t       _dir_bht_size_shifter       [3];
  public : uint32_t       _dir_bht_nb_shifter         [3];
  public : bool           _dir_have_pht               [3];
  public : uint32_t       _dir_pht_size_counter       [3];
  public : uint32_t       _dir_pht_nb_counter         [3];
  public : uint32_t       _dir_pht_size_address_share [3];
  public : Tpht_scheme_t  _dir_pht_scheme             [3];
  public : uint32_t *     _ras_size_queue                ;//[nb_context]
  public : uint32_t *     _upt_size_queue                ;//[nb_context]
  public : uint32_t *     _ufpt_size_queue               ;//[nb_context]
  public : uint32_t       _nb_thread                          ;
  public : uint32_t *     _translate_num_context_to_num_thread;//[nb_context]                    



//public : uint32_t     _size_context_id               ;
//public : uint32_t     _max_size_depth                ;
//public : uint32_t *   _size_inst_ifetch_ptr          ;//[nb_context]
  public : uint32_t *   _array_size_depth              ;//[nb_context]
  public : uint32_t     _size_history                  ;
  public : uint32_t *   _size_ras_index                ;//[nb_context]
						       
//public : bool         _have_port_context_id          ;
//public : bool         _have_port_max_depth           ;
//public : bool     *   _have_port_depth               ;//[nb_context]
//public : bool     *   _have_port_inst_ifetch_ptr     ;//[nb_context]
  public : bool         _have_port_history             ;
  public : bool     *   _have_port_ras_index           ;//[nb_context]

  public : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer   ::Parameters * _param_btb;
  public : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction              ::Parameters * _param_dir;
  public : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::return_address_stack   ::Parameters * _param_ras;
  public : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Parameters * _param_upt;
  public : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::prediction_unit_glue   ::Parameters * _param_glue;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t       nb_context                    ,
			uint32_t       nb_decod_unit                 ,
			uint32_t       size_address                  ,
			uint32_t *     nb_instruction                ,//[nb_context]
			uint32_t *     nb_inst_decod                 ,//[nb_decod_unit]
			uint32_t       nb_inst_branch_predict        ,
			uint32_t       nb_inst_branch_decod          ,
			uint32_t       nb_inst_branch_update         ,
			uint32_t       nb_inst_branch_complete       ,
			uint32_t       btb_size_queue                ,
			uint32_t       btb_associativity             ,
			uint32_t       btb_size_counter              ,
			Tvictim_t      btb_victim_scheme             ,
			Tpredictor_t   dir_predictor_scheme          ,
			bool           dir_have_bht               [3],
			uint32_t       dir_bht_size_shifter       [3],
			uint32_t       dir_bht_nb_shifter         [3],
			bool           dir_have_pht               [3],
			uint32_t       dir_pht_size_counter       [3],
			uint32_t       dir_pht_nb_counter         [3],
			uint32_t       dir_pht_size_address_share [3],
			Tpht_scheme_t  dir_pht_scheme             [3],
			uint32_t *     ras_size_queue                ,//[nb_context]
			uint32_t *     upt_size_queue                ,//[nb_context]
			uint32_t *     ufpt_size_queue               ,//[nb_context]
                        uint32_t       nb_thread                           ,
                        uint32_t *     translate_num_context_to_num_thread ,//[nb_context]                    
                        bool           is_toplevel=false
			);
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::Parameters & x);
  };

}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
