/*
 * $Id: Core.cpp 146 2011-02-01 20:57:54Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/include/Core.h"

namespace morpheo                    {
namespace behavioural {
namespace core {


#undef  FUNCTION
#define FUNCTION "Core::Core"
  Core::Core 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters * param,
   morpheo::behavioural::Tusage_t           usage// ,
   // morpheo::behavioural::Function_pointer * function_pointer
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Core,FUNCTION);

    usage_environment(_usage);

// #if DEBUG_Core == true
//     log_printf(INFO,Core,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Core,FUNCTION,_("<%s> Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
                // function_pointer
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Core,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Core,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    if (usage_is_set(_usage,USE_SYSTEMC))
      {

        // if (function_pointer==NULL)
        //   {
	log_printf(INFO,Core,FUNCTION,_("<%s> Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
        //   }
        // else
        //   {
        //     function_pointer->transition_add(static_cast<f_t>(&morpheo::behavioural::core::Core::transition));
        //   }

      }
# endif
#endif
    log_end(Core,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Core::~Core"
  Core::~Core (void)
  {
    log_begin(Core,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Core,FUNCTION,_("<%s> Deallocation"),_name.c_str());
    deallocation ();

    log_end(Core,FUNCTION);
  };

}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
