/*
 * $id$
 *
 * [ description ]
 * 
 */

#include "Behavioural/Core/include/Parameters.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"
#include <algorithm>

namespace morpheo {
namespace behavioural {
namespace core {

#undef  FUNCTION
#define FUNCTION "Core::get_num_thread"
  Tcontext_t Parameters::execute_loop_get_num_thread (uint32_t num_execute_loop,
                                                      uint32_t num_thread)
  {
    log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_get_num_thread"));
    log_printf(TRACE,Core,FUNCTION,_("    * num_execute_loop : %d"),num_execute_loop);
    log_printf(TRACE,Core,FUNCTION,_("    * num_thread       : %d"),num_thread);

    // compute all id !
    //  * initialisation
    uint32_t num_context    = _link_context_with_thread [num_thread].second;
    uint32_t num_front_end  = _link_context_with_thread [num_thread].first;
    uint32_t num_ooo_engine = _link_rename_unit_with_rename_bloc[_link_rename_bloc_with_front_end [num_front_end]].first;

    log_printf(TRACE,Core,FUNCTION,_("    * num_context      : %d"),num_context   );
    log_printf(TRACE,Core,FUNCTION,_("    * num_front_end    : %d"),num_front_end );
    log_printf(TRACE,Core,FUNCTION,_("    * num_ooo_engine   : %d"),num_ooo_engine);
    
    uint32_t context_id   = num_context;
    uint32_t front_end_id ;
    uint32_t ooo_engine_id;

    //  * compute
    for (ooo_engine_id=0; ooo_engine_id<_execute_loop_nb_ooo_engine [num_execute_loop]; ++ooo_engine_id)
      if (_list_ooo_engine_with_execute_loop [num_execute_loop][ooo_engine_id] == num_ooo_engine)
        break;
    
    if (ooo_engine_id == _execute_loop_nb_ooo_engine [num_execute_loop])
      return static_cast<Tcontext_t>(-1);

    log_printf(TRACE,Core,FUNCTION,_("    * ooo_engine_id    : %d"),ooo_engine_id);
    
    for (front_end_id=0; front_end_id<_ooo_engine_nb_front_end[num_ooo_engine]; ++front_end_id)
      if (_translate_ooo_engine_num_front_end [num_ooo_engine][front_end_id] == num_front_end)
        break;
    
    if (front_end_id == _execute_loop_nb_front_end [num_execute_loop])
      return static_cast<Tcontext_t>(-1);

    log_printf(TRACE,Core,FUNCTION,_("    * front_end_id     : %d"),front_end_id );

    Tcontext_t _return = get_num_thread(context_id   , log2(_execute_loop_nb_context    [num_execute_loop]),
                                        front_end_id , log2(_execute_loop_nb_front_end  [num_execute_loop]),
                                        ooo_engine_id, log2(_execute_loop_nb_ooo_engine [num_execute_loop]));

    log_printf(TRACE,Core,FUNCTION,_("    * return           : %d"),_return);

    // compute the thread number
    return _return;
  }

#undef  FUNCTION
#define FUNCTION "Core::sort_and_unique"
  //template <typename T>
  std::vector<uint32_t> sort_and_unique (std::vector<uint32_t> v)
  {
    sort (v.begin(), v.end());
    std::vector<uint32_t>::iterator it=std::unique(v.begin(), v.end());
    v.erase(it,v.end());

    return v;
  }

#undef  FUNCTION
#define FUNCTION "Core::Parameters"
  Parameters::Parameters (
  // Common
  uint32_t                size_general_data                             ,
  uint32_t                size_special_data                             ,
  morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void),
    
  // Thread
  uint32_t                nb_thread                                     ,
  uint32_t              * size_ifetch_queue                             ,//[nb_thread]
  multi_front_end::front_end::ifetch_unit::ifetch_queue::Tifetch_queue_scheme_t
                        * ifetch_queue_scheme                           ,//[nb_thread]
  uint32_t              * nb_inst_fetch                                 ,//[nb_thread]
  bool                 ** implement_group                               ,//[nb_thread][NB_GROUP]
  uint32_t              * ras_size_queue                                ,//[nb_thread]
  uint32_t              * upt_size_queue                                ,//[nb_thread]
  uint32_t              * ufpt_size_queue                               ,//[nb_thread]

  // Decod bloc
  uint32_t                nb_decod_bloc                                 ,
  uint32_t              * size_decod_queue                              ,//[nb_decod_bloc]
  multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t
                        * decod_queue_scheme                            ,//[nb_decod_bloc]
  uint32_t              * nb_inst_decod                                 ,//[nb_decod_bloc]
  uint32_t              * nb_context_select                             ,//[nb_decod_bloc]
  Tpriority_t           * context_select_priority                       ,//[nb_decod_bloc]
  Tload_balancing_t     * context_select_load_balancing                 ,//[nb_decod_bloc]

  // Rename bloc
  uint32_t                nb_rename_bloc                                ,
  uint32_t              * nb_inst_insert                                ,//[nb_rename_bloc]
  uint32_t              * nb_inst_retire                                ,//[nb_rename_bloc]
  Tpriority_t           * rename_select_priority                        ,//[nb_rename_bloc]
  Tload_balancing_t     * rename_select_load_balancing                  ,//[nb_rename_bloc]
  uint32_t              * rename_select_nb_front_end_select             ,//[nb_rename_bloc]
  uint32_t              * nb_general_register                           ,//[nb_rename_bloc]
  uint32_t              * nb_special_register                           ,//[nb_rename_bloc]
  Trat_scheme_t         * rat_scheme                                    ,//[nb_rename_bloc]
  uint32_t              * nb_reg_free                                   ,//[nb_rename_bloc]
  uint32_t              * nb_rename_unit_bank                           ,//[nb_rename_bloc]
//uint32_t              * size_read_counter                             ,//[nb_rename_bloc]

  // Read bloc
  uint32_t                nb_read_bloc                                  ,//
  uint32_t              * nb_inst_read                                  ,//[nb_read_bloc]
  uint32_t              * size_read_queue                               ,//[nb_read_bloc]
  uint32_t              * size_reservation_station                      ,//[nb_read_bloc]
  uint32_t              * nb_inst_retire_reservation_station            ,//[nb_read_bloc]

  // Write bloc
  uint32_t                nb_write_bloc                                 ,//
  uint32_t              * nb_inst_write                                 ,//[nb_write_bloc]
  uint32_t              * size_write_queue                              ,//[nb_write_bloc]
  uint32_t              * size_execute_queue                            ,//[nb_write_bloc]
  uint32_t              * nb_bypass_write                               ,//[nb_write_bloc]
  multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t * write_queue_scheme,//[nb_write_bloc]

  // Load_store_unit
  uint32_t                nb_load_store_unit                            ,
  uint32_t              * size_store_queue                              ,//[nb_load_store_unit]
  uint32_t              * size_load_queue                               ,//[nb_load_store_unit]
  uint32_t              * size_speculative_access_queue                 ,//[nb_load_store_unit]
  uint32_t              * nb_store_queue_bank                           ,//[nb_load_store_unit]
  uint32_t              * nb_load_queue_bank                            ,//[nb_load_store_unit]
  uint32_t              * nb_port_check                                 ,//[nb_load_store_unit]
  multi_execute_loop::execute_loop::Tspeculative_load_t  
                        * speculative_load                              ,//[nb_load_store_unit]
  Tpredictor_t          * speculative_commit_predictor_scheme           ,//[nb_load_store_unit]
  uint32_t             ** lsu_pht_size_counter                          ,//[nb_load_store_unit][1]
  uint32_t             ** lsu_pht_nb_counter                            ,//[nb_load_store_unit][1]
  Tpht_scheme_t        ** lsu_pht_scheme                                ,//[nb_load_store_unit][1]
  uint32_t              * nb_bypass_memory                              ,//[nb_load_store_unit]
  uint32_t              * nb_cache_port                                 ,//[nb_load_store_unit]
  uint32_t              * nb_inst_memory                                ,//[nb_load_store_unit]

  // Functionnal_unit
  uint32_t                nb_functionnal_unit                           ,
  uint32_t              * nb_inst_functionnal_unit                      ,//[nb_functionnal_unit]
  multi_execute_loop::execute_loop::execute_timing_t
                      *** timing                                        ,//[nb_functionnal_unit][_nb_type][_nb_operation]

  // Icache_Access
  uint32_t                nb_icache_port                                ,
  Tpriority_t             icache_port_priority                        ,
  Tload_balancing_t       icache_port_load_balancing                  ,

  // Dcache_Access
  uint32_t                nb_dcache_port                                ,
  Tpriority_t             dcache_port_priority                        ,
  Tload_balancing_t       dcache_port_load_balancing                  ,

  // Front_end
  uint32_t                nb_front_end                                  ,
  uint32_t              * nb_context                                    ,//[nb_front_end]
  uint32_t              * nb_decod_unit                                 ,//[nb_front_end]
  uint32_t              * nb_inst_branch_predict                        ,//[nb_front_end]
  uint32_t              * nb_inst_branch_decod                          ,//[nb_front_end]
  uint32_t              * nb_inst_branch_update                         ,//[nb_front_end]
  uint32_t              * btb_size_queue                                ,//[nb_front_end]
  uint32_t              * btb_associativity                             ,//[nb_front_end]
  uint32_t              * btb_size_counter                              ,//[nb_front_end]
  Tvictim_t             * btb_victim_scheme                             ,//[nb_front_end]
  Tpredictor_t          * dir_predictor_scheme                          ,//[nb_front_end]
  bool                 ** dir_have_bht                                  ,//[nb_front_end][3]
  uint32_t             ** dir_bht_size_shifter                          ,//[nb_front_end][3]
  uint32_t             ** dir_bht_nb_shifter                            ,//[nb_front_end][3]
  bool                 ** dir_have_pht                                  ,//[nb_front_end][3]
  uint32_t             ** dir_pht_size_counter                          ,//[nb_front_end][3]
  uint32_t             ** dir_pht_nb_counter                            ,//[nb_front_end][3]
  uint32_t             ** dir_pht_size_address_share                    ,//[nb_front_end][3]
  Tpht_scheme_t        ** dir_pht_scheme                                ,//[nb_front_end][3]

  // OOO_Engine
  uint32_t                nb_ooo_engine                                 ,
  uint32_t              * nb_rename_unit                                ,//[nb_ooo_engine]
//uint32_t              * nb_inst_issue_slot                            ,//[nb_ooo_engine]
  uint32_t              * nb_inst_reexecute                             ,//[nb_ooo_engine]
  uint32_t              * nb_inst_commit                                ,//[nb_ooo_engine]
  uint32_t              * nb_inst_branch_complete                       ,//[nb_ooo_engine]
  uint32_t              * nb_rename_unit_select                         ,//[nb_ooo_engine]
  uint32_t              * nb_execute_loop_select                        ,//[nb_ooo_engine]
  uint32_t              * size_re_order_buffer                          ,//[nb_ooo_engine]
  uint32_t              * nb_re_order_buffer_bank                       ,//[nb_ooo_engine]
  multi_ooo_engine::ooo_engine::commit_unit::Tretire_ooo_scheme_t
                        * retire_ooo_scheme                             ,//[nb_ooo_engine]
  Tpriority_t           * commit_priority                               ,//[nb_ooo_engine]
  Tload_balancing_t     * commit_load_balancing                         ,//[nb_ooo_engine]
  uint32_t              * size_issue_queue                              ,//[nb_ooo_engine]
  multi_ooo_engine::ooo_engine::issue_queue::Tissue_queue_scheme_t
                        * issue_queue_scheme                            ,//[nb_ooo_engine]
  uint32_t              * nb_issue_queue_bank                           ,//[nb_ooo_engine]
  Tpriority_t           * issue_priority                                ,//[nb_ooo_engine]
  Tload_balancing_t     * issue_load_balancing                          ,//[nb_ooo_engine]
  uint32_t              * size_reexecute_queue                          ,//[nb_ooo_engine]

  //Execute_loop
  uint32_t                nb_execute_loop                               ,
  uint32_t              * nb_read_unit                                  ,//[nb_execute_loop]
  uint32_t              * nb_execute_unit                               ,//[nb_execute_loop]
  uint32_t              * nb_write_unit                                 ,//[nb_execute_loop]
  uint32_t              * nb_gpr_bank                                   ,//[nb_execute_loop]
  uint32_t              * nb_gpr_port_read_by_bank                      ,//[nb_execute_loop]
  uint32_t              * nb_gpr_port_write_by_bank                     ,//[nb_execute_loop]
  uint32_t              * nb_spr_bank                                   ,//[nb_execute_loop]
  uint32_t              * nb_spr_port_read_by_bank                      ,//[nb_execute_loop]
  uint32_t              * nb_spr_port_write_by_bank                     ,//[nb_execute_loop]
  Tpriority_t           * execution_unit_to_write_unit_priority         ,//[nb_execute_loop]
  Tpriority_t           * read_unit_to_execution_unit_priority          ,//[nb_execute_loop]

  // Link
  pair_dual             * link_context_with_thread                      ,//[nb_thread]
  pair_dual             * link_decod_unit_with_decod_bloc               ,//[nb_decod_bloc]
  pair_dual             * link_rename_unit_with_rename_bloc             ,//[nb_rename_bloc]
  pair_dual             * link_read_unit_with_read_bloc                 ,//[nb_read_bloc]
  pair_dual             * link_write_unit_with_write_bloc               ,//[nb_write_bloc]
  pair_dual             * link_execute_unit_with_functionnal_unit       ,//[nb_functionnal_unit]
  pair_dual             * link_execute_unit_with_load_store_unit        ,//[nb_load_store_unit]
  uint32_t              * link_decod_bloc_with_thread                   ,//[nb_thread]
  uint32_t              * link_rename_bloc_with_front_end               ,//[nb_front_end]
//bool                *** table_dispatch                                ,//[nb_ooo_engine][nb_inst_issue_slot][nb_read_bloc]
  uint32_t              * link_read_bloc_with_load_store_unit           ,//[nb_load_store_unit]
  bool                 ** link_read_bloc_and_functionnal_unit           ,//[nb_read_bloc][nb_functionnal_unit]
  uint32_t              * link_write_bloc_with_load_store_unit          ,//[nb_load_store_unit]
  bool                 ** link_write_bloc_and_functionnal_unit          ,//[nb_write_bloc][nb_functionnal_unit]
  uint32_t              * link_load_store_unit_with_thread              ,//[nb_thread]
  bool                 ** link_thread_and_functionnal_unit              ,//[nb_thread][nb_functionnal_unit]
  uint32_t              * link_icache_port_with_thread                  ,//[nb_thread]
  uint32_t             ** link_dcache_port_with_load_store_unit         ,//[nb_load_store_unit][nb_cache_port]

  Tpriority_t             dispatch_priority                             ,
  Tload_balancing_t       dispatch_load_balancing                       ,
  bool                    is_toplevel
                        )
  {
    log_begin(Core,FUNCTION);
    
    _size_general_data                       = size_general_data                       ;
    _size_special_data                       = size_special_data                       ;
    _get_custom_information                  = get_custom_information                  ;

    _nb_thread                               = nb_thread                               ;
    _size_ifetch_queue                       = size_ifetch_queue                       ;
    _ifetch_queue_scheme                     = ifetch_queue_scheme                     ;
    _nb_inst_fetch                           = nb_inst_fetch                           ;
    _implement_group                         = implement_group                         ;
    _ras_size_queue                          = ras_size_queue                          ;
    _upt_size_queue                          = upt_size_queue                          ;
    _ufpt_size_queue                         = ufpt_size_queue                         ;

    _nb_decod_bloc                           = nb_decod_bloc                           ;
    _size_decod_queue                        = size_decod_queue                        ;
    _decod_queue_scheme                      = decod_queue_scheme                      ;
    _nb_inst_decod                           = nb_inst_decod                           ;
    _nb_context_select                       = nb_context_select                       ;
    _context_select_priority                 = context_select_priority                 ;
    _context_select_load_balancing           = context_select_load_balancing           ;

    _nb_rename_bloc                          = nb_rename_bloc                          ;
    _nb_inst_insert                          = nb_inst_insert                          ;
    _nb_inst_retire                          = nb_inst_retire                          ;
    _rename_select_priority                  = rename_select_priority                  ;
    _rename_select_load_balancing            = rename_select_load_balancing            ;
    _rename_select_nb_front_end_select       = rename_select_nb_front_end_select       ;
    _nb_general_register                     = nb_general_register                     ;
    _nb_special_register                     = nb_special_register                     ;
    _rat_scheme                              = rat_scheme                              ;
    _nb_reg_free                             = nb_reg_free                             ;
    _nb_rename_unit_bank                     = nb_rename_unit_bank                     ;
//  _size_read_counter                       = size_read_counter                       ;

    _nb_read_bloc                            = nb_read_bloc                            ;
    _nb_inst_read                            = nb_inst_read                            ;
    _size_read_queue                         = size_read_queue                         ;
    _size_reservation_station                = size_reservation_station                ;
    _nb_inst_retire_reservation_station      = nb_inst_retire_reservation_station      ;

    _nb_write_bloc                           = nb_write_bloc                           ;
    _nb_inst_write                           = nb_inst_write                           ;
    _size_write_queue                        = size_write_queue                        ;
    _size_execute_queue                      = size_execute_queue                      ;
    _nb_bypass_write                         = nb_bypass_write                         ;
    _write_queue_scheme                      = write_queue_scheme                      ;

    _nb_load_store_unit                      = nb_load_store_unit                      ;
    _size_store_queue                        = size_store_queue                        ;
    _size_load_queue                         = size_load_queue                         ;
    _size_speculative_access_queue           = size_speculative_access_queue           ;
    _nb_store_queue_bank                     = nb_store_queue_bank                     ;
    _nb_load_queue_bank                      = nb_load_queue_bank                      ;
    _nb_port_check                           = nb_port_check                           ;
    _speculative_load                        = speculative_load                        ;
    _speculative_commit_predictor_scheme     = speculative_commit_predictor_scheme     ;
    _lsu_pht_size_counter                    = lsu_pht_size_counter                    ;
    _lsu_pht_nb_counter                      = lsu_pht_nb_counter                      ;
    _lsu_pht_scheme                          = lsu_pht_scheme                          ;
    _nb_bypass_memory                        = nb_bypass_memory                        ;
    _nb_cache_port                           = nb_cache_port                           ;
    _nb_inst_memory                          = nb_inst_memory                          ;

    _nb_functionnal_unit                     = nb_functionnal_unit                     ;
    _nb_inst_functionnal_unit                = nb_inst_functionnal_unit                ;
    _timing                                  = timing                                  ;

    _nb_icache_port                          = nb_icache_port                          ;
    _icache_port_priority                    = icache_port_priority                    ;
    _icache_port_load_balancing              = icache_port_load_balancing              ;

    _nb_dcache_port                          = nb_dcache_port                          ;
    _dcache_port_priority                    = dcache_port_priority                    ;
    _dcache_port_load_balancing              = dcache_port_load_balancing              ;

    _nb_front_end                            = nb_front_end                            ;
    _nb_context                              = nb_context                              ;
    _nb_decod_unit                           = nb_decod_unit                           ;
    _nb_inst_branch_predict                  = nb_inst_branch_predict                  ;
    _nb_inst_branch_decod                    = nb_inst_branch_decod                    ;
    _nb_inst_branch_update                   = nb_inst_branch_update                   ;
    _btb_size_queue                          = btb_size_queue                          ;
    _btb_associativity                       = btb_associativity                       ;
    _btb_size_counter                        = btb_size_counter                        ;
    _btb_victim_scheme                       = btb_victim_scheme                       ;
    _dir_predictor_scheme                    = dir_predictor_scheme                    ;
    _dir_have_bht                            = dir_have_bht                            ;
    _dir_bht_size_shifter                    = dir_bht_size_shifter                    ;
    _dir_bht_nb_shifter                      = dir_bht_nb_shifter                      ;
    _dir_have_pht                            = dir_have_pht                            ;
    _dir_pht_size_counter                    = dir_pht_size_counter                    ;
    _dir_pht_nb_counter                      = dir_pht_nb_counter                      ;
    _dir_pht_size_address_share              = dir_pht_size_address_share              ;
    _dir_pht_scheme                          = dir_pht_scheme                          ;

    _nb_ooo_engine                           = nb_ooo_engine                           ;
    _nb_rename_unit                          = nb_rename_unit                          ;
//  _nb_inst_issue_slot                      = nb_inst_issue_slot                      ;
    _nb_inst_reexecute                       = nb_inst_reexecute                       ;
    _nb_inst_commit                          = nb_inst_commit                          ;
    _nb_inst_branch_complete                 = nb_inst_branch_complete                 ;
    _nb_rename_unit_select                   = nb_rename_unit_select                   ;
    _nb_execute_loop_select                  = nb_execute_loop_select                  ;
    _size_re_order_buffer                    = size_re_order_buffer                    ;
    _nb_re_order_buffer_bank                 = nb_re_order_buffer_bank                 ;
    _retire_ooo_scheme                       = retire_ooo_scheme                       ;
    _commit_priority                         = commit_priority                         ;
    _commit_load_balancing                   = commit_load_balancing                   ;
    _size_issue_queue                        = size_issue_queue                        ;
    _issue_queue_scheme                      = issue_queue_scheme                      ;
    _nb_issue_queue_bank                     = nb_issue_queue_bank                     ;
    _issue_priority                          = issue_priority                          ;
    _issue_load_balancing                    = issue_load_balancing                    ;
    _size_reexecute_queue                    = size_reexecute_queue                    ;

    _nb_execute_loop                         = nb_execute_loop                         ;
    _nb_read_unit                            = nb_read_unit                            ;
    _nb_execute_unit                         = nb_execute_unit                         ;
    _nb_write_unit                           = nb_write_unit                           ;
    _nb_gpr_bank                             = nb_gpr_bank                             ;
    _nb_gpr_port_read_by_bank                = nb_gpr_port_read_by_bank                ;
    _nb_gpr_port_write_by_bank               = nb_gpr_port_write_by_bank               ;
    _nb_spr_bank                             = nb_spr_bank                             ;
    _nb_spr_port_read_by_bank                = nb_spr_port_read_by_bank                ;
    _nb_spr_port_write_by_bank               = nb_spr_port_write_by_bank               ;
    _execution_unit_to_write_unit_priority   = execution_unit_to_write_unit_priority   ;
    _read_unit_to_execution_unit_priority    = read_unit_to_execution_unit_priority    ;

    _link_context_with_thread                = link_context_with_thread                ;
    _link_decod_unit_with_decod_bloc         = link_decod_unit_with_decod_bloc         ;
    _link_rename_unit_with_rename_bloc       = link_rename_unit_with_rename_bloc       ;
    _link_read_unit_with_read_bloc           = link_read_unit_with_read_bloc           ;
    _link_write_unit_with_write_bloc         = link_write_unit_with_write_bloc         ;
    _link_execute_unit_with_functionnal_unit = link_execute_unit_with_functionnal_unit ;
    _link_execute_unit_with_load_store_unit  = link_execute_unit_with_load_store_unit  ;
    _link_decod_bloc_with_thread             = link_decod_bloc_with_thread             ;
    _link_rename_bloc_with_front_end         = link_rename_bloc_with_front_end         ;
//  _table_dispatch                          = table_dispatch                          ;
    _link_read_bloc_with_load_store_unit     = link_read_bloc_with_load_store_unit     ;
    _link_read_bloc_and_functionnal_unit     = link_read_bloc_and_functionnal_unit     ;
    _link_write_bloc_with_load_store_unit    = link_write_bloc_with_load_store_unit    ;
    _link_write_bloc_and_functionnal_unit    = link_write_bloc_and_functionnal_unit    ;
    _link_load_store_unit_with_thread        = link_load_store_unit_with_thread        ;
    _link_thread_and_functionnal_unit        = link_thread_and_functionnal_unit        ;
    _link_icache_port_with_thread            = link_icache_port_with_thread            ;
    _link_dcache_port_with_load_store_unit   = link_dcache_port_with_load_store_unit   ;

    _dispatch_priority                       = dispatch_priority                       ;
    _dispatch_load_balancing                 = dispatch_load_balancing                 ;

    test();

    log_printf(TRACE,Core,FUNCTION,_("Core parameters :"));

    log_printf(TRACE,Core,FUNCTION,_("  * nb_thread : %d"),_nb_thread);

    // inverse link
    ALLOC2(_link_thread_with_context                      ,uint32_t         ,_nb_front_end,_nb_context[it1]);
    ALLOC2(_link_decod_bloc_with_decod_unit               ,uint32_t         ,_nb_front_end,_nb_decod_unit[it1]);
    ALLOC2(_link_rename_bloc_with_rename_unit             ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1]);
    ALLOC2(_link_read_bloc_with_read_unit                 ,uint32_t         ,_nb_execute_loop,_nb_read_unit[it1]);
    ALLOC2(_link_write_bloc_with_write_unit               ,uint32_t         ,_nb_execute_loop,_nb_write_unit[it1]);
    ALLOC2(_link_functionnal_unit_with_execute_unit       ,uint32_t         ,_nb_execute_loop,_nb_execute_unit[it1]);
    ALLOC2(_link_load_store_unit_with_execute_unit        ,uint32_t         ,_nb_execute_loop,_nb_execute_unit[it1]);
    ALLOC1(_list_functionnal_unit_with_execute_unit       ,std::vector<uint32_t>,_nb_execute_loop);
    ALLOC1(_list_load_store_unit_with_execute_unit        ,std::vector<uint32_t>,_nb_execute_loop);

    for (uint32_t i=0; i<_nb_thread; ++i)
      {
        pair_dual x = _link_context_with_thread[i];
        _link_thread_with_context [x.first][x.second] = i;
      }

//     log_printf(TRACE,Core,FUNCTION,_("  * _link_decod_unit_with_decod_bloc"));
    for (uint32_t i=0; i<_nb_decod_bloc; ++i)
      {
        pair_dual x = _link_decod_unit_with_decod_bloc[i];
        _link_decod_bloc_with_decod_unit [x.first][x.second] = i;
//         log_printf(TRACE,Core,FUNCTION,_("    [%d][%d] -> %d"),x.first,x.second,i);
      }

    for (uint32_t i=0; i<_nb_rename_bloc; ++i)
      {
        pair_dual x = _link_rename_unit_with_rename_bloc[i];
        _link_rename_bloc_with_rename_unit [x.first][x.second] = i;
      }
    for (uint32_t i=0; i<_nb_read_bloc; ++i)
      {
        pair_dual x = _link_read_unit_with_read_bloc[i];
        _link_read_bloc_with_read_unit [x.first][x.second] = i;
      }
    for (uint32_t i=0; i<_nb_write_bloc; ++i)
      {
        pair_dual x = _link_write_unit_with_write_bloc[i];
        _link_write_bloc_with_write_unit [x.first][x.second] = i;
      }

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_nb_execute_unit[i]; ++j)
        {
          // init with an invalid value
          _link_functionnal_unit_with_execute_unit [i][j] = _nb_functionnal_unit;
          _link_load_store_unit_with_execute_unit  [i][j] = _nb_load_store_unit;
        }

    for (uint32_t i=0; i<_nb_functionnal_unit; ++i)
      {
        pair_dual x = _link_execute_unit_with_functionnal_unit[i];
        _link_functionnal_unit_with_execute_unit [x.first][x.second] = i;
      }
    for (uint32_t i=0; i<_nb_load_store_unit; ++i)
      {
        pair_dual x = _link_execute_unit_with_load_store_unit[i];
        _link_load_store_unit_with_execute_unit [x.first][x.second] = i;
      }

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_nb_execute_unit[i]; ++j)
        {
          log_printf(TRACE,Core,FUNCTION,_("  * execute_unit [%d][%d] : functionnal_unit [%d] - load_store_unit [%d]"),i,j,_link_functionnal_unit_with_execute_unit [i][j],_link_load_store_unit_with_execute_unit [i][j]);
          

          if (_link_functionnal_unit_with_execute_unit [i][j] != _nb_functionnal_unit)
            _list_functionnal_unit_with_execute_unit [i].push_back(_link_functionnal_unit_with_execute_unit [i][j]);
          if (_link_load_store_unit_with_execute_unit [i][j] != _nb_load_store_unit)
            _list_load_store_unit_with_execute_unit [i].push_back(_link_load_store_unit_with_execute_unit [i][j]);
        }      

    // translate for front_end
    ALLOC2(_front_end_size_ifetch_queue                   ,uint32_t         ,_nb_front_end,_nb_context[it1]);
    ALLOC2(_front_end_ifetch_queue_scheme                  ,multi_front_end::front_end::ifetch_unit::ifetch_queue::Tifetch_queue_scheme_t
	                                                                    ,_nb_front_end,_nb_context[it1]);
    ALLOC2(_front_end_nb_inst_fetch                       ,uint32_t         ,_nb_front_end,_nb_context[it1]);
    ALLOC2(_front_end_link_decod_unit_with_context        ,uint32_t         ,_nb_front_end,_nb_context[it1]);
    ALLOC2(_front_end_ras_size_queue                      ,uint32_t         ,_nb_front_end,_nb_context[it1]);
    ALLOC2(_front_end_upt_size_queue                      ,uint32_t         ,_nb_front_end,_nb_context[it1]);
    ALLOC2(_front_end_ufpt_size_queue                     ,uint32_t         ,_nb_front_end,_nb_context[it1]);

    for (uint32_t i=0; i<_nb_front_end; ++i)
      for (uint32_t j=0; j<_nb_context[i]; ++j)
        {
          uint32_t num_thread     = _link_thread_with_context[i][j];

          _front_end_size_ifetch_queue            [i][j] = _size_ifetch_queue   [num_thread];
          _front_end_ifetch_queue_scheme          [i][j] = _ifetch_queue_scheme [num_thread];
          _front_end_nb_inst_fetch                [i][j] = _nb_inst_fetch       [num_thread];
          _front_end_ras_size_queue               [i][j] = _ras_size_queue      [num_thread];
          _front_end_upt_size_queue               [i][j] = _upt_size_queue      [num_thread];
          _front_end_ufpt_size_queue              [i][j] = _ufpt_size_queue     [num_thread];

          uint32_t num_decod_bloc = _link_decod_bloc_with_thread [num_thread];
          uint32_t num_decod_unit = _link_decod_unit_with_decod_bloc [num_decod_bloc].second;

          _front_end_link_decod_unit_with_context [i][j] = num_decod_unit;
        }

    ALLOC3(_front_end_instruction_implemeted              ,bool             ,_nb_front_end,_nb_context[it1],NB_INSTRUCTION);

    // Reset instruction implemented
    for (uint32_t i=0; i<_nb_front_end; ++i)
      for (uint32_t j=0; j<_nb_context[i]; ++j)
        for (uint32_t k=0; k<NB_INSTRUCTION; ++k)
          _front_end_instruction_implemeted[i][j][k] = false;

    for (uint32_t i=0; i<_nb_thread; ++i)
      {
        uint32_t num_front_end = _link_context_with_thread [i].first;
        uint32_t num_context   = _link_context_with_thread [i].second;

        for (uint32_t j=0; j<_nb_functionnal_unit; ++j)
          {
            // Test if link
            if (not _link_thread_and_functionnal_unit[i][j])
              continue;

            // For each instruction :
            //  * test if an functional_unit can execute this instruction
            //  * test if the size data is correct
 
            // ORBIS
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_ADD      ] |= (instruction_size_data(INSTRUCTION_L_ADD      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_ADD      )._type][instruction_information(INSTRUCTION_L_ADD      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_ADDC     ] |= (instruction_size_data(INSTRUCTION_L_ADDC     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_ADDC     )._type][instruction_information(INSTRUCTION_L_ADDC     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_ADDI     ] |= (instruction_size_data(INSTRUCTION_L_ADDI     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_ADDI     )._type][instruction_information(INSTRUCTION_L_ADDI     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_ADDIC    ] |= (instruction_size_data(INSTRUCTION_L_ADDIC    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_ADDIC    )._type][instruction_information(INSTRUCTION_L_ADDIC    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_AND      ] |= (instruction_size_data(INSTRUCTION_L_AND      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_AND      )._type][instruction_information(INSTRUCTION_L_AND      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_ANDI     ] |= (instruction_size_data(INSTRUCTION_L_ANDI     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_ANDI     )._type][instruction_information(INSTRUCTION_L_ANDI     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_BF       ] |= (instruction_size_data(INSTRUCTION_L_BF       ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_BF       )._type][instruction_information(INSTRUCTION_L_BF       )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_BNF      ] |= (instruction_size_data(INSTRUCTION_L_BNF      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_BNF      )._type][instruction_information(INSTRUCTION_L_BNF      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CMOV     ] |= (instruction_size_data(INSTRUCTION_L_CMOV     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_CMOV     )._type][instruction_information(INSTRUCTION_L_CMOV     )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CSYNC    ] |= (instruction_size_data(INSTRUCTION_L_CSYNC    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_CSYNC    )._type][instruction_information(INSTRUCTION_L_CSYNC    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST1    ] |= (instruction_size_data(INSTRUCTION_L_CUST1    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_CUST1    )._type][instruction_information(INSTRUCTION_L_CUST1    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST2    ] |= (instruction_size_data(INSTRUCTION_L_CUST2    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_CUST2    )._type][instruction_information(INSTRUCTION_L_CUST2    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST3    ] |= (instruction_size_data(INSTRUCTION_L_CUST3    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_CUST3    )._type][instruction_information(INSTRUCTION_L_CUST3    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST4    ] |= (instruction_size_data(INSTRUCTION_L_CUST4    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_CUST4    )._type][instruction_information(INSTRUCTION_L_CUST4    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST5    ] |= (instruction_size_data(INSTRUCTION_L_CUST5    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_CUST5    )._type][instruction_information(INSTRUCTION_L_CUST5    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST6    ] |= (instruction_size_data(INSTRUCTION_L_CUST6    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_CUST6    )._type][instruction_information(INSTRUCTION_L_CUST6    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST7    ] |= (instruction_size_data(INSTRUCTION_L_CUST7    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_CUST7    )._type][instruction_information(INSTRUCTION_L_CUST7    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST8    ] |= (instruction_size_data(INSTRUCTION_L_CUST8    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_CUST8    )._type][instruction_information(INSTRUCTION_L_CUST8    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_DIV      ] |= (instruction_size_data(INSTRUCTION_L_DIV      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_DIV      )._type][instruction_information(INSTRUCTION_L_DIV      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_DIVU     ] |= (instruction_size_data(INSTRUCTION_L_DIVU     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_DIVU     )._type][instruction_information(INSTRUCTION_L_DIVU     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_EXTBS    ] |= (instruction_size_data(INSTRUCTION_L_EXTBS    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_EXTBS    )._type][instruction_information(INSTRUCTION_L_EXTBS    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_EXTBZ    ] |= (instruction_size_data(INSTRUCTION_L_EXTBZ    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_EXTBZ    )._type][instruction_information(INSTRUCTION_L_EXTBZ    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_EXTHS    ] |= (instruction_size_data(INSTRUCTION_L_EXTHS    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_EXTHS    )._type][instruction_information(INSTRUCTION_L_EXTHS    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_EXTHZ    ] |= (instruction_size_data(INSTRUCTION_L_EXTHZ    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_EXTHZ    )._type][instruction_information(INSTRUCTION_L_EXTHZ    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_EXTWS    ] |= (instruction_size_data(INSTRUCTION_L_EXTWS    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_EXTWS    )._type][instruction_information(INSTRUCTION_L_EXTWS    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_EXTWZ    ] |= (instruction_size_data(INSTRUCTION_L_EXTWZ    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_EXTWZ    )._type][instruction_information(INSTRUCTION_L_EXTWZ    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_FF1      ] |= (instruction_size_data(INSTRUCTION_L_FF1      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_FF1      )._type][instruction_information(INSTRUCTION_L_FF1      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_FL1      ] |= (instruction_size_data(INSTRUCTION_L_FL1      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_FL1      )._type][instruction_information(INSTRUCTION_L_FL1      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_J        ] |= (instruction_size_data(INSTRUCTION_L_J        ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_J        )._type][instruction_information(INSTRUCTION_L_J        )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_JAL      ] |= (instruction_size_data(INSTRUCTION_L_JAL      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_JAL      )._type][instruction_information(INSTRUCTION_L_JAL      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_JALR     ] |= (instruction_size_data(INSTRUCTION_L_JALR     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_JALR     )._type][instruction_information(INSTRUCTION_L_JALR     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_JR       ] |= (instruction_size_data(INSTRUCTION_L_JR       ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_JR       )._type][instruction_information(INSTRUCTION_L_JR       )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LBS      ] |= (instruction_size_data(INSTRUCTION_L_LBS      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_LBS      )._type][instruction_information(INSTRUCTION_L_LBS      )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LBZ      ] |= (instruction_size_data(INSTRUCTION_L_LBZ      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_LBZ      )._type][instruction_information(INSTRUCTION_L_LBZ      )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LD       ] |= (instruction_size_data(INSTRUCTION_L_LD       ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_LD       )._type][instruction_information(INSTRUCTION_L_LD       )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LHS      ] |= (instruction_size_data(INSTRUCTION_L_LHS      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_LHS      )._type][instruction_information(INSTRUCTION_L_LHS      )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LHZ      ] |= (instruction_size_data(INSTRUCTION_L_LHZ      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_LHZ      )._type][instruction_information(INSTRUCTION_L_LHZ      )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LWS      ] |= (instruction_size_data(INSTRUCTION_L_LWS      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_LWS      )._type][instruction_information(INSTRUCTION_L_LWS      )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LWZ      ] |= (instruction_size_data(INSTRUCTION_L_LWZ      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_LWZ      )._type][instruction_information(INSTRUCTION_L_LWZ      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MAC      ] |= (instruction_size_data(INSTRUCTION_L_MAC      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MAC      )._type][instruction_information(INSTRUCTION_L_MAC      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MACI     ] |= (instruction_size_data(INSTRUCTION_L_MACI     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MACI     )._type][instruction_information(INSTRUCTION_L_MACI     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MACRC    ] |= (instruction_size_data(INSTRUCTION_L_MACRC    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MACRC    )._type][instruction_information(INSTRUCTION_L_MACRC    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MFSPR    ] |= (instruction_size_data(INSTRUCTION_L_MFSPR    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MFSPR    )._type][instruction_information(INSTRUCTION_L_MFSPR    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MOVHI    ] |= (instruction_size_data(INSTRUCTION_L_MOVHI    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MOVHI    )._type][instruction_information(INSTRUCTION_L_MOVHI    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MSB      ] |= (instruction_size_data(INSTRUCTION_L_MSB      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MSB      )._type][instruction_information(INSTRUCTION_L_MSB      )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MSYNC    ] |= (instruction_size_data(INSTRUCTION_L_MSYNC    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MSYNC    )._type][instruction_information(INSTRUCTION_L_MSYNC    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MTSPR    ] |= (instruction_size_data(INSTRUCTION_L_MTSPR    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MTSPR    )._type][instruction_information(INSTRUCTION_L_MTSPR    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MUL      ] |= (instruction_size_data(INSTRUCTION_L_MUL      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MUL      )._type][instruction_information(INSTRUCTION_L_MUL      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MULI     ] |= (instruction_size_data(INSTRUCTION_L_MULI     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MULI     )._type][instruction_information(INSTRUCTION_L_MULI     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MULU     ] |= (instruction_size_data(INSTRUCTION_L_MULU     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_MULU     )._type][instruction_information(INSTRUCTION_L_MULU     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_NOP      ] |= (instruction_size_data(INSTRUCTION_L_NOP      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_NOP      )._type][instruction_information(INSTRUCTION_L_NOP      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_OR       ] |= (instruction_size_data(INSTRUCTION_L_OR       ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_OR       )._type][instruction_information(INSTRUCTION_L_OR       )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_ORI      ] |= (instruction_size_data(INSTRUCTION_L_ORI      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_ORI      )._type][instruction_information(INSTRUCTION_L_ORI      )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_PSYNC    ] |= (instruction_size_data(INSTRUCTION_L_PSYNC    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_PSYNC    )._type][instruction_information(INSTRUCTION_L_PSYNC    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_RFE      ] |= (instruction_size_data(INSTRUCTION_L_RFE      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_RFE      )._type][instruction_information(INSTRUCTION_L_RFE      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_ROR      ] |= (instruction_size_data(INSTRUCTION_L_ROR      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_ROR      )._type][instruction_information(INSTRUCTION_L_ROR      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_RORI     ] |= (instruction_size_data(INSTRUCTION_L_RORI     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_RORI     )._type][instruction_information(INSTRUCTION_L_RORI     )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SB       ] |= (instruction_size_data(INSTRUCTION_L_SB       ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SB       )._type][instruction_information(INSTRUCTION_L_SB       )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SD       ] |= (instruction_size_data(INSTRUCTION_L_SD       ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SD       )._type][instruction_information(INSTRUCTION_L_SD       )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFEQ     ] |= (instruction_size_data(INSTRUCTION_L_SFEQ     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFEQ     )._type][instruction_information(INSTRUCTION_L_SFEQ     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFEQI    ] |= (instruction_size_data(INSTRUCTION_L_SFEQI    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFEQI    )._type][instruction_information(INSTRUCTION_L_SFEQI    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFGES    ] |= (instruction_size_data(INSTRUCTION_L_SFGES    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFGES    )._type][instruction_information(INSTRUCTION_L_SFGES    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFGESI   ] |= (instruction_size_data(INSTRUCTION_L_SFGESI   ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFGESI   )._type][instruction_information(INSTRUCTION_L_SFGESI   )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFGEU    ] |= (instruction_size_data(INSTRUCTION_L_SFGEU    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFGEU    )._type][instruction_information(INSTRUCTION_L_SFGEU    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFGEUI   ] |= (instruction_size_data(INSTRUCTION_L_SFGEUI   ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFGEUI   )._type][instruction_information(INSTRUCTION_L_SFGEUI   )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFGTS    ] |= (instruction_size_data(INSTRUCTION_L_SFGTS    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFGTS    )._type][instruction_information(INSTRUCTION_L_SFGTS    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFGTSI   ] |= (instruction_size_data(INSTRUCTION_L_SFGTSI   ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFGTSI   )._type][instruction_information(INSTRUCTION_L_SFGTSI   )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFGTU    ] |= (instruction_size_data(INSTRUCTION_L_SFGTU    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFGTU    )._type][instruction_information(INSTRUCTION_L_SFGTU    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFGTUI   ] |= (instruction_size_data(INSTRUCTION_L_SFGTUI   ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFGTUI   )._type][instruction_information(INSTRUCTION_L_SFGTUI   )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFLES    ] |= (instruction_size_data(INSTRUCTION_L_SFLES    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFLES    )._type][instruction_information(INSTRUCTION_L_SFLES    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFLESI   ] |= (instruction_size_data(INSTRUCTION_L_SFLESI   ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFLESI   )._type][instruction_information(INSTRUCTION_L_SFLESI   )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFLEU    ] |= (instruction_size_data(INSTRUCTION_L_SFLEU    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFLEU    )._type][instruction_information(INSTRUCTION_L_SFLEU    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFLEUI   ] |= (instruction_size_data(INSTRUCTION_L_SFLEUI   ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFLEUI   )._type][instruction_information(INSTRUCTION_L_SFLEUI   )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFLTS    ] |= (instruction_size_data(INSTRUCTION_L_SFLTS    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFLTS    )._type][instruction_information(INSTRUCTION_L_SFLTS    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFLTSI   ] |= (instruction_size_data(INSTRUCTION_L_SFLTSI   ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFLTSI   )._type][instruction_information(INSTRUCTION_L_SFLTSI   )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFLTU    ] |= (instruction_size_data(INSTRUCTION_L_SFLTU    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFLTU    )._type][instruction_information(INSTRUCTION_L_SFLTU    )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFLTUI   ] |= (instruction_size_data(INSTRUCTION_L_SFLTUI   ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFLTUI   )._type][instruction_information(INSTRUCTION_L_SFLTUI   )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFNE     ] |= (instruction_size_data(INSTRUCTION_L_SFNE     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFNE     )._type][instruction_information(INSTRUCTION_L_SFNE     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SFNEI    ] |= (instruction_size_data(INSTRUCTION_L_SFNEI    ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SFNEI    )._type][instruction_information(INSTRUCTION_L_SFNEI    )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SH       ] |= (instruction_size_data(INSTRUCTION_L_SH       ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SH       )._type][instruction_information(INSTRUCTION_L_SH       )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SLL      ] |= (instruction_size_data(INSTRUCTION_L_SLL      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SLL      )._type][instruction_information(INSTRUCTION_L_SLL      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SLLI     ] |= (instruction_size_data(INSTRUCTION_L_SLLI     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SLLI     )._type][instruction_information(INSTRUCTION_L_SLLI     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SRA      ] |= (instruction_size_data(INSTRUCTION_L_SRA      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SRA      )._type][instruction_information(INSTRUCTION_L_SRA      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SRAI     ] |= (instruction_size_data(INSTRUCTION_L_SRAI     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SRAI     )._type][instruction_information(INSTRUCTION_L_SRAI     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SRL      ] |= (instruction_size_data(INSTRUCTION_L_SRL      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SRL      )._type][instruction_information(INSTRUCTION_L_SRL      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SRLI     ] |= (instruction_size_data(INSTRUCTION_L_SRLI     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SRLI     )._type][instruction_information(INSTRUCTION_L_SRLI     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SUB      ] |= (instruction_size_data(INSTRUCTION_L_SUB      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SUB      )._type][instruction_information(INSTRUCTION_L_SUB      )._operation]._latence > 0);
//          _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SW       ] |= (instruction_size_data(INSTRUCTION_L_SW       ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SW       )._type][instruction_information(INSTRUCTION_L_SW       )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SYS      ] |= (instruction_size_data(INSTRUCTION_L_SYS      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_SYS      )._type][instruction_information(INSTRUCTION_L_SYS      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_TRAP     ] |= (instruction_size_data(INSTRUCTION_L_TRAP     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_TRAP     )._type][instruction_information(INSTRUCTION_L_TRAP     )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_XOR      ] |= (instruction_size_data(INSTRUCTION_L_XOR      ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_XOR      )._type][instruction_information(INSTRUCTION_L_XOR      )._operation]._latence > 0);
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_XORI     ] |= (instruction_size_data(INSTRUCTION_L_XORI     ) <= size_general_data) and (_timing[j][instruction_information(INSTRUCTION_L_XORI     )._type][instruction_information(INSTRUCTION_L_XORI     )._operation]._latence > 0);

            // ORFPX
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_ADD_D   ] |= (instruction_size_data(INSTRUCTION_LF_ADD_D   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_ADD_S   ] |= (instruction_size_data(INSTRUCTION_LF_ADD_S   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_CUST1_D ] |= (instruction_size_data(INSTRUCTION_LF_CUST1_D ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_CUST1_S ] |= (instruction_size_data(INSTRUCTION_LF_CUST1_S ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_DIV_D   ] |= (instruction_size_data(INSTRUCTION_LF_DIV_D   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_DIV_S   ] |= (instruction_size_data(INSTRUCTION_LF_DIV_S   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_FTOI_D  ] |= (instruction_size_data(INSTRUCTION_LF_FTOI_D  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_FTOI_S  ] |= (instruction_size_data(INSTRUCTION_LF_FTOI_S  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_ITOF_D  ] |= (instruction_size_data(INSTRUCTION_LF_ITOF_D  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_ITOF_S  ] |= (instruction_size_data(INSTRUCTION_LF_ITOF_S  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_MADD_D  ] |= (instruction_size_data(INSTRUCTION_LF_MADD_D  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_MADD_S  ] |= (instruction_size_data(INSTRUCTION_LF_MADD_S  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_MUL_D   ] |= (instruction_size_data(INSTRUCTION_LF_MUL_D   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_MUL_S   ] |= (instruction_size_data(INSTRUCTION_LF_MUL_S   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_REM_D   ] |= (instruction_size_data(INSTRUCTION_LF_REM_D   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_REM_S   ] |= (instruction_size_data(INSTRUCTION_LF_REM_S   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFEQ_D  ] |= (instruction_size_data(INSTRUCTION_LF_SFEQ_D  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFEQ_S  ] |= (instruction_size_data(INSTRUCTION_LF_SFEQ_S  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFGE_D  ] |= (instruction_size_data(INSTRUCTION_LF_SFGE_D  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFGE_S  ] |= (instruction_size_data(INSTRUCTION_LF_SFGE_S  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFGT_D  ] |= (instruction_size_data(INSTRUCTION_LF_SFGT_D  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFGT_S  ] |= (instruction_size_data(INSTRUCTION_LF_SFGT_S  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFLE_D  ] |= (instruction_size_data(INSTRUCTION_LF_SFLE_D  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFLE_S  ] |= (instruction_size_data(INSTRUCTION_LF_SFLE_S  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFLT_D  ] |= (instruction_size_data(INSTRUCTION_LF_SFLT_D  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFLT_S  ] |= (instruction_size_data(INSTRUCTION_LF_SFLT_S  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFNE_D  ] |= (instruction_size_data(INSTRUCTION_LF_SFNE_D  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SFNE_S  ] |= (instruction_size_data(INSTRUCTION_LF_SFNE_S  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SUB_D   ] |= (instruction_size_data(INSTRUCTION_LF_SUB_D   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LF_SUB_S   ] |= (instruction_size_data(INSTRUCTION_LF_SUB_S   ) <= size_general_data) and false;

            // ORVDX
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ADD_B   ] |= (instruction_size_data(INSTRUCTION_LV_ADD_B   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ADD_H   ] |= (instruction_size_data(INSTRUCTION_LV_ADD_H   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ADDS_B  ] |= (instruction_size_data(INSTRUCTION_LV_ADDS_B  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ADDS_H  ] |= (instruction_size_data(INSTRUCTION_LV_ADDS_H  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ADDU_B  ] |= (instruction_size_data(INSTRUCTION_LV_ADDU_B  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ADDU_H  ] |= (instruction_size_data(INSTRUCTION_LV_ADDU_H  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ADDUS_B ] |= (instruction_size_data(INSTRUCTION_LV_ADDUS_B ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ADDUS_H ] |= (instruction_size_data(INSTRUCTION_LV_ADDUS_H ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_EQ_B] |= (instruction_size_data(INSTRUCTION_LV_ALL_EQ_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_EQ_H] |= (instruction_size_data(INSTRUCTION_LV_ALL_EQ_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_GE_B] |= (instruction_size_data(INSTRUCTION_LV_ALL_GE_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_GE_H] |= (instruction_size_data(INSTRUCTION_LV_ALL_GE_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_GT_B] |= (instruction_size_data(INSTRUCTION_LV_ALL_GT_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_GT_H] |= (instruction_size_data(INSTRUCTION_LV_ALL_GT_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_LE_B] |= (instruction_size_data(INSTRUCTION_LV_ALL_LE_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_LE_H] |= (instruction_size_data(INSTRUCTION_LV_ALL_LE_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_LT_B] |= (instruction_size_data(INSTRUCTION_LV_ALL_LT_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_LT_H] |= (instruction_size_data(INSTRUCTION_LV_ALL_LT_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_NE_B] |= (instruction_size_data(INSTRUCTION_LV_ALL_NE_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ALL_NE_H] |= (instruction_size_data(INSTRUCTION_LV_ALL_NE_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_AND     ] |= (instruction_size_data(INSTRUCTION_LV_AND     ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_EQ_B] |= (instruction_size_data(INSTRUCTION_LV_ANY_EQ_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_EQ_H] |= (instruction_size_data(INSTRUCTION_LV_ANY_EQ_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_GE_B] |= (instruction_size_data(INSTRUCTION_LV_ANY_GE_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_GE_H] |= (instruction_size_data(INSTRUCTION_LV_ANY_GE_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_GT_B] |= (instruction_size_data(INSTRUCTION_LV_ANY_GT_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_GT_H] |= (instruction_size_data(INSTRUCTION_LV_ANY_GT_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_LE_B] |= (instruction_size_data(INSTRUCTION_LV_ANY_LE_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_LE_H] |= (instruction_size_data(INSTRUCTION_LV_ANY_LE_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_LT_B] |= (instruction_size_data(INSTRUCTION_LV_ANY_LT_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_LT_H] |= (instruction_size_data(INSTRUCTION_LV_ANY_LT_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_NE_B] |= (instruction_size_data(INSTRUCTION_LV_ANY_NE_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_ANY_NE_H] |= (instruction_size_data(INSTRUCTION_LV_ANY_NE_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_AVG_B   ] |= (instruction_size_data(INSTRUCTION_LV_AVG_B   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_AVG_H   ] |= (instruction_size_data(INSTRUCTION_LV_AVG_H   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_EQ_B] |= (instruction_size_data(INSTRUCTION_LV_CMP_EQ_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_EQ_H] |= (instruction_size_data(INSTRUCTION_LV_CMP_EQ_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_GE_B] |= (instruction_size_data(INSTRUCTION_LV_CMP_GE_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_GE_H] |= (instruction_size_data(INSTRUCTION_LV_CMP_GE_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_GT_B] |= (instruction_size_data(INSTRUCTION_LV_CMP_GT_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_GT_H] |= (instruction_size_data(INSTRUCTION_LV_CMP_GT_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_LE_B] |= (instruction_size_data(INSTRUCTION_LV_CMP_LE_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_LE_H] |= (instruction_size_data(INSTRUCTION_LV_CMP_LE_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_LT_B] |= (instruction_size_data(INSTRUCTION_LV_CMP_LT_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_LT_H] |= (instruction_size_data(INSTRUCTION_LV_CMP_LT_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_NE_B] |= (instruction_size_data(INSTRUCTION_LV_CMP_NE_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CMP_NE_H] |= (instruction_size_data(INSTRUCTION_LV_CMP_NE_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CUST1   ] |= (instruction_size_data(INSTRUCTION_LV_CUST1   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CUST2   ] |= (instruction_size_data(INSTRUCTION_LV_CUST2   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CUST3   ] |= (instruction_size_data(INSTRUCTION_LV_CUST3   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_CUST4   ] |= (instruction_size_data(INSTRUCTION_LV_CUST4   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_MADDS_H ] |= (instruction_size_data(INSTRUCTION_LV_MADDS_H ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_MAX_B   ] |= (instruction_size_data(INSTRUCTION_LV_MAX_B   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_MAX_H   ] |= (instruction_size_data(INSTRUCTION_LV_MAX_H   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_MERGE_B ] |= (instruction_size_data(INSTRUCTION_LV_MERGE_B ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_MERGE_H ] |= (instruction_size_data(INSTRUCTION_LV_MERGE_H ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_MIN_B   ] |= (instruction_size_data(INSTRUCTION_LV_MIN_B   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_MIN_H   ] |= (instruction_size_data(INSTRUCTION_LV_MIN_H   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_MSUBS_H ] |= (instruction_size_data(INSTRUCTION_LV_MSUBS_H ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_MULS_H  ] |= (instruction_size_data(INSTRUCTION_LV_MULS_H  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_NAND    ] |= (instruction_size_data(INSTRUCTION_LV_NAND    ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_NOR     ] |= (instruction_size_data(INSTRUCTION_LV_NOR     ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_OR      ] |= (instruction_size_data(INSTRUCTION_LV_OR      ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_PACK_B  ] |= (instruction_size_data(INSTRUCTION_LV_PACK_B  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_PACK_H  ] |= (instruction_size_data(INSTRUCTION_LV_PACK_H  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_PACKS_B ] |= (instruction_size_data(INSTRUCTION_LV_PACKS_B ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_PACKS_H ] |= (instruction_size_data(INSTRUCTION_LV_PACKS_H ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_PACKUS_B] |= (instruction_size_data(INSTRUCTION_LV_PACKUS_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_PACKUS_H] |= (instruction_size_data(INSTRUCTION_LV_PACKUS_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_PERM_N  ] |= (instruction_size_data(INSTRUCTION_LV_PERM_N  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_RL_B    ] |= (instruction_size_data(INSTRUCTION_LV_RL_B    ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_RL_H    ] |= (instruction_size_data(INSTRUCTION_LV_RL_H    ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SLL     ] |= (instruction_size_data(INSTRUCTION_LV_SLL     ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SLL_B   ] |= (instruction_size_data(INSTRUCTION_LV_SLL_B   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SLL_H   ] |= (instruction_size_data(INSTRUCTION_LV_SLL_H   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SRA_B   ] |= (instruction_size_data(INSTRUCTION_LV_SRA_B   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SRA_H   ] |= (instruction_size_data(INSTRUCTION_LV_SRA_H   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SRL     ] |= (instruction_size_data(INSTRUCTION_LV_SRL     ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SRL_B   ] |= (instruction_size_data(INSTRUCTION_LV_SRL_B   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SRL_H   ] |= (instruction_size_data(INSTRUCTION_LV_SRL_H   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SUB_B   ] |= (instruction_size_data(INSTRUCTION_LV_SUB_B   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SUB_H   ] |= (instruction_size_data(INSTRUCTION_LV_SUB_H   ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SUBS_B  ] |= (instruction_size_data(INSTRUCTION_LV_SUBS_B  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SUBS_H  ] |= (instruction_size_data(INSTRUCTION_LV_SUBS_H  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SUBU_B  ] |= (instruction_size_data(INSTRUCTION_LV_SUBU_B  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SUBU_H  ] |= (instruction_size_data(INSTRUCTION_LV_SUBU_H  ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SUBUS_B ] |= (instruction_size_data(INSTRUCTION_LV_SUBUS_B ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_SUBUS_H ] |= (instruction_size_data(INSTRUCTION_LV_SUBUS_H ) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_UNPACK_B] |= (instruction_size_data(INSTRUCTION_LV_UNPACK_B) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_UNPACK_H] |= (instruction_size_data(INSTRUCTION_LV_UNPACK_H) <= size_general_data) and false;
            _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_LV_XOR     ] |= (instruction_size_data(INSTRUCTION_LV_XOR     ) <= size_general_data) and false;
          }

        //_front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST1    ] |= ;
        //_front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST2    ] |= ;
        //_front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST3    ] |= ;
        //_front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST4    ] |= ;
        //_front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST5    ] |= ;
        //_front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST6    ] |= ;
        //_front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST7    ] |= ;
        //_front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CUST8    ] |= ;

        // Test if a lsu is connected with this thread

        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LBS      ] |= (instruction_size_data(INSTRUCTION_L_LBS      ) <= size_general_data);
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LBZ      ] |= (instruction_size_data(INSTRUCTION_L_LBZ      ) <= size_general_data);
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LD       ] |= (instruction_size_data(INSTRUCTION_L_LD       ) <= size_general_data);
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LHS      ] |= (instruction_size_data(INSTRUCTION_L_LHS      ) <= size_general_data);
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LHZ      ] |= (instruction_size_data(INSTRUCTION_L_LHZ      ) <= size_general_data);
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LWS      ] |= (instruction_size_data(INSTRUCTION_L_LWS      ) <= size_general_data);
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_LWZ      ] |= (instruction_size_data(INSTRUCTION_L_LWZ      ) <= size_general_data);

        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SB       ] |= (instruction_size_data(INSTRUCTION_L_SB       ) <= size_general_data);
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SD       ] |= (instruction_size_data(INSTRUCTION_L_SD       ) <= size_general_data);
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SH       ] |= (instruction_size_data(INSTRUCTION_L_SH       ) <= size_general_data);
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_SW       ] |= (instruction_size_data(INSTRUCTION_L_SW       ) <= size_general_data);

//      _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_CSYNC    ]  = true;
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_MSYNC    ]  = true;
        _front_end_instruction_implemeted [num_front_end][num_context][INSTRUCTION_L_PSYNC    ]  = true;
      }

//     log_printf(TRACE,Core,FUNCTION,_("  * front_end_instruction_implemeted"));
//     for (uint32_t i=0; i<_nb_front_end; ++i)
//       for (uint32_t j=0; j<_nb_context[i]; ++j)
//         for (uint32_t k=0; k<NB_INSTRUCTION; ++k)
//           log_printf(TRACE,Core,FUNCTION,_("   [%d][%d][%d] = %d - type : %d, operation : %d, size_data : %d, latence :  %d")
//                      ,i,j,k,_front_end_instruction_implemeted[i][j][k]
//                      ,instruction_information(k)._type
//                      ,instruction_information(k)._operation
//                      ,instruction_size_data(k)
//                      ,_timing[0][instruction_information(k)._type][instruction_information(k)._operation]._latence);

    // Reedit timing
    {
      multi_execute_loop::execute_loop::execute_timing_t timing_tmp [_nb_functionnal_unit][_nb_type][_nb_operation];

      for (uint32_t i=0; i<_nb_functionnal_unit; ++i)
        for (uint32_t j=0; j<_nb_type; ++j)
          for (uint32_t k=0; k<_nb_operation; ++k)
            {
              timing_tmp [i][j][k]._latence = _timing [i][j][k]._latence;
              timing_tmp [i][j][k]._delay   = _timing [i][j][k]._delay  ;

              // Reset
              _timing [i][j][k]._latence = _timing [i][j][k]._delay = 0;
            }

      for (uint32_t i=0; i<_nb_thread; ++i)
        {
          uint32_t num_front_end = _link_context_with_thread [i].first;
          uint32_t num_context   = _link_context_with_thread [i].second;
          
          for (uint32_t j=0; j<_nb_functionnal_unit; ++j)
            {
              // Test if link
              if (not _link_thread_and_functionnal_unit[i][j])
                continue;
      
              for (uint32_t k=0; k<NB_INSTRUCTION; ++k)
                if (_front_end_instruction_implemeted [num_front_end][num_context][k])
                  {
                    uint32_t x = instruction_information(k)._type;
                    uint32_t y = instruction_information(k)._operation;

                    _timing[j][x][y]._latence = timing_tmp[j][x][y]._latence;
                    _timing[j][x][y]._delay   = timing_tmp[j][x][y]._delay  ;
                  }
            }
        } 
    }
    
    ALLOC1(_front_end_nb_inst_branch_complete             ,uint32_t         ,_nb_front_end);
    ALLOC2(_front_end_size_decod_queue                    ,uint32_t         ,_nb_front_end,_nb_decod_unit[it1]);
    ALLOC2(_front_end_decod_queue_scheme                  ,multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t
                                                                            ,_nb_front_end,_nb_decod_unit[it1]);
    ALLOC2(_front_end_nb_inst_decod                       ,uint32_t         ,_nb_front_end,_nb_decod_unit[it1]);
    ALLOC1(_front_end_sum_inst_decod                      ,uint32_t         ,_nb_front_end);
    ALLOC2(_front_end_nb_context_select                   ,uint32_t         ,_nb_front_end,_nb_decod_unit[it1]);
    ALLOC2(_front_end_context_select_priority             ,Tpriority_t      ,_nb_front_end,_nb_decod_unit[it1]);
    ALLOC2(_front_end_context_select_load_balancing       ,Tload_balancing_t,_nb_front_end,_nb_decod_unit[it1]);

    log_printf(TRACE,Core,FUNCTION,_("  * decod_unit"));

    for (uint32_t i=0; i<_nb_front_end; ++i)
      {
        uint32_t num_rename_bloc = _link_rename_bloc_with_front_end [i];
        uint32_t num_ooo_engine  = _link_rename_unit_with_rename_bloc [num_rename_bloc].first;

        _front_end_nb_inst_branch_complete [i] = _nb_inst_branch_complete [num_ooo_engine];
        _front_end_sum_inst_decod          [i] = 0;
        for (uint32_t j=0; j<_nb_decod_unit[i]; ++j)
          {
            uint32_t num_decod_bloc=_link_decod_bloc_with_decod_unit[i][j];
           
            log_printf(TRACE,Core,FUNCTION,_("  [%d][%d] -> %d"),i,j,num_decod_bloc);
 
            _front_end_size_decod_queue              [i][j] = _size_decod_queue              [num_decod_bloc];
            _front_end_decod_queue_scheme            [i][j] = _decod_queue_scheme            [num_decod_bloc];
            _front_end_nb_inst_decod                 [i][j] = _nb_inst_decod                 [num_decod_bloc];
            _front_end_sum_inst_decod                [i]   += _nb_inst_decod                 [num_decod_bloc];
            _front_end_nb_context_select             [i][j] = _nb_context_select             [num_decod_bloc];
            _front_end_context_select_priority       [i][j] = _context_select_priority       [num_decod_bloc];
            _front_end_context_select_load_balancing [i][j] = _context_select_load_balancing [num_decod_bloc];
          }
      }

    ALLOC1(_ooo_engine_nb_front_end                       ,uint32_t         ,_nb_ooo_engine);

    log_printf(TRACE,Core,FUNCTION,_("  * ooo_engine_nb_front_end"));
    
    {
      std::vector<uint32_t> list_front_end [_nb_ooo_engine];

      // initialization counter
      for (uint32_t i=0; i<_nb_ooo_engine; ++i)
        _ooo_engine_nb_front_end [i] = 0;

      // scan all front_end
      for (uint32_t i=0; i<_nb_front_end; ++i)
        {
          uint32_t num_rename_bloc = _link_rename_bloc_with_front_end [i];
          uint32_t num_ooo_engine  = _link_rename_unit_with_rename_bloc [num_rename_bloc].first;
        
          log_printf(TRACE,Core,FUNCTION,_("    * num_front_end             : %d"),i);
          log_printf(TRACE,Core,FUNCTION,_("      * num_rename_bloc         : %d"),num_rename_bloc);
          log_printf(TRACE,Core,FUNCTION,_("      * num_ooo_engine          : %d"),num_ooo_engine );
          log_printf(TRACE,Core,FUNCTION,_("      * ooo_engine_nb_front_end : %d"),_ooo_engine_nb_front_end [num_ooo_engine]);
           // insert a new front_end
          _ooo_engine_nb_front_end [num_ooo_engine] ++; // === list_front_end.size()
          list_front_end           [num_ooo_engine].push_back(i); // No double
        }

      log_printf(TRACE,Core,FUNCTION,_("  * translate_ooo_engine_num_front_end"));
      
      ALLOC2(_translate_ooo_engine_num_front_end            ,uint32_t         ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1]);
      for (uint32_t i=0; i<_nb_ooo_engine; ++i)
        {
//           log_printf(TRACE,Core,FUNCTION,_("   %d -> %d"),i,_ooo_engine_nb_front_end[i]);
              
          for (uint32_t j=0; j<_ooo_engine_nb_front_end[i] ;++j)
            {
              uint32_t num_front_end = list_front_end[i][j];
            
              log_printf(TRACE,Core,FUNCTION,_("   [%d][%d] -> %d"),i,j,num_front_end);
              
              _translate_ooo_engine_num_front_end [i][j] = num_front_end;
            }
        }
    }

    ALLOC1(_ooo_engine_nb_execute_loop                    ,uint32_t         ,_nb_ooo_engine);

    {
      // initialization counter
      for (uint32_t i=0; i<_nb_ooo_engine; ++i)
        _ooo_engine_nb_execute_loop [i] = 0;
            
      std::vector<uint32_t> list_execute_loop [_nb_ooo_engine];

      for (uint32_t i=0; i<_nb_thread; ++i)
        {
          uint32_t num_front_end    = _link_context_with_thread [i].first;
          uint32_t num_rename_bloc  = _link_rename_bloc_with_front_end [num_front_end];
          uint32_t num_ooo_engine   = _link_rename_unit_with_rename_bloc [num_rename_bloc].first;
          uint32_t num_execute_loop = _link_execute_unit_with_load_store_unit [i].first;
          list_execute_loop[num_ooo_engine].push_back(num_execute_loop);

          // One execute per ooo_engine
          // for (uint32_t j=0; j<_nb_functionnal_unit; ++j)
          //   if (_link_thread_and_functionnal_unit [i][j])
          //     {
          //       uint32_t num_execute_loop = _link_execute_unit_with_functionnal_unit [i].first;
          //       list_execute_loop[num_ooo_engine].push_back(num_execute_loop);
          //     }
        }

      // Sort and erase duplicate value
      for (uint32_t i=0; i<_nb_ooo_engine; ++i)
        {
          list_execute_loop[i] = sort_and_unique (list_execute_loop[i]);

          // {
          //   sort  (list_execute_loop[i].begin(),
          //          list_execute_loop[i].end());
          //   std::vector<uint32_t>::iterator it=std::unique(list_execute_loop[i].begin(),
          //                                                  list_execute_loop[i].end());
          //   list_execute_loop[i].erase(it,list_execute_loop[i].end());
          // }
          
          _ooo_engine_nb_execute_loop [i] = list_execute_loop[i].size();
        }

#if 0
      // // scan the dispatch table
      // for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      //   {
      //     for (uint32_t j=0; j<_nb_inst_issue_slot[i]; ++j)
      //       for (uint32_t k=0; k<_nb_read_bloc; ++k)
      //         {
      //           // have route between this slot's ooo_engine and an read_bloc
      //           if (_table_dispatch [i][j][k])
      //             {
      //               uint32_t num_execute_loop = _link_read_unit_with_read_bloc [k].first;
                    
      //               list_execute_loop[i].push_back(num_execute_loop);
      //             }
      //         }
                
      //     {
      //       sort  (list_execute_loop[i].begin(),
      //              list_execute_loop[i].end());
      //       std::vector<uint32_t>::iterator it=std::unique(list_execute_loop[i].begin(),
      //                                                      list_execute_loop[i].end());
      //       list_execute_loop[i].erase(it,list_execute_loop[i].end());
      //     }

      //     _ooo_engine_nb_execute_loop [i] = list_execute_loop[i].size();
      //   }
#endif

      log_printf(TRACE,Core,FUNCTION,_("  * translate_ooo_engine_num_execute_loop"));
      
      ALLOC2(_translate_ooo_engine_num_execute_loop         ,uint32_t         ,_nb_ooo_engine,_ooo_engine_nb_execute_loop[it1]);

      for (uint32_t i=0; i<_nb_ooo_engine; ++i)
        for (uint32_t j=0; j<list_execute_loop[i].size();++j)
          {
            uint32_t num_execute_loop = list_execute_loop[i][j];

            log_printf(TRACE,Core,FUNCTION,_("   [%d][%d] -> %d"),i,j,num_execute_loop);
            _translate_ooo_engine_num_execute_loop [i][j++] = num_execute_loop;
          }
    }

    ALLOC2(_ooo_engine_nb_context                         ,uint32_t         ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1]);
    ALLOC2(_ooo_engine_nb_inst_decod                      ,uint32_t         ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1]);

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_front_end[i]; ++j)
        {
          uint32_t num_front_end = _translate_ooo_engine_num_front_end [i][j];

          _ooo_engine_nb_context    [i][j] = _nb_context [num_front_end];
          _ooo_engine_nb_inst_decod [i][j] = 0;

          // All context is route to the same rename_unit 
          for (uint32_t k=0; k<_nb_decod_unit[num_front_end]; ++k)
            _ooo_engine_nb_inst_decod [i][j] += _front_end_nb_inst_decod [num_front_end][k];
        }

    ALLOC3(_ooo_engine_translate_num_context_to_num_thread,uint32_t         ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1],_ooo_engine_nb_context[it1][it2]);
    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_front_end[i]; ++j)
        {
          uint32_t num_front_end = _translate_ooo_engine_num_front_end [i][j];
          for (uint32_t k=0; k<_ooo_engine_nb_context[i][j]; ++k)
            {
              uint32_t num_thread = _link_thread_with_context[num_front_end][k];

              _ooo_engine_translate_num_context_to_num_thread [i][j][k] = num_thread;
            }
        }

    ALLOC2(_ooo_engine_nb_inst_execute                    ,uint32_t         ,_nb_ooo_engine,_ooo_engine_nb_execute_loop[it1]);

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_execute_loop[i]; ++j)
        {
          uint32_t num_execute_loop = _translate_ooo_engine_num_execute_loop [i][j];

          // each write_unit manage one instruction per cycle.
          _ooo_engine_nb_inst_execute [i][j] = _nb_write_unit [num_execute_loop];
        }
    
    ALLOC3(_ooo_engine_nb_branch_speculated               ,uint32_t         ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1],_ooo_engine_nb_context[it1][it2]);
    ALLOC2(_ooo_engine_link_rename_unit_with_front_end    ,uint32_t         ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1]);

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_front_end[i]; ++j)
        {
          uint32_t num_front_end = _translate_ooo_engine_num_front_end [i][j];

          for (uint32_t k=0; k<_nb_context[num_front_end];++k)
            {
              uint32_t num_thread = _link_thread_with_context[num_front_end][k];

              _ooo_engine_nb_branch_speculated [i][j][k] = _upt_size_queue [num_thread];
            }
          
          uint32_t num_rename_bloc = _link_rename_bloc_with_front_end  [num_front_end];
          uint32_t num_rename_unit = _link_rename_unit_with_rename_bloc[num_rename_bloc].second; 

          _ooo_engine_link_rename_unit_with_front_end [i][j] = num_rename_unit;
        }

    ALLOC2(_ooo_engine_nb_inst_insert                     ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1]);
//  ALLOC1(_ooo_engine_nb_inst_insert_rob                 ,uint32_t         ,_nb_ooo_engine);
    ALLOC2(_ooo_engine_nb_inst_retire                     ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1]);
    ALLOC2(_ooo_engine_rename_select_priority             ,Tpriority_t      ,_nb_ooo_engine,_nb_rename_unit[it1]);
    ALLOC2(_ooo_engine_rename_select_load_balancing       ,Tload_balancing_t,_nb_ooo_engine,_nb_rename_unit[it1]);
    ALLOC2(_ooo_engine_rename_select_nb_front_end_select  ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1]);
    ALLOC2(_ooo_engine_nb_general_register                ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1]);
    ALLOC2(_ooo_engine_nb_special_register                ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1]);
    ALLOC2(_ooo_engine_rat_scheme                         ,Trat_scheme_t    ,_nb_ooo_engine,_nb_rename_unit[it1]);
    ALLOC2(_ooo_engine_nb_reg_free                        ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1]);
    ALLOC2(_ooo_engine_nb_rename_unit_bank                ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1]);
//     ALLOC2(_ooo_engine_size_read_counter                  ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1]);

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      {
        log_printf(TRACE,Core,FUNCTION,_("OOO_Engine [%d] - nb_rename_unit %d"),i,_nb_rename_unit[i]);
//      _ooo_engine_nb_inst_insert_rob [i] = 0;

        for (uint32_t j=0; j<_nb_rename_unit[i]; ++j)
          {
            uint32_t num_rename_bloc = _link_rename_bloc_with_rename_unit [i][j];

            log_printf(TRACE,Core,FUNCTION,_("  * [%d] - num_rename_bloc %d, nb_inst_insert %d"),j,num_rename_bloc,_nb_inst_insert[num_rename_bloc]);
            
            _ooo_engine_nb_inst_insert                    [i][j] = _nb_inst_insert                    [num_rename_bloc];
//          _ooo_engine_nb_inst_insert_rob                [i]   += _nb_inst_insert                    [num_rename_bloc];
            _ooo_engine_nb_inst_retire                    [i][j] = _nb_inst_retire                    [num_rename_bloc];
            _ooo_engine_rename_select_priority            [i][j] = _rename_select_priority            [num_rename_bloc];
            _ooo_engine_rename_select_load_balancing      [i][j] = _rename_select_load_balancing      [num_rename_bloc];
            _ooo_engine_rename_select_nb_front_end_select [i][j] = _rename_select_nb_front_end_select [num_rename_bloc];
            _ooo_engine_nb_general_register               [i][j] = _nb_general_register               [num_rename_bloc];
            _ooo_engine_nb_special_register               [i][j] = _nb_special_register               [num_rename_bloc];
            _ooo_engine_rat_scheme                        [i][j] = _rat_scheme                        [num_rename_bloc];
            _ooo_engine_nb_reg_free                       [i][j] = _nb_reg_free                       [num_rename_bloc];
            _ooo_engine_nb_rename_unit_bank               [i][j] = _nb_rename_unit_bank               [num_rename_bloc];
//             _ooo_engine_size_read_counter                 [i][j] = _size_read_counter                 [num_rename_bloc];
          }
      }
    
//  ALLOC4(_network_table_dispatch                        ,bool             ,_nb_ooo_engine,_nb_inst_issue_slot[it1],_nb_execute_loop,_nb_read_unit[it3]);
//  ALLOC3(_ooo_engine_table_routing                      ,bool             ,_nb_ooo_engine,_nb_rename_unit[it1],_nb_inst_issue_slot[it1]);
//  ALLOC3(_ooo_engine_table_issue_type                   ,bool             ,_nb_ooo_engine,_nb_inst_issue_slot[it1],_nb_type);
    ALLOC2(_list_functionnal_unit_with_rename_unit        ,std::vector<uint32_t>,_nb_ooo_engine,_nb_rename_unit[it1]);
    ALLOC2(_list_load_store_unit_with_rename_unit         ,std::vector<uint32_t>,_nb_ooo_engine,_nb_rename_unit[it1]);

    for (uint32_t num_thread=0; num_thread<_nb_thread; ++num_thread)
      {
        uint32_t num_front_end    = _link_context_with_thread [num_thread].first;
        uint32_t num_rename_bloc  = _link_rename_bloc_with_front_end [num_front_end];
        uint32_t num_ooo_engine   = _link_rename_unit_with_rename_bloc [num_rename_bloc].first;
        uint32_t num_rename_unit  = _link_rename_unit_with_rename_bloc [num_rename_bloc].second;
        
        {
          uint32_t num_load_store_unit = _link_load_store_unit_with_thread [num_thread];
          
          log_printf(TRACE,Core,FUNCTION,_("  * list_load_store_unit_with_rename_unit [%d][%d] = %d"),
                     num_ooo_engine,
                     num_rename_unit,
                     num_load_store_unit);
          
          _list_load_store_unit_with_rename_unit [num_ooo_engine][num_rename_unit].push_back(num_load_store_unit);
        }
        
        for (uint32_t num_functionnal_unit=0;
             num_functionnal_unit<_nb_functionnal_unit;
             ++num_functionnal_unit)
          if (_link_thread_and_functionnal_unit[num_thread][num_functionnal_unit])
            {
              log_printf(TRACE,Core,FUNCTION,_("  * list_functionnal_unit_with_rename_unit [%d][%d] = %d"),
                         num_ooo_engine,
                         num_rename_unit,
                         num_functionnal_unit);
              
              _list_functionnal_unit_with_rename_unit [num_ooo_engine][num_rename_unit].push_back(num_functionnal_unit);
            }
      }

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      {
#if 0
// //         log_printf(TRACE,Core,FUNCTION,_("  * ooo_engine_table_issue_type [%d]"),i);

//         // Init
//         for (uint32_t j=0; j<_nb_inst_issue_slot[i]; ++j)
//           {
//             for (uint32_t k=0; k<_nb_execute_loop; ++k)
//               for (uint32_t l=0; l<_nb_read_unit[k]; ++l)
//                 _network_table_dispatch [i][j][k][l] = false;
//             // for (uint32_t k=0; k<_nb_rename_unit[i]; ++k)
//             //   _ooo_engine_table_routing [i][k][j] = false;
//             // for (uint32_t k=0; k<_nb_type; ++k)
//             //   _ooo_engine_table_issue_type [i][j][k] = false;
//           }

//         std::vector<uint32_t> list_thread_with_inst_issue [_nb_inst_issue_slot[i]];
        
//         for (uint32_t j=0; j<_nb_inst_issue_slot[i]; ++j)
//           {
//             for (uint32_t k=0; k<_nb_read_bloc; ++k)
//               // Test if the issue slot is linked with the read_bloc
//               if (_table_dispatch[i][j][k])
//                 {
//                   pair_dual x = _link_read_unit_with_read_bloc[k];
//                   _network_table_dispatch [i][j][x.first][x.second] = true;

//                   // Test functional unit connected with this read bloc
//                   for (uint32_t l=0; l<_nb_functionnal_unit; ++l)
//                     {
//                       // the issue slot [j] is connected with the read bloc [k] and it's connected with the functionnal_unit [l]
//                       if (_link_read_bloc_and_functionnal_unit [k][l])
//                         {
//                           // Scan timing table, test if have an instruction
// //                           for (uint32_t m=0; m<_nb_type; ++m)
// //                             for (uint32_t n=0; n<_nb_operation; ++n)
// //                               if (_timing[l][m][n]._latence > 0)
// //                                 {
// //                                   log_printf(TRACE,Core,FUNCTION,_("   [%d][%d] -> true"),j,m);
                                  
// //                                   _ooo_engine_table_issue_type [i][j][m] = true;
// //                                   break;
// //                                 }
                          
//                           for (uint32_t m=0; m<_nb_thread; ++m)
//                             {
//                               list_thread_with_inst_issue [j].push_back(m);
                              
//                               uint32_t num_front_end   = _link_context_with_thread [m].first;
//                               uint32_t num_rename_bloc = _link_rename_bloc_with_front_end[num_front_end];
//                               uint32_t num_rename_unit = _link_rename_unit_with_rename_bloc [num_rename_bloc].second;
                              
//                               _list_functionnal_unit_with_rename_unit [i][num_rename_unit].push_back(l);
//                             }
//                         }
//                     }

//                   // Test load store unit connected with this read bloc
//                   for (uint32_t l=0; l<_nb_load_store_unit; ++l)
//                     {
//                       // Test load store unit connected with this read bloc
//                       if (_link_read_bloc_and_load_store_unit [k][l])
//                        {
// //                        _ooo_engine_table_issue_type [i][j][TYPE_MEMORY] = true;
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_LBS)._type] |= (_timing[l][instruction_information(INSTRUCTION_L_LBS)._type][instruction_information(INSTRUCTION_L_LBS)._operation]._latence > 0);
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_LBZ)._type] |= (_timing[l][instruction_information(INSTRUCTION_L_LBZ)._type][instruction_information(INSTRUCTION_L_LBZ)._operation]._latence > 0);
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_LD )._type] |= (_timing[l][instruction_information(INSTRUCTION_L_LD )._type][instruction_information(INSTRUCTION_L_LD )._operation]._latence > 0);
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_LHS)._type] |= (_timing[l][instruction_information(INSTRUCTION_L_LHS)._type][instruction_information(INSTRUCTION_L_LHS)._operation]._latence > 0);
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_LHZ)._type] |= (_timing[l][instruction_information(INSTRUCTION_L_LHZ)._type][instruction_information(INSTRUCTION_L_LHZ)._operation]._latence > 0);
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_LWS)._type] |= (_timing[l][instruction_information(INSTRUCTION_L_LWS)._type][instruction_information(INSTRUCTION_L_LWS)._operation]._latence > 0);
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_LWZ)._type] |= (_timing[l][instruction_information(INSTRUCTION_L_LWZ)._type][instruction_information(INSTRUCTION_L_LWZ)._operation]._latence > 0);
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_SB )._type] |= (_timing[l][instruction_information(INSTRUCTION_L_SB )._type][instruction_information(INSTRUCTION_L_SB )._operation]._latence > 0);
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_SD )._type] |= (_timing[l][instruction_information(INSTRUCTION_L_SD )._type][instruction_information(INSTRUCTION_L_SD )._operation]._latence > 0);
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_SH )._type] |= (_timing[l][instruction_information(INSTRUCTION_L_SH )._type][instruction_information(INSTRUCTION_L_SH )._operation]._latence > 0);
// //                        _ooo_engine_table_issue_type [i][j][instruction_information(INSTRUCTION_L_SW )._type] |= (_timing[l][instruction_information(INSTRUCTION_L_SW )._type][instruction_information(INSTRUCTION_L_SW )._operation]._latence > 0);

//                           // the issue slot [j] is connected with the read bloc [k] and it's connected with the load_store_unit [l]
//                           for (uint32_t m=0; m<_nb_thread; ++m)
//                             {
//                               list_thread_with_inst_issue [j].push_back(m);
                              
//                               uint32_t num_front_end   = _link_context_with_thread [m].first;
//                               uint32_t num_rename_bloc = _link_rename_bloc_with_front_end[num_front_end];
//                               uint32_t num_rename_unit = _link_rename_unit_with_rename_bloc [num_rename_bloc].second;
                              
//                               log_printf(TRACE,Core,FUNCTION,_("  * list_load_store_unit_with_rename_unit [%d][%d][%d] = %d"),i,num_rename_unit,_list_load_store_unit_with_rename_unit [i][num_rename_unit].size(),l);

//                               _list_load_store_unit_with_rename_unit [i][num_rename_unit].push_back(l);
//                             }
//                         }
//                     }
//                 }
//             // sort and erase duplicate value
//             list_thread_with_inst_issue [j] = sort_and_unique (list_thread_with_inst_issue [j]);

//             // {
//             //   sort  (list_thread_with_inst_issue [j].begin(),
//             //          list_thread_with_inst_issue [j].end());
//             //   std::vector<uint32_t>::iterator it=unique(list_thread_with_inst_issue [j].begin(),
//             //                                             list_thread_with_inst_issue [j].end());
//             //   list_thread_with_inst_issue [j].erase(it,list_thread_with_inst_issue [j].end());
//             // }
//           }
#endif

        log_printf(TRACE,Core,FUNCTION,_("  * ooo_engine_table_routing [%d]"),i);
        for (uint32_t j=0; j<_nb_rename_unit[i]; ++j)
          {
            // sort and erase duplicate value
            _list_load_store_unit_with_rename_unit  [i][j] = sort_and_unique (_list_load_store_unit_with_rename_unit  [i][j]);

            // {
            //   sort  (_list_load_store_unit_with_rename_unit  [i][j].begin(),
            //          _list_load_store_unit_with_rename_unit  [i][j].end());
            //   std::vector<uint32_t>::iterator it=unique(_list_load_store_unit_with_rename_unit  [i][j].begin(),
            //                                             _list_load_store_unit_with_rename_unit  [i][j].end());
            //   _list_load_store_unit_with_rename_unit  [i][j].erase(it,_list_load_store_unit_with_rename_unit  [i][j].end());
            // }

            _list_functionnal_unit_with_rename_unit  [i][j] = sort_and_unique (_list_functionnal_unit_with_rename_unit  [i][j]);
            
            // {
            //   sort  (_list_functionnal_unit_with_rename_unit  [i][j].begin(),
            //          _list_functionnal_unit_with_rename_unit  [i][j].end());
            //   std::vector<uint32_t>::iterator it=unique(_list_functionnal_unit_with_rename_unit  [i][j].begin(),
            //                                             _list_functionnal_unit_with_rename_unit  [i][j].end());
            //   _list_functionnal_unit_with_rename_unit  [i][j].erase(it,_list_functionnal_unit_with_rename_unit  [i][j].end());
            // }

//             uint32_t num_rename_bloc = _link_rename_bloc_with_rename_unit[i][j];

//             for (uint32_t k=0; k<_nb_front_end; ++k)
//               // test if this front_end is connected with this rename_bloc
//               if (_link_rename_bloc_with_front_end[k] == num_rename_bloc)
//                 // the front end is connected with rename_bloc. Now test all slot issue that it can accepted this front_end
//                 for (uint32_t l=0; l<_nb_inst_issue_slot[i]; ++l)
//                   for (std::vector<uint32_t>::iterator it = list_thread_with_inst_issue [l].begin();
//                        it != list_thread_with_inst_issue [l].end();
//                        ++it)
//                     // Test if the this is in front_end [k]
//                     if (_link_context_with_thread[*it].first == k)
//                       {
//                         _ooo_engine_table_routing [i][j][l] |= true;
//                         log_printf(TRACE,Core,FUNCTION,_("   [%d][%d] -> true"),j,l);
//                       }
          }
      }
    
    ALLOC3(_network_table_issue_type  ,bool,_nb_execute_loop,_nb_read_unit[it1],_nb_type);
    ALLOC3(_network_table_issue_thread,bool,_nb_execute_loop,_nb_read_unit[it1],_nb_thread);

    log_printf(TRACE,Core,FUNCTION,_("  * network_table_issue_type and network_table_issue_thread"));
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_nb_read_unit[i]; ++j)
        {
          // init
          for (uint32_t t=0; t<_nb_type; ++t)
            _network_table_issue_type   [i][j][t] = false;
          for (uint32_t t=0; t<_nb_thread; ++t)
            _network_table_issue_thread [i][j][t] = false;

          // get number of read bloc
          uint32_t num_read_bloc = _link_read_bloc_with_read_unit[i][j];

          // for each functionnal unit : test if the read bloc is connected with the functionnal unit
          for (uint32_t k=0; k<_nb_functionnal_unit; ++k)
            if (_link_read_bloc_and_functionnal_unit [num_read_bloc][k])
              {
                // Scan timing table, test if have an instruction
                for (uint32_t t=0; t<_nb_type; ++t)
                  for (uint32_t o=0; o<_nb_operation; ++o)
                    if (_timing[k][t][o]._latence > 0)
                      {
                        log_printf(TRACE,Core,FUNCTION,_("  * network_table_issue_type   [%d][%d][%d] -> true"),i,j,t);
                        
                        _network_table_issue_type [i][j][t] = true;
                        break; // operation
                      }

                for (uint32_t t=0; t<_nb_thread; ++t)
                  if (_link_thread_and_functionnal_unit [t][k])
                    {
                      log_printf(TRACE,Core,FUNCTION,_("  * network_table_issue_thread [%d][%d][%d] -> true"),i,j,t);
                      
                      _network_table_issue_thread [i][j][t] = true;
                    }
              }
          
          // Test load store unit connected with this read bloc
          for (uint32_t k=0; k<_nb_load_store_unit; ++k)
            // Test load store unit connected with this read bloc
            if (_link_read_bloc_with_load_store_unit [k] == num_read_bloc)
              {
                {
                  uint32_t t = TYPE_MEMORY;
                  
                  log_printf(TRACE,Core,FUNCTION,_("  * network_table_issue_type   [%d][%d][%d] -> true"),i,j,t);
                  
                  _network_table_issue_type [i][j][t] = true;
                }

                for (uint32_t t=0; t<_nb_thread; ++t)
                  if (_link_load_store_unit_with_thread[t] == k)
                    {
                      log_printf(TRACE,Core,FUNCTION,_("  * network_table_issue_thread [%d][%d][%d] -> true"),i,j,t);
                      
                      _network_table_issue_thread [i][j][t] = true;
                    }
              }
        }

    ALLOC2(_ooo_engine_nb_load_store_unit                 ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1]);

    log_printf(TRACE,Core,FUNCTION,_("  * ooo_engine_nb_load_store_unit [nb_ooo_engine][nb_rename_unit]"));
    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_nb_rename_unit[i]; ++j)
        {
          _ooo_engine_nb_load_store_unit [i][j] = _list_load_store_unit_with_rename_unit [i][j].size();
          log_printf(TRACE,Core,FUNCTION,_("    [%d][%d] = %d"),i,j,_ooo_engine_nb_load_store_unit [i][j]);
        }

    ALLOC3(_ooo_engine_size_store_queue                   ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2]);
    ALLOC3(_ooo_engine_size_load_queue                    ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2]);
    ALLOC3(_ooo_engine_speculative_commit_predictor_scheme,Tpredictor_t     ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2]);
    ALLOC4(_ooo_engine_lsu_pht_size_counter               ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2],1);
    ALLOC4(_ooo_engine_lsu_pht_nb_counter                 ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2],1);
    ALLOC4(_ooo_engine_lsu_pht_scheme                     ,Tpht_scheme_t    ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2],1);
    ALLOC3(_ooo_engine_nb_inst_memory                     ,uint32_t         ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2]);
    ALLOC3(_ooo_engine_link_load_store_unit_with_context  ,uint32_t         ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1],_ooo_engine_nb_context[it1][it2]);
    
    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      {
        for (uint32_t j=0; j<_nb_rename_unit[i]; ++j)
          for (uint32_t k=0; k<_list_load_store_unit_with_rename_unit [i][j].size(); ++k)
            {
              uint32_t num_load_store_unit = _list_load_store_unit_with_rename_unit[i][j][k];
              
              _ooo_engine_size_store_queue                    [i][j][k] = _size_store_queue                    [num_load_store_unit];
              _ooo_engine_size_load_queue                     [i][j][k] = _size_load_queue                     [num_load_store_unit];
              _ooo_engine_speculative_commit_predictor_scheme [i][j][k] = _speculative_commit_predictor_scheme [num_load_store_unit];
	      for (uint32_t l=0; l<1; ++l)
		{
		  _ooo_engine_lsu_pht_size_counter [i][j][k][l] = _lsu_pht_size_counter [num_load_store_unit][l];
		  _ooo_engine_lsu_pht_nb_counter   [i][j][k][l] = _lsu_pht_nb_counter   [num_load_store_unit][l];
		  _ooo_engine_lsu_pht_scheme       [i][j][k][l] = _lsu_pht_scheme       [num_load_store_unit][l];
		}
              _ooo_engine_nb_inst_memory                      [i][j][k] = _nb_inst_memory                      [num_load_store_unit];
            }

        for (uint32_t j=0; j<_ooo_engine_nb_front_end[i]; ++j)
          {
            uint32_t num_front_end   = _translate_ooo_engine_num_front_end [i][j];
            uint32_t num_rename_bloc = _link_rename_bloc_with_front_end [num_front_end];
            uint32_t num_rename_unit = _link_rename_unit_with_rename_bloc [num_rename_bloc].second;

            std::vector<uint32_t> list_lsq = _list_load_store_unit_with_rename_unit[i][num_rename_unit];

            for (uint32_t k=0; k<_ooo_engine_nb_context[i][j]; ++k)
              {
                uint32_t num_thread          = _link_thread_with_context [num_front_end][k];
                uint32_t num_load_store_unit = _link_load_store_unit_with_thread [num_thread];
                uint32_t num_lsq;

                // Find correspondence between load_store_unit and num_load_store_unit in rename_unit
                for (num_lsq=0; num_lsq<list_lsq.size(); ++num_lsq)
                  if (list_lsq[num_lsq] == num_load_store_unit)
                    break;
#ifdef DEBUG_TEST
                if (num_lsq == list_lsq.size())
                  throw ERRORMORPHEO(FUNCTION,_("Load Store Unit search failed."));
#endif
                
                _ooo_engine_link_load_store_unit_with_context [i][j][k] = num_lsq;
              }
          }
      }

    ALLOC4(_ooo_engine_implement_group                    ,bool             ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1],_ooo_engine_nb_context[it1][it2],NB_GROUP);

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_front_end[i]; ++j)
        {
          uint32_t num_front_end = _translate_ooo_engine_num_front_end [i][j];
          
          for (uint32_t k=0; k<_ooo_engine_nb_context[i][j]; ++k)
            {
              uint32_t num_thread    = _link_thread_with_context [num_front_end][k];
            
              for (uint32_t l=0; l<NB_GROUP; ++l)
                _ooo_engine_implement_group [i][j][k][l] = false;
              
              _ooo_engine_implement_group [i][j][k][GROUP_SYSTEM_AND_CONTROL ] = true ; // always implemented
              _ooo_engine_implement_group [i][j][k][GROUP_DMMU               ] = false; // not yet implemented
              _ooo_engine_implement_group [i][j][k][GROUP_IMMU               ] = false; // not yet implemented
              _ooo_engine_implement_group [i][j][k][GROUP_DCACHE             ] = _implement_group [num_thread][GROUP_DCACHE];
              _ooo_engine_implement_group [i][j][k][GROUP_ICACHE             ] = false; // not yet implemented
              _ooo_engine_implement_group [i][j][k][GROUP_MAC                ] = 
                (_front_end_instruction_implemeted [num_front_end][k][INSTRUCTION_L_MAC  ] or
                 _front_end_instruction_implemeted [num_front_end][k][INSTRUCTION_L_MACI ] or
                 _front_end_instruction_implemeted [num_front_end][k][INSTRUCTION_L_MACRC] or
                 _front_end_instruction_implemeted [num_front_end][k][INSTRUCTION_L_MSB  ] );
              _ooo_engine_implement_group [i][j][k][GROUP_DEBUG              ] = false; // not yet implemented
              _ooo_engine_implement_group [i][j][k][GROUP_PERFORMANCE_COUNTER] = false; // not yet implemented
              _ooo_engine_implement_group [i][j][k][GROUP_POWER_MANAGEMENT   ] = false; // not yet implemented
              _ooo_engine_implement_group [i][j][k][GROUP_PIC                ] = false; // not yet implemented
              _ooo_engine_implement_group [i][j][k][GROUP_TICK_TIMER         ] = false; // not yet implemented
              _ooo_engine_implement_group [i][j][k][GROUP_FLOATING_POINT     ] = false; // not yet implemented
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_1         ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_2         ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_3         ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_4         ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_5         ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_6         ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_7         ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_8         ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_9         ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_10        ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_11        ] = false; // reserved
              _ooo_engine_implement_group [i][j][k][GROUP_RESERVED_12        ] = false; // reserved
              
              bool have_custom_unit = (_get_custom_information != NULL);

              _ooo_engine_implement_group [i][j][k][GROUP_CUSTOM_1           ] = (have_custom_unit and _get_custom_information()._get_valid_group(GROUP_CUSTOM_1));
              _ooo_engine_implement_group [i][j][k][GROUP_CUSTOM_2           ] = (have_custom_unit and _get_custom_information()._get_valid_group(GROUP_CUSTOM_2));
              _ooo_engine_implement_group [i][j][k][GROUP_CUSTOM_3           ] = (have_custom_unit and _get_custom_information()._get_valid_group(GROUP_CUSTOM_3));
              _ooo_engine_implement_group [i][j][k][GROUP_CUSTOM_4           ] = (have_custom_unit and _get_custom_information()._get_valid_group(GROUP_CUSTOM_4));
              _ooo_engine_implement_group [i][j][k][GROUP_CUSTOM_5           ] = (have_custom_unit and _get_custom_information()._get_valid_group(GROUP_CUSTOM_5));
              _ooo_engine_implement_group [i][j][k][GROUP_CUSTOM_6           ] = (have_custom_unit and _get_custom_information()._get_valid_group(GROUP_CUSTOM_6));
              _ooo_engine_implement_group [i][j][k][GROUP_CUSTOM_7           ] = (have_custom_unit and _get_custom_information()._get_valid_group(GROUP_CUSTOM_7));
              _ooo_engine_implement_group [i][j][k][GROUP_CUSTOM_8           ] = (have_custom_unit and _get_custom_information()._get_valid_group(GROUP_CUSTOM_8));
            }
        }

    ALLOC1(_execute_loop_nb_functionnal_unit                       ,uint32_t,_nb_execute_loop);
    ALLOC1(_execute_loop_nb_load_store_unit                        ,uint32_t,_nb_execute_loop);

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      {
        _execute_loop_nb_functionnal_unit [i] = _list_functionnal_unit_with_execute_unit [i].size();
        _execute_loop_nb_load_store_unit  [i] = _list_load_store_unit_with_execute_unit  [i].size();
      }
    
    ALLOC1(_list_ooo_engine_with_execute_loop                      ,std::vector<uint32_t>,_nb_execute_loop);
    ALLOC1(_list_front_end_with_execute_loop                       ,std::vector<uint32_t>,_nb_execute_loop);

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      {
        for (uint32_t j=0; j<_ooo_engine_nb_execute_loop[i]; ++j)
          {
            uint32_t num_execute_loop = _translate_ooo_engine_num_execute_loop [i][j];
            
            _list_ooo_engine_with_execute_loop [num_execute_loop].push_back(i);
    
            for (uint32_t k=0; k<_ooo_engine_nb_front_end[i]; ++k)
              {
                uint32_t num_front_end = _translate_ooo_engine_num_front_end [i][k];
                
                _list_front_end_with_execute_loop [num_execute_loop].push_back(num_front_end);
              }
          }
      }
    
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      {
        _list_ooo_engine_with_execute_loop[i] = sort_and_unique (_list_ooo_engine_with_execute_loop[i]);

        // {
        //   sort  (_list_ooo_engine_with_execute_loop[i].begin(),
        //          _list_ooo_engine_with_execute_loop[i].end());
        //   std::vector<uint32_t>::iterator it=unique(_list_ooo_engine_with_execute_loop[i].begin(),
        //                                             _list_ooo_engine_with_execute_loop[i].end());
        //   _list_ooo_engine_with_execute_loop[i].erase(it,_list_ooo_engine_with_execute_loop[i].end());
        // }

        _list_front_end_with_execute_loop[i] = sort_and_unique (_list_front_end_with_execute_loop[i]);

        // {
        //   sort  (_list_front_end_with_execute_loop[i].begin(),
        //          _list_front_end_with_execute_loop[i].end());
        //   std::vector<uint32_t>::iterator it=unique(_list_front_end_with_execute_loop[i].begin(),
        //                                             _list_front_end_with_execute_loop[i].end());
        //   _list_front_end_with_execute_loop[i].erase(it,_list_front_end_with_execute_loop[i].end());
        // }
      }


#if (DEBUG >= DEBUG_TRACE)

    log_printf(TRACE,Core,FUNCTION,_("list_ooo_engine_with_execute_loop"));
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_list_ooo_engine_with_execute_loop[i].size(); ++j)
        log_printf(TRACE,Core,FUNCTION,_("   [%d][%d] -> %d"),i,j,_list_ooo_engine_with_execute_loop[i][j]);
    
    log_printf(TRACE,Core,FUNCTION,_("list_front_end_with_execute_loop"));
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_list_front_end_with_execute_loop[i].size(); ++j)
        log_printf(TRACE,Core,FUNCTION,_("   [%d][%d] -> %d"),i,j,_list_front_end_with_execute_loop[i][j]);

#endif

    ALLOC1(_execute_loop_nb_front_end                              ,uint32_t,_nb_execute_loop);
    ALLOC1(_execute_loop_nb_context                                ,uint32_t,_nb_execute_loop);
    ALLOC1(_execute_loop_nb_ooo_engine                             ,uint32_t,_nb_execute_loop);
    ALLOC1(_execute_loop_nb_packet                                 ,uint32_t,_nb_execute_loop);
    ALLOC1(_execute_loop_nb_thread                                 ,uint32_t,_nb_execute_loop);

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      {
        log_printf(TRACE,Core,FUNCTION,_("execute_loop [%d] information :"),i);
    
        _execute_loop_nb_ooo_engine [i] = _list_ooo_engine_with_execute_loop[i].size();
    
        log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_nb_ooo_engine : %d"),_execute_loop_nb_ooo_engine [i]);
    
        uint32_t max_nb_front_end = 0;
        uint32_t max_nb_context   = 0;
        uint32_t max_size_rob     = 0;
    
        for (std::vector<uint32_t>::iterator it=_list_ooo_engine_with_execute_loop[i].begin();
             it!=_list_ooo_engine_with_execute_loop[i].end();
             ++it)
          {
            uint32_t num_ooo_engine = *it;
    
            max_size_rob     = std::max(max_size_rob,_size_re_order_buffer[num_ooo_engine]);
            max_nb_front_end = std::max(max_nb_front_end,_ooo_engine_nb_front_end[num_ooo_engine]);
    
            for (uint32_t j=0; j<_ooo_engine_nb_front_end[num_ooo_engine]; ++j)
              {
                uint32_t num_front_end = _translate_ooo_engine_num_front_end [num_ooo_engine][j];
    
                max_nb_context = std::max(max_nb_context,_nb_context[num_front_end]);
              }
          }
        _execute_loop_nb_front_end  [i] = max_nb_front_end;
        _execute_loop_nb_context    [i] = max_nb_context  ;
        _execute_loop_nb_packet     [i] = max_size_rob    ;
    
        log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_nb_front_end  : %d"),_execute_loop_nb_front_end  [i]);
        log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_nb_context    : %d"),_execute_loop_nb_context    [i]);
        log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_nb_packet     : %d"),_execute_loop_nb_packet     [i]);
    
        _execute_loop_nb_thread     [i] = get_nb_thread(_execute_loop_nb_context    [i],
                                                        _execute_loop_nb_front_end  [i],
                                                        _execute_loop_nb_ooo_engine [i]);
    
        log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_nb_thread     : %d"),_execute_loop_nb_thread     [i]);
      }
    
    ALLOC2(_translate_execute_loop_num_ooo_engine                  ,uint32_t,_nb_execute_loop,_execute_loop_nb_ooo_engine[it1]);
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_execute_loop_nb_ooo_engine[i]; ++j)
        {
          _translate_execute_loop_num_ooo_engine [i][j] = _list_ooo_engine_with_execute_loop[i][j];
        }  
    
    ALLOC2(_execute_loop_nb_inst_read                              ,uint32_t,_nb_execute_loop,_nb_read_unit[it1]);
    ALLOC2(_execute_loop_size_read_queue                           ,uint32_t,_nb_execute_loop,_nb_read_unit[it1]);
    ALLOC2(_execute_loop_size_reservation_station                  ,uint32_t,_nb_execute_loop,_nb_read_unit[it1]);
    ALLOC2(_execute_loop_nb_inst_retire                            ,uint32_t,_nb_execute_loop,_nb_read_unit[it1]);
    
    log_printf(TRACE,Core,FUNCTION,_("  * execute_loop - Read_unit"));
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      {
        log_printf(TRACE,Core,FUNCTION,_("    * [%d] nb_read_unit : %d"),i,_nb_read_unit[i]);
        
        for (uint32_t j=0; j<_nb_read_unit[i]; ++j)
          {
            uint32_t num_read_bloc = _link_read_bloc_with_read_unit [i][j];

            log_printf(TRACE,Core,FUNCTION,_("      * num_read_bloc : %d"),num_read_bloc);
            
            _execute_loop_nb_inst_read             [i][j] = _nb_inst_read             [num_read_bloc];
            _execute_loop_size_read_queue          [i][j] = _size_read_queue          [num_read_bloc];
            _execute_loop_size_reservation_station [i][j] = _size_reservation_station [num_read_bloc];
            _execute_loop_nb_inst_retire           [i][j] = _nb_inst_retire_reservation_station [num_read_bloc];
          }
      }

    ALLOC2(_execute_loop_nb_inst_functionnal_unit                  ,uint32_t,_nb_execute_loop,_execute_loop_nb_functionnal_unit[it1]);
    ALLOC4(_execute_loop_timing                                    ,multi_execute_loop::execute_loop::execute_timing_t
                                                                            ,_nb_execute_loop,_execute_loop_nb_functionnal_unit[it1],_nb_type,_nb_operation);
    ALLOC2(_execute_loop_is_load_store_unit                        ,bool    ,_nb_execute_loop,_nb_execute_unit[it1]);
    ALLOC2(_execute_loop_translate_num_execute_unit                ,uint32_t,_nb_execute_loop,_nb_execute_unit[it1]);
    
//     for (uint32_t i=0; i<_nb_execute_loop; ++i)
//       {
//         for (uint32_t j=0; j<_nb_execute_unit [i]; ++j)
//           {
//             _execute_loop_is_load_store_unit         [i][j] = false;
//             _execute_loop_translate_num_execute_unit [i][j] = 0;
//           }
//         for (uint32_t j=0; j<_execute_loop_nb_functionnal_unit[i]; ++j)
//           for (uint32_t k=0; k<_nb_type; ++k)
//             for (uint32_t l=0; l<_nb_operation; ++l)
//               _execute_loop_timing [i][j][k][l]._delay = _execute_loop_timing [i][j][k][l]._latence = 0;
//       }

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      {
        uint32_t num_lsu = 0;
        uint32_t num_fu  = 0;
        for (uint32_t j=0; j<_nb_execute_unit[i]; ++j)
          {
            uint32_t num_functionnal_unit = _link_functionnal_unit_with_execute_unit [i][j];
            uint32_t num_load_store_unit  = _link_load_store_unit_with_execute_unit  [i][j];
            
            bool is_lsu = (num_load_store_unit != _nb_load_store_unit);
            
            _execute_loop_is_load_store_unit [i][j] = is_lsu;
            
            if (is_lsu)
              {
                // update translation
                _execute_loop_translate_num_execute_unit [i][j] = num_lsu;
                num_lsu ++;
              }
            else
              {
                // update translation
                _execute_loop_translate_num_execute_unit [i][j] = num_fu;

                // timing information
                _execute_loop_nb_inst_functionnal_unit [i][num_fu] = _nb_inst_functionnal_unit [num_functionnal_unit];
                
                log_printf(TRACE,Core,FUNCTION,_("   * _execute_loop_nb_inst_functionnal_unit [%d][%d] = _nb_inst_functionnal_unit [%d] = %d"),i,num_fu,num_functionnal_unit,_nb_inst_functionnal_unit [num_functionnal_unit]);

                for (uint32_t k=0; k<_nb_type; ++k)
                  for (uint32_t l=0; l<_nb_operation; ++l)
                    {
//                       log_printf(TRACE,Core,FUNCTION,_("execute_loop_timing [%d][%d][%d][%d] = timing [%d][%d][%d]"),i,num_fu,k,l,num_functionnal_unit,k,l);
                      _execute_loop_timing [i][num_fu][k][l] = _timing [num_functionnal_unit][k][l];
                    }
                
//               // is not a load store unit
//               for (uint32_t k=0; k<_nb_operation; ++k)
//                 _execute_loop_timing [i][j][TYPE_MEMORY][k]._delay = _execute_loop_timing [i][j][TYPE_MEMORY][k]._latence = 0;

                num_fu ++;
              }
          }
      }
    
    ALLOC2(_execute_loop_size_store_queue                          ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC2(_execute_loop_size_load_queue                           ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC2(_execute_loop_size_speculative_access_queue             ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC2(_execute_loop_nb_store_queue_bank                       ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC2(_execute_loop_nb_load_queue_bank                        ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC2(_execute_loop_nb_port_check                             ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC2(_execute_loop_speculative_load                          ,multi_execute_loop::execute_loop::Tspeculative_load_t
                                                                                ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC2(_execute_loop_speculative_commit_predictor_scheme       ,Tpredictor_t,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    // ALLOC3(_execute_loop_lsu_pht_size_counter                      ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1],1);
    // ALLOC3(_execute_loop_lsu_pht_nb_counter                        ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1],1);
    ALLOC2(_execute_loop_nb_bypass_memory                          ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC2(_execute_loop_nb_cache_port                             ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC2(_execute_loop_nb_inst_memory                            ,uint32_t    ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_execute_loop_nb_load_store_unit[i]; ++j)
        {
          uint32_t num_load_store_unit = _list_load_store_unit_with_execute_unit [i][j];
    
          log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_nb_load_store_unit [%d][%d] : %d"),i,j,num_load_store_unit);
          log_printf(TRACE,Core,FUNCTION,_("    * nb_bypass_memory : %d"),_nb_bypass_memory[num_load_store_unit]);

          _execute_loop_size_store_queue                    [i][j] = _size_store_queue                    [num_load_store_unit];
          _execute_loop_size_load_queue                     [i][j] = _size_load_queue                     [num_load_store_unit];
          _execute_loop_size_speculative_access_queue       [i][j] = _size_speculative_access_queue       [num_load_store_unit];
          _execute_loop_nb_store_queue_bank                 [i][j] = _nb_store_queue_bank                 [num_load_store_unit];
          _execute_loop_nb_load_queue_bank                  [i][j] = _nb_load_queue_bank                  [num_load_store_unit];
          _execute_loop_nb_port_check                       [i][j] = _nb_port_check                       [num_load_store_unit];
          _execute_loop_speculative_load                    [i][j] = _speculative_load                    [num_load_store_unit];
          _execute_loop_speculative_commit_predictor_scheme [i][j] = _speculative_commit_predictor_scheme [num_load_store_unit];
          // for (uint32_t k=0; k<1; ++k)
          //   {
          // _execute_loop_lsu_pht_size_counter             [i][j][k] = _lsu_pht_size_counter                [num_load_store_unit][k];
          // _execute_loop_lsu_pht_nb_counter               [i][j][k] = _lsu_pht_nb_counter                  [num_load_store_unit][k];
          //   }
          _execute_loop_nb_bypass_memory                    [i][j] = _nb_bypass_memory                    [num_load_store_unit];
          _execute_loop_nb_cache_port                       [i][j] = _nb_cache_port                       [num_load_store_unit];
          _execute_loop_nb_inst_memory                      [i][j] = _nb_inst_memory                      [num_load_store_unit];
        }

    ALLOC2(_execute_loop_nb_inst_write                             ,uint32_t,_nb_execute_loop,_nb_write_unit[it1]);
    ALLOC2(_execute_loop_size_write_queue                          ,uint32_t,_nb_execute_loop,_nb_write_unit[it1]);
    ALLOC2(_execute_loop_size_execute_queue                        ,uint32_t,_nb_execute_loop,_nb_write_unit[it1]);
    ALLOC2(_execute_loop_nb_bypass_write                           ,uint32_t,_nb_execute_loop,_nb_write_unit[it1]);
    ALLOC2(_execute_loop_write_queue_scheme                        ,multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t,_nb_execute_loop,_nb_write_unit[it1]);
    
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_nb_write_unit[i]; ++j)
        {
          uint32_t num_write_bloc = _link_write_bloc_with_write_unit [i][j];
    
          _execute_loop_nb_inst_write      [i][j] = _nb_inst_write      [num_write_bloc];
          _execute_loop_size_write_queue   [i][j] = _size_write_queue   [num_write_bloc];
          _execute_loop_size_execute_queue [i][j] = _size_execute_queue [num_write_bloc];
          _execute_loop_nb_bypass_write    [i][j] = _nb_bypass_write    [num_write_bloc];
          _execute_loop_write_queue_scheme [i][j] = _write_queue_scheme [num_write_bloc];
        }
    
    ALLOC2(_execute_loop_nb_general_register                       ,uint32_t,_nb_execute_loop,_execute_loop_nb_ooo_engine[it1]);
    ALLOC2(_execute_loop_nb_special_register                       ,uint32_t,_nb_execute_loop,_execute_loop_nb_ooo_engine[it1]);
//  ALLOC2(_execute_loop_nb_inst_insert_rob                        ,uint32_t,_nb_execute_loop,_execute_loop_nb_ooo_engine[it1]);
//  ALLOC2(_execute_loop_nb_inst_retire_rob                        ,uint32_t,_nb_execute_loop,_execute_loop_nb_ooo_engine[it1]);
    
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_execute_loop_nb_ooo_engine[i]; ++j)
        {
          uint32_t num_ooo_engine = _list_ooo_engine_with_execute_loop[i][j];
    
          // sum number of general register
          uint32_t gpr_reg = *std::max_element(_ooo_engine_nb_general_register[num_ooo_engine],
                                               _ooo_engine_nb_general_register[num_ooo_engine]+_nb_rename_unit[num_ooo_engine]);
    
          gpr_reg *= _nb_rename_unit[num_ooo_engine]; 
    
          _execute_loop_nb_general_register [i][j] = gpr_reg;
    
          // sum number of special register
          uint32_t spr_reg = *std::max_element(_ooo_engine_nb_special_register[num_ooo_engine],
                                               _ooo_engine_nb_special_register[num_ooo_engine]+_nb_rename_unit[num_ooo_engine]);
    
          spr_reg *= _nb_rename_unit[num_ooo_engine]; 
    
          _execute_loop_nb_special_register [i][j] = spr_reg;
    
    
//        uint32_t insert = 0;
//        uint32_t retire = 0;
//        
//        for (uint32_t k=0; k<_nb_rename_unit[num_ooo_engine]; ++k)
//          {
//            insert = _ooo_engine_nb_inst_insert [num_ooo_engine][k];
//            retire = _ooo_engine_nb_inst_retire [num_ooo_engine][k];
//          }
          
//        _execute_loop_nb_inst_insert_rob  [i][j] = insert;
//        _execute_loop_nb_inst_retire_rob  [i][j] = retire;
        }
    
    ALLOC2(_execute_loop_nb_execute_unit_port                      ,uint32_t,_nb_execute_loop,_nb_execute_unit[it1]);
    
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_nb_execute_unit[i]; ++j)
        {
          uint32_t num_functionnal_unit = _link_functionnal_unit_with_execute_unit [i][j];
          uint32_t num_load_store_unit  = _link_load_store_unit_with_execute_unit  [i][j];
    
          if (num_functionnal_unit != _nb_functionnal_unit)
            _execute_loop_nb_execute_unit_port [i][j] = _nb_inst_functionnal_unit [num_functionnal_unit];
          else
            {
              _execute_loop_nb_execute_unit_port [i][j] = _nb_inst_memory [num_load_store_unit];

#ifdef DEBUG_TEST
              if (num_load_store_unit == _nb_load_store_unit)
                throw ERRORMORPHEO(FUNCTION,_("execute_unit is not a functional unit and load store unit."));
#endif
            }
        }
    
    ALLOC4(_execute_loop_read_unit_to_execution_unit_table_routing ,bool    ,_nb_execute_loop,_nb_read_unit[it1],_nb_execute_unit[it1],_execute_loop_nb_execute_unit_port[it1][it2]);
    
    log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_read_unit_to_execution_unit_table_routing [execute_loop][read_unit][execute_unit][execute_unit_port]"));
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_nb_execute_unit[i]; ++j)
        {
          uint32_t num_functionnal_unit = _link_functionnal_unit_with_execute_unit [i][j];
          uint32_t num_load_store_unit  = _link_load_store_unit_with_execute_unit  [i][j];
          
          bool is_lsu = (num_load_store_unit != _nb_load_store_unit);
          
          for (uint32_t l=0; l<_nb_read_unit[i];++l)
            {
              uint32_t num_read_bloc = _link_read_bloc_with_read_unit [i][l];
              bool link = false;
              
              if (is_lsu)
                link = (_link_read_bloc_with_load_store_unit [num_load_store_unit] == num_read_bloc);
              else
                link = _link_read_bloc_and_functionnal_unit [num_read_bloc][num_functionnal_unit];
              
              log_printf(TRACE,Core,FUNCTION,_("   [%d][%d][%d][all (%d)] -> %d"),i,l,j,_execute_loop_nb_execute_unit_port [i][j],link);
              
              for (uint32_t k=0; k<_execute_loop_nb_execute_unit_port [i][j]; ++k)
                _execute_loop_read_unit_to_execution_unit_table_routing [i][l][j][k] = link;
            }
        }
    
    ALLOC4(_execute_loop_execution_unit_to_write_unit_table_routing,bool    ,_nb_execute_loop,_nb_execute_unit[it1],_execute_loop_nb_execute_unit_port[it1][it2],_nb_write_unit[it1]);
    
    log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_execution_unit_to_write_unit_table_routing [execute_loop][execute_unit][execute_unit_port][write_unit]"));

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_nb_execute_unit[i]; ++j)
        {
          uint32_t num_functionnal_unit = _link_functionnal_unit_with_execute_unit [i][j];
          uint32_t num_load_store_unit  = _link_load_store_unit_with_execute_unit  [i][j];
          
          bool is_lsu = (num_load_store_unit != _nb_load_store_unit);
          
          for (uint32_t l=0; l<_nb_write_unit[i];++l)
            {
              uint32_t num_write_bloc = _link_write_bloc_with_write_unit [i][l];
              bool link = false;
              
              if (is_lsu)
                link = (_link_write_bloc_with_load_store_unit [num_load_store_unit] == num_write_bloc);
              else
                link = _link_write_bloc_and_functionnal_unit [num_write_bloc][num_functionnal_unit];
              
              log_printf(TRACE,Core,FUNCTION,_("   [%d][%d][all (%d)][%d] -> %d"),i,j,_execute_loop_nb_execute_unit_port [i][j],l,link);
              
              for (uint32_t k=0; k<_execute_loop_nb_execute_unit_port [i][j]; ++k)
                _execute_loop_execution_unit_to_write_unit_table_routing [i][j][k][l] = link;
            }
        }
    
    ALLOC3(_execute_loop_read_unit_to_execution_unit_table_thread  ,bool    ,_nb_execute_loop,_nb_execute_unit[it1],_execute_loop_nb_thread[it1]);
    ALLOC3(_execute_loop_execution_unit_to_write_unit_table_thread ,bool    ,_nb_execute_loop,_nb_write_unit[it1],_execute_loop_nb_thread [it1]);
    
    log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_read_unit_to_execution_unit_table_thread"));
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      {
        for (uint32_t k=0; k<_execute_loop_nb_thread[i]; ++k)
          {
            for (uint32_t j=0; j<_nb_execute_unit[i]; ++j)
              _execute_loop_read_unit_to_execution_unit_table_thread  [i][j][k] = false;
            for (uint32_t j=0; j<_nb_write_unit[i]; ++j)
              _execute_loop_execution_unit_to_write_unit_table_thread [i][j][k] = false;
          }
    
        for (uint32_t j=0; j<_nb_execute_unit[i]; ++j)
          {
            uint32_t num_functionnal_unit = _link_functionnal_unit_with_execute_unit [i][j];
            uint32_t num_load_store_unit  = _link_load_store_unit_with_execute_unit  [i][j];
            
            bool is_lsu = (num_load_store_unit != _nb_load_store_unit);
       
            // Test this execute_unit
            for (uint32_t k=0; k<_nb_thread; ++k)
              {
                // Have a link ?
                bool have_link = (is_lsu)?(_link_load_store_unit_with_thread [k] == num_load_store_unit):(_link_thread_and_functionnal_unit [k][num_functionnal_unit]);
                
                if (have_link)
                    {
                      uint32_t num_thread = execute_loop_get_num_thread (i,k);

#ifdef DEBUG_TEST
                      if (num_thread == static_cast<Tcontext_t>(-1))
                        throw ERRORMORPHEO(FUNCTION,toString(_("execute_loop [%d] : thread %d is invalid."),i,k));
#endif

                      _execute_loop_read_unit_to_execution_unit_table_thread [i][j][num_thread] = true;
                      log_printf(TRACE,Core,FUNCTION,_("   [%d][%d][%d] -> Ok"),i,j,num_thread);
              
                    }
              }
    
            for (uint32_t k=0; k<_nb_write_unit[i]; ++k)
              {
                uint32_t num_write_bloc = _link_write_bloc_with_write_unit[i][k];
                bool     have_link = (is_lsu)?(_link_write_bloc_with_load_store_unit [num_load_store_unit]==num_write_bloc):(_link_write_bloc_and_functionnal_unit [num_write_bloc][num_functionnal_unit]);
                  
                if (have_link)
                  for (uint32_t l=0; l<_execute_loop_nb_thread [i]; ++l)
                    _execute_loop_execution_unit_to_write_unit_table_thread [i][k][l] |= _execute_loop_read_unit_to_execution_unit_table_thread  [i][j][l];
              }
          }
      }
    
    ALLOC2(_execute_loop_num_thread_valid                          ,bool    ,_nb_execute_loop,_execute_loop_nb_thread[it1]);

    log_printf(TRACE,Core,FUNCTION,_("  * execute_loop_num_thread_valid"));

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      {
        for (uint32_t j=0; j<_execute_loop_nb_thread[i]; ++j)
          _execute_loop_num_thread_valid [i][j] = false;

        for (uint32_t j=0; j<_nb_thread; ++j)
          {
            uint32_t num_thread = execute_loop_get_num_thread (i,j);
          
            if (num_thread != static_cast<Tcontext_t>(-1))
              {
                log_printf(TRACE,Core,FUNCTION,_("   [%d][%d] -> valid"),i,num_thread);

                _execute_loop_num_thread_valid [i][num_thread] = true;
              }
          }
      }


    ALLOC2(_icache_access_size_packet_id,uint32_t,_nb_front_end,_nb_context[it1]);
    ALLOC2(_icache_access_table_routing ,uint32_t,_nb_front_end,_nb_context[it1]);
    
    for (uint32_t i=0; i<_nb_front_end; ++i)
      for (uint32_t j=0; j<_nb_context[i]; ++j)
        {
          uint32_t num_thread = _link_thread_with_context [i][j];
          
          _icache_access_size_packet_id [i][j] = log2(_front_end_size_ifetch_queue[i][j]);
          _icache_access_table_routing  [i][j] = _link_icache_port_with_thread [num_thread];
        }
    
    ALLOC1(_icache_nb_instruction     ,uint32_t,_nb_icache_port);
    
    for (uint32_t i=0; i<_nb_icache_port; ++i)
      _icache_nb_instruction [i] = 0;
    for (uint32_t i=0; i<_nb_front_end; i++)
      for (uint32_t j=0; j<_nb_context[i]; j++)
        {
          uint32_t port = _icache_access_table_routing [i][j];
          
          // Take the greater
          if (_icache_nb_instruction[port] < _front_end_nb_inst_fetch [i][j])
            _icache_nb_instruction[port] = _front_end_nb_inst_fetch [i][j];
        }
  
    ALLOC2(_dcache_access_size_thread_id,uint32_t,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC2(_dcache_access_size_packet_id,uint32_t,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    ALLOC3(_dcache_access_table_routing ,uint32_t,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1],_execute_loop_nb_cache_port[it1][it2]);
    
    
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_execute_loop_nb_load_store_unit[i]; ++j)
        {
          uint32_t num_load_store_unit = _list_load_store_unit_with_execute_unit [i][j];
    
          for (uint32_t k=0; k<_execute_loop_nb_cache_port [i][j]; ++k)
            _dcache_access_table_routing [i][j][k] = _link_dcache_port_with_load_store_unit [num_load_store_unit][k];
    
          _dcache_access_size_thread_id [i][j] =  (log2(_execute_loop_nb_context    [i]) +
                                                   log2(_execute_loop_nb_front_end  [i]) +
                                                   log2(_execute_loop_nb_ooo_engine [i]));
    
          // max size +1 (+1 to add a bit to select the queue)
          _dcache_access_size_packet_id [i][j] = log2(std::max(_size_store_queue[num_load_store_unit],
                                                               _size_load_queue [num_load_store_unit]))+1;
        }

    ALLOC1(_dcache_access_nb_context                         ,uint32_t,_nb_execute_loop);

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      _dcache_access_nb_context [i] = 1<<max<uint32_t>(_dcache_access_size_thread_id [i],_execute_loop_nb_load_store_unit[i]);

    ALLOC3(_dcache_access_translate_load_store_unit_to_thread,uint32_t,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1],_dcache_access_nb_context[it1]);

    // parameters depends
    _size_context_id                       = log2(max<uint32_t>(_nb_context,_nb_front_end));
    _size_front_end_id                     = log2(_nb_front_end);

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_execute_loop_nb_load_store_unit[i]; ++j)
        {
          uint32_t num_load_store_unit = _list_load_store_unit_with_execute_unit [i][j];
          
          {
            uint32_t num_thread;
            for (num_thread = 0; num_thread<_nb_thread; ++num_thread)
              if (_link_load_store_unit_with_thread [num_thread] == num_load_store_unit)
                break;
#ifdef DEBUG_TEST
            if (num_thread == _nb_thread)
              throw ERRORMORPHEO(FUNCTION,toString(_("Load_store_unit [%d] is not link with a thread.\n"),num_load_store_unit));
#endif 
          }

          // init with an invalid thread_id
          for (uint32_t k=0; k<_dcache_access_nb_context [i]; ++k)
            _dcache_access_translate_load_store_unit_to_thread [i][j][k] = _nb_thread;
          
          // cf Load_store_unit : create thread_id 
          // dcache_req_context_id = ((ooo_engine_id<<(_param->_size_context_id + _param->_size_front_end_id )) |
          //                          (front_end_id <<(_param->_size_context_id)) |
          //                          (context_id));
          
          for (std::vector<uint32_t>::iterator it=_list_ooo_engine_with_execute_loop[i].begin();
               it!=_list_ooo_engine_with_execute_loop[i].end();
               ++it)
            {
              uint32_t num_ooo_engine = *it;
              for (uint32_t x=0; x<_ooo_engine_nb_front_end[num_ooo_engine]; ++x)
                {
                  uint32_t num_front_end = _translate_ooo_engine_num_front_end [num_ooo_engine][x];
                  
                  for (uint32_t num_context = 0; num_context < _nb_context[num_front_end]; ++num_context)
                    {
                      uint32_t num_thread = _link_thread_with_context [num_front_end][num_context];
                      
                      if (_link_load_store_unit_with_thread [num_thread] == num_load_store_unit)
                        {
                          uint32_t index = ((num_ooo_engine<<(_size_context_id + _size_front_end_id )) |
                                            (num_front_end <<(_size_context_id)) |
                                            (num_context));
                          
                          _dcache_access_translate_load_store_unit_to_thread [i][j][index] = num_thread;
                        }
                    }
                }
            }
        }

    ALLOC1(_issue_queue_in_order,bool,_nb_ooo_engine);
    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      _issue_queue_in_order [i] = (_issue_queue_scheme [i] == core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_IN_ORDER);

    // parameters depends
    _size_ooo_engine_id                    = log2(_nb_ooo_engine);
    _size_instruction_address              = size_general_data-2;
    _size_data_address                     = size_general_data;
    _size_nb_inst_decod                    = log2(max<uint32_t>(_size_decod_queue,_nb_decod_bloc    ))+1;
    _size_nb_inst_commit                   = log2(max<uint32_t>(_size_re_order_buffer,_nb_ooo_engine))+1;
    _size_depth                            = log2(max<uint32_t>(_upt_size_queue,_nb_thread));
    _size_ifetch_queue_ptr                 = log2(max<uint32_t>(_size_ifetch_queue,_nb_thread));
    _size_inst_ifetch_ptr                  = log2(max<uint32_t>(_nb_inst_fetch,_nb_thread));
    _size_rob_ptr                          = _size_nb_inst_commit; // nb_rob_bank must be a multiple of size_rob
    _size_load_queue_ptr                   = log2(max<uint32_t>(_size_load_queue ,_nb_load_store_unit));
    _size_store_queue_ptr                  = log2(max<uint32_t>(_size_store_queue,_nb_load_store_unit));
    _size_general_data                     = size_general_data;
    _size_special_data                     = size_special_data;
    _size_general_register                 = log2(max<uint32_t>(_nb_general_register,_nb_rename_bloc));
    _size_special_register                 = log2(max<uint32_t>(_nb_special_register,_nb_rename_bloc));
    
    _have_port_context_id                  = _size_context_id       > 0;
    _have_port_front_end_id                = _size_front_end_id     > 0;
    _have_port_ooo_engine_id               = _size_ooo_engine_id    > 0;
    _have_port_depth                       = _size_depth            > 0;
    _have_port_ifetch_queue_ptr            = _size_ifetch_queue_ptr > 0;
    _have_port_inst_ifetch_ptr             = _size_inst_ifetch_ptr  > 0;
    _have_port_rob_ptr                     = _size_rob_ptr          > 0;
    _have_port_load_queue_ptr              = _size_load_queue_ptr   > 0;

    // interface parameters 
    _size_icache_thread_id                 = log2(_nb_thread);
//  _size_icache_thread_id                 = log2(_nb_front_end) + log2(max<uint32_t>(_nb_context,_nb_front_end));
    _size_icache_packet_id                 = _size_ifetch_queue_ptr; 
//  _size_icache_packet_id                 = max<uint32_t>(_icache_access_size_packet_id,_nb_front_end, _nb_context);
    _size_icache_address                   = _size_instruction_address;
    _have_port_icache_thread_id            = _size_icache_thread_id > 0;
    _have_port_icache_packet_id            = _size_icache_packet_id > 0;
    _size_dcache_thread_id                 = _size_icache_thread_id;
//  _size_dcache_thread_id                 = (log2(_nb_execute_loop) +
//                                            log2(max<uint32_t>(_execute_loop_nb_load_store_unit, _nb_execute_loop)) +
//                                            log2(max<uint32_t>(_execute_loop_nb_cache_port, _nb_execute_loop, _execute_loop_nb_load_store_unit)) +
//                                            max<uint32_t>(_dcache_access_size_packet_id    , _nb_execute_loop, _execute_loop_nb_load_store_unit));
    _size_dcache_packet_id                 = max<uint32_t>(_dcache_access_size_packet_id, _nb_execute_loop, _execute_loop_nb_load_store_unit);
    _size_dcache_address                   = _size_data_address;
    _size_dcache_data                      = _size_general_data;
                                           
    _have_port_dcache_thread_id            = _size_dcache_thread_id > 0;
    _have_port_dcache_packet_id            = _size_dcache_packet_id > 0; // always 1


    _param_front_end = new core::multi_front_end::front_end::Parameters * [_nb_front_end];

    for (uint32_t i=0; i<_nb_front_end; ++i)
      _param_front_end [i]= new core::multi_front_end::front_end::Parameters 
        (
        _nb_context                             [i],
        _nb_decod_unit                          [i],
        _size_general_data                         ,
        _get_custom_information                    ,
        _front_end_size_ifetch_queue            [i],
        _front_end_ifetch_queue_scheme          [i],
        _front_end_nb_inst_fetch                [i],
        _front_end_instruction_implemeted       [i],
        _front_end_link_decod_unit_with_context [i],
        _front_end_size_decod_queue             [i],
        _front_end_decod_queue_scheme           [i],
        _front_end_nb_inst_decod                [i],
        _front_end_nb_context_select            [i],
        _front_end_context_select_priority      [i],
        _front_end_context_select_load_balancing[i],
        _nb_inst_branch_predict                 [i],
        _nb_inst_branch_decod                   [i],
        _nb_inst_branch_update                  [i],
        _front_end_nb_inst_branch_complete      [i],
        _btb_size_queue                         [i],
        _btb_associativity                      [i],
        _btb_size_counter                       [i],
        _btb_victim_scheme                      [i],
        _dir_predictor_scheme                   [i],
        _dir_have_bht                           [i],
        _dir_bht_size_shifter                   [i],
        _dir_bht_nb_shifter                     [i],
        _dir_have_pht                           [i],
        _dir_pht_size_counter                   [i],
        _dir_pht_nb_counter                     [i],
        _dir_pht_size_address_share             [i],
        _dir_pht_scheme                         [i],
        _front_end_ras_size_queue               [i],
        _front_end_upt_size_queue               [i],
        _front_end_ufpt_size_queue              [i],
        _size_nb_inst_commit                       ,
        _nb_thread                                 ,
        _link_thread_with_context               [i]
         );

    ALLOC1(_nb_inst_issue_queue,uint32_t,_nb_ooo_engine);

    _param_ooo_engine = new core::multi_ooo_engine::ooo_engine::Parameters * [_nb_ooo_engine];

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      {
    _param_ooo_engine [i] = new core::multi_ooo_engine::ooo_engine::Parameters 
      (
       _ooo_engine_nb_front_end                       [i],
       _ooo_engine_nb_context                         [i],
       _nb_rename_unit                                [i],
       _ooo_engine_nb_execute_loop                    [i],
       _ooo_engine_nb_inst_decod                      [i],
       _ooo_engine_nb_inst_insert                     [i],
       _ooo_engine_nb_inst_retire                     [i],
//     _nb_inst_issue                                 [i],
       _ooo_engine_nb_inst_execute                    [i],
       _nb_inst_reexecute                             [i],
       _nb_inst_commit                                [i],
       _nb_inst_branch_complete                       [i],
       _ooo_engine_nb_branch_speculated               [i],
       _size_nb_inst_decod                               ,
       _nb_rename_unit_select                         [i],
       _nb_execute_loop_select                        [i],
       _size_general_data                                ,
       _size_special_data                                ,
       _ooo_engine_link_rename_unit_with_front_end    [i],
       _size_re_order_buffer                          [i],
       _nb_re_order_buffer_bank                       [i],
       _retire_ooo_scheme                             [i],
       _commit_priority                               [i],
       _commit_load_balancing                         [i],
       _size_issue_queue                              [i],
       _issue_queue_scheme                            [i],
       _nb_issue_queue_bank                           [i],
       _issue_priority                                [i],
       _issue_load_balancing                          [i],
//     _ooo_engine_table_routing                      [i],
//     _ooo_engine_table_issue_type                   [i],
       _size_reexecute_queue                          [i],
       _ooo_engine_rename_select_priority             [i],
       _ooo_engine_rename_select_load_balancing       [i],
       _ooo_engine_rename_select_nb_front_end_select  [i],
       _ooo_engine_nb_general_register                [i],
       _ooo_engine_nb_special_register                [i],
       _ooo_engine_rat_scheme                         [i],
       _ooo_engine_nb_reg_free                        [i],
       _ooo_engine_nb_rename_unit_bank                [i],
//     _ooo_engine_size_read_counter                  [i],
       _ooo_engine_nb_load_store_unit                 [i],
       _ooo_engine_size_store_queue                   [i],
       _ooo_engine_size_load_queue                    [i],
       _ooo_engine_speculative_commit_predictor_scheme[i],
       _ooo_engine_lsu_pht_size_counter               [i],
       _ooo_engine_lsu_pht_nb_counter                 [i],
       _ooo_engine_lsu_pht_scheme                     [i],
       _ooo_engine_nb_inst_memory                     [i],
       _ooo_engine_link_load_store_unit_with_context  [i],
       _ooo_engine_implement_group                    [i],
       _nb_thread                                        ,
       _ooo_engine_translate_num_context_to_num_thread[i]
       );
    _nb_inst_issue_queue [i] = _param_ooo_engine [i]->_nb_inst_issue;
      }

    _param_execute_loop = new core::multi_execute_loop::execute_loop::Parameters * [_nb_execute_loop];

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      _param_execute_loop [i] = new core::multi_execute_loop::execute_loop::Parameters
        (
         _nb_read_unit                                            [i],
         _execute_loop_nb_functionnal_unit                        [i],
         _execute_loop_nb_load_store_unit                         [i],
         _nb_write_unit                                           [i],

         _execute_loop_nb_context                                 [i],
         _execute_loop_nb_front_end                               [i],
         _execute_loop_nb_ooo_engine                              [i],
         _execute_loop_nb_packet                                  [i],
         _size_general_data                                          ,
         _size_special_data                                          ,

         _execute_loop_nb_inst_read                               [i],
         _execute_loop_size_read_queue                            [i],
         _execute_loop_size_reservation_station                   [i],
         _execute_loop_nb_inst_retire                             [i],

         _execute_loop_nb_inst_functionnal_unit                   [i],
         _execute_loop_timing                                     [i],
         _get_custom_information                                     ,

         _execute_loop_size_store_queue                           [i],
         _execute_loop_size_load_queue                            [i],
         _execute_loop_size_speculative_access_queue              [i],
         _execute_loop_nb_store_queue_bank                        [i],
         _execute_loop_nb_load_queue_bank                         [i],
         _execute_loop_nb_port_check                              [i],
         _execute_loop_speculative_load                           [i],
         _execute_loop_speculative_commit_predictor_scheme        [i],
         // _execute_loop_lsu_pht_size_counter                       [i],
         // _execute_loop_lsu_pht_nb_counter                         [i],
         _execute_loop_nb_bypass_memory                           [i],
         _execute_loop_nb_cache_port                              [i],
         _execute_loop_nb_inst_memory                             [i],

         _execute_loop_nb_inst_write                              [i],
         _execute_loop_size_write_queue                           [i],
         _execute_loop_size_execute_queue                         [i],
         _execute_loop_nb_bypass_write                            [i],
         _execute_loop_write_queue_scheme                         [i],

         _nb_gpr_bank                                             [i],
         _nb_gpr_port_read_by_bank                                [i],
         _nb_gpr_port_write_by_bank                               [i],
         _nb_spr_bank                                             [i],
         _nb_spr_port_read_by_bank                                [i],
         _nb_spr_port_write_by_bank                               [i],
         _execute_loop_nb_general_register                        [i],
         _execute_loop_nb_special_register                        [i],
//       _execute_loop_nb_inst_insert_rob                         [i],
//       _execute_loop_nb_inst_retire_rob                         [i],

         _execution_unit_to_write_unit_priority                   [i],
         _execute_loop_execution_unit_to_write_unit_table_routing [i],
         _execute_loop_execution_unit_to_write_unit_table_thread  [i],

         _read_unit_to_execution_unit_priority                    [i],
         _execute_loop_read_unit_to_execution_unit_table_routing  [i],
         _execute_loop_read_unit_to_execution_unit_table_thread   [i],

         _execute_loop_is_load_store_unit                         [i],
         _execute_loop_translate_num_execute_unit                 [i],

         _execute_loop_num_thread_valid                           [i]
         );

    _param_icache_access = new core::icache_access::Parameters 
      (
       _nb_thread                   ,
       _nb_front_end                ,
       _nb_context                  ,
       _nb_icache_port              ,
       _size_icache_address         ,
       _size_icache_thread_id       ,
       _size_icache_packet_id       ,
       _front_end_nb_inst_fetch     ,
       _icache_access_size_packet_id,
       _icache_access_table_routing ,
       _icache_port_priority        ,
       _icache_port_load_balancing  ,
       _link_thread_with_context
       );

    _param_dcache_access = new core::dcache_access::Parameters 
      (
       _nb_thread                            ,
       _nb_execute_loop                      ,
       _execute_loop_nb_load_store_unit      ,
       _dcache_access_nb_context             ,
       _execute_loop_nb_cache_port           ,
       _nb_dcache_port                       ,
       _size_dcache_address                  ,
       _size_dcache_data                     ,
       _size_dcache_thread_id                ,
       _size_dcache_packet_id                ,
       _dcache_access_size_thread_id         ,
       _dcache_access_size_packet_id         ,
       _dcache_access_table_routing          ,
       _dcache_port_priority                 ,
       _dcache_port_load_balancing           ,
       _dcache_access_translate_load_store_unit_to_thread
       );

    _param_glue          = new core::core_glue::Parameters 
      (
       _nb_front_end                                  ,
       _nb_context                                    ,//[nb_front_end]
       _nb_ooo_engine                                 ,
       _nb_execute_loop                               ,
       _ooo_engine_nb_front_end                       ,//[nb_ooo_engine]
       _ooo_engine_nb_execute_loop                    ,//[nb_ooo_engine]
       _execute_loop_nb_ooo_engine                    ,//[nb_execute_loop]
       _front_end_sum_inst_decod                      ,//[nb_front_end] -> [sum_inst_decod]
       _front_end_nb_inst_branch_complete             ,//[nb_front_end]
       _nb_inst_branch_complete                       ,//[nb_ooo_engine]
//     _ooo_engine_nb_inst_insert_rob                 ,//[nb_ooo_engine]
       _nb_inst_reexecute                             ,//[nb_ooo_engine]
       _nb_inst_issue_queue                           ,//[nb_ooo_engine]
//     _nb_inst_issue_slot                            ,//[nb_ooo_engine]
       _ooo_engine_nb_inst_execute                    ,//[nb_ooo_engine][ooo_engine_nb_execute_loop]
       _issue_queue_in_order                          ,//[nb_ooo_engine]
       _nb_read_unit                                  ,//[nb_execute_loop]
       _nb_write_unit                                 ,//[nb_execute_loop]
       _size_depth                                    ,
       _size_rob_ptr                                  ,
       _size_load_queue_ptr                           ,
       _size_store_queue_ptr                          ,
       _size_general_data                             ,
       _size_special_data                             ,
       _size_general_register                         ,
       _size_special_register                         ,
       _dispatch_priority                             ,
       _dispatch_load_balancing                       ,
//     _network_table_dispatch                        ,//[nb_ooo_engine][nb_inst_issue_slot][nb_execute_loop][nb_read_unit]
       _network_table_issue_type                      ,//                                   [nb_execute_loop][nb_read_unit][nb_type]
       _network_table_issue_thread                    ,//                                   [nb_execute_loop][nb_read_unit][nb_thread]
       _translate_ooo_engine_num_front_end            ,//[nb_ooo_engine][ooo_engine_nb_front_end]
       _translate_ooo_engine_num_execute_loop         ,//[nb_ooo_engine][ooo_engine_nb_execute_loop]
       _translate_execute_loop_num_ooo_engine         ,//[nb_execute_loop][execute_loop_nb_ooo_engine]
       _ooo_engine_translate_num_context_to_num_thread //[nb_ooo_engine][ooo_engine_nb_front_end][nb_context]
       );
    
    copy();

    log_end(Core,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Core::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Core,FUNCTION);
//     test();
//     log_end(Core,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Core::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_begin(Core,FUNCTION);

    for (uint32_t i=0; i<_nb_front_end; ++i)
    delete    _param_front_end [i];
    delete [] _param_front_end;
    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
    delete    _param_ooo_engine [i];
    delete [] _param_ooo_engine;
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
    delete    _param_execute_loop [i];
    delete [] _param_execute_loop;
    delete    _param_icache_access;
    delete    _param_dcache_access;
    delete    _param_glue;

    DELETE1(_nb_inst_issue_queue                                    ,_nb_ooo_engine);
    DELETE1(_issue_queue_in_order                                   ,_nb_ooo_engine);
    DELETE3(_dcache_access_translate_load_store_unit_to_thread      ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1],_dcache_access_nb_context[it1]);
    DELETE1(_dcache_access_nb_context                               ,_nb_execute_loop);
    DELETE3(_dcache_access_table_routing                            ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1],_execute_loop_nb_cache_port[it1][it2]);
    DELETE2(_dcache_access_size_packet_id                           ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_dcache_access_size_thread_id                           ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE1(_icache_nb_instruction                                  ,_nb_icache_port);
    DELETE2(_icache_access_table_routing                            ,_nb_front_end,_nb_context[it1]);
    DELETE2(_icache_access_size_packet_id                           ,_nb_front_end,_nb_context[it1]);
    DELETE2(_execute_loop_num_thread_valid                          ,_nb_execute_loop,_execute_loop_nb_thread[it1]);
    DELETE3(_execute_loop_execution_unit_to_write_unit_table_thread ,_nb_execute_loop,_nb_write_unit[it1],_execute_loop_nb_thread [it1]);
    DELETE3(_execute_loop_read_unit_to_execution_unit_table_thread  ,_nb_execute_loop,_nb_execute_unit[it1],_execute_loop_nb_thread[it1]);
    DELETE4(_execute_loop_execution_unit_to_write_unit_table_routing,_nb_execute_loop,_nb_execute_unit[it1],_execute_loop_nb_execute_unit_port[it1][it2],_nb_write_unit[it1]);
    DELETE4(_execute_loop_read_unit_to_execution_unit_table_routing ,_nb_execute_loop,_nb_read_unit[it1],_nb_execute_unit[it1],_execute_loop_nb_execute_unit_port[it1][it2]);
    DELETE2(_execute_loop_nb_execute_unit_port                      ,_nb_execute_loop,_nb_execute_unit[it1]);
//  DELETE2(_execute_loop_nb_inst_retire_rob                        ,_nb_execute_loop,_execute_loop_nb_ooo_engine[it1]);
//  DELETE2(_execute_loop_nb_inst_insert_rob                        ,_nb_execute_loop,_execute_loop_nb_ooo_engine[it1]);
    DELETE2(_execute_loop_nb_special_register                       ,_nb_execute_loop,_execute_loop_nb_ooo_engine[it1]);
    DELETE2(_execute_loop_nb_general_register                       ,_nb_execute_loop,_execute_loop_nb_ooo_engine[it1]);
    DELETE2(_execute_loop_write_queue_scheme                        ,_nb_execute_loop,_nb_write_unit[it1]);
    DELETE2(_execute_loop_nb_bypass_write                           ,_nb_execute_loop,_nb_write_unit[it1]);
    DELETE2(_execute_loop_size_execute_queue                        ,_nb_execute_loop,_nb_write_unit[it1]);
    DELETE2(_execute_loop_size_write_queue                          ,_nb_execute_loop,_nb_write_unit[it1]);
    DELETE2(_execute_loop_nb_inst_write                             ,_nb_execute_loop,_nb_write_unit[it1]);
    DELETE2(_execute_loop_nb_inst_memory                            ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_execute_loop_nb_cache_port                             ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_execute_loop_nb_bypass_memory                          ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    // DELETE3(_execute_loop_lsu_pht_nb_counter                        ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1],1);
    // DELETE3(_execute_loop_lsu_pht_size_counter                      ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1],1);
    DELETE2(_execute_loop_speculative_commit_predictor_scheme       ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_execute_loop_speculative_load                          ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_execute_loop_nb_port_check                             ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_execute_loop_nb_load_queue_bank                        ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_execute_loop_nb_store_queue_bank                       ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_execute_loop_size_speculative_access_queue             ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_execute_loop_size_load_queue                           ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_execute_loop_size_store_queue                          ,_nb_execute_loop,_execute_loop_nb_load_store_unit[it1]);
    DELETE2(_execute_loop_translate_num_execute_unit                ,_nb_execute_loop,_nb_execute_unit[it1]);
    DELETE2(_execute_loop_is_load_store_unit                        ,_nb_execute_loop,_nb_execute_unit[it1]);
    DELETE4(_execute_loop_timing                                    ,_nb_execute_loop,_execute_loop_nb_functionnal_unit[it1],_nb_type,_nb_operation);
    DELETE2(_execute_loop_nb_inst_functionnal_unit                  ,_nb_execute_loop,_execute_loop_nb_functionnal_unit[it1]);
    DELETE2(_execute_loop_nb_inst_retire                            ,_nb_execute_loop,_nb_read_unit[it1]);
    DELETE2(_execute_loop_size_reservation_station                  ,_nb_execute_loop,_nb_read_unit[it1]);
    DELETE2(_execute_loop_size_read_queue                           ,_nb_execute_loop,_nb_read_unit[it1]);
    DELETE2(_execute_loop_nb_inst_read                              ,_nb_execute_loop,_nb_read_unit[it1]);
    DELETE2(_translate_execute_loop_num_ooo_engine                  ,_nb_execute_loop,_execute_loop_nb_ooo_engine[it1]);
    DELETE1(_execute_loop_nb_thread                                 ,_nb_execute_loop);
    DELETE1(_execute_loop_nb_packet                                 ,_nb_execute_loop);
    DELETE1(_execute_loop_nb_ooo_engine                             ,_nb_execute_loop);
    DELETE1(_execute_loop_nb_context                                ,_nb_execute_loop);
    DELETE1(_execute_loop_nb_front_end                              ,_nb_execute_loop);
    DELETE1(_list_front_end_with_execute_loop                       ,_nb_execute_loop);
    DELETE1(_list_ooo_engine_with_execute_loop                      ,_nb_execute_loop);
    DELETE1(_execute_loop_nb_load_store_unit                        ,_nb_execute_loop);
    DELETE1(_execute_loop_nb_functionnal_unit                       ,_nb_execute_loop);
    DELETE4(_ooo_engine_implement_group                             ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1],_ooo_engine_nb_context[it1][it2],NB_GROUP);
    DELETE3(_ooo_engine_link_load_store_unit_with_context           ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1],_ooo_engine_nb_context[it1][it2]);
    DELETE3(_ooo_engine_nb_inst_memory                              ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2]);
    DELETE4(_ooo_engine_lsu_pht_scheme                              ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2],1);
    DELETE4(_ooo_engine_lsu_pht_nb_counter                          ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2],1);
    DELETE4(_ooo_engine_lsu_pht_size_counter                        ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2],1);
    DELETE3(_ooo_engine_speculative_commit_predictor_scheme         ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2]);
    DELETE3(_ooo_engine_size_load_queue                             ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2]);
    DELETE3(_ooo_engine_size_store_queue                            ,_nb_ooo_engine,_nb_rename_unit[it1],_ooo_engine_nb_load_store_unit[it1][it2]);
    DELETE2(_ooo_engine_nb_load_store_unit                          ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_list_load_store_unit_with_rename_unit                  ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_list_functionnal_unit_with_rename_unit                 ,_nb_ooo_engine,_nb_rename_unit[it1]);
//  DELETE3(_ooo_engine_table_issue_type                            ,_nb_ooo_engine,_nb_inst_issue_slot[it1],_nb_type);
//  DELETE3(_ooo_engine_table_routing                               ,_nb_ooo_engine,_nb_rename_unit[it1],_nb_inst_issue_slot[it1]);
    DELETE3(_network_table_issue_thread                                                                     ,_nb_execute_loop,_nb_read_unit[it1],_nb_thread);
    DELETE3(_network_table_issue_type                                                                       ,_nb_execute_loop,_nb_read_unit[it1],_nb_type);
//  DELETE4(_network_table_dispatch                                 ,_nb_ooo_engine,_nb_inst_issue_slot[it1],_nb_execute_loop,_nb_read_unit[it3]);
//  DELETE2(_ooo_engine_size_read_counter                           ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_ooo_engine_nb_rename_unit_bank                         ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_ooo_engine_nb_reg_free                                 ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_ooo_engine_rat_scheme                                  ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_ooo_engine_nb_special_register                         ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_ooo_engine_nb_general_register                         ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_ooo_engine_rename_select_nb_front_end_select           ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_ooo_engine_rename_select_load_balancing                ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_ooo_engine_rename_select_priority                      ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_ooo_engine_nb_inst_retire                              ,_nb_ooo_engine,_nb_rename_unit[it1]);
//  DELETE1(_ooo_engine_nb_inst_insert_rob                          ,_nb_ooo_engine);
    DELETE2(_ooo_engine_nb_inst_insert                              ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_ooo_engine_link_rename_unit_with_front_end             ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1]);
    DELETE3(_ooo_engine_nb_branch_speculated                        ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1],_ooo_engine_nb_context[it1][it2]);
    DELETE2(_ooo_engine_nb_inst_execute                             ,_nb_ooo_engine,_ooo_engine_nb_execute_loop[it1]);
    DELETE3(_ooo_engine_translate_num_context_to_num_thread         ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1],_ooo_engine_nb_context[it1][it2]);
    DELETE2(_ooo_engine_nb_inst_decod                               ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1]);
    DELETE2(_ooo_engine_nb_context                                  ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1]);
    DELETE2(_translate_ooo_engine_num_execute_loop                  ,_nb_ooo_engine,_ooo_engine_nb_execute_loop[it1]);
    DELETE1(_ooo_engine_nb_execute_loop                             ,_nb_ooo_engine);
    DELETE2(_translate_ooo_engine_num_front_end                     ,_nb_ooo_engine,_ooo_engine_nb_front_end[it1]);
    DELETE1(_ooo_engine_nb_front_end                                ,_nb_ooo_engine);
    DELETE2(_front_end_context_select_load_balancing                ,_nb_front_end,_nb_decod_unit[it1]);
    DELETE2(_front_end_context_select_priority                      ,_nb_front_end,_nb_decod_unit[it1]);
    DELETE2(_front_end_nb_context_select                            ,_nb_front_end,_nb_decod_unit[it1]);
    DELETE1(_front_end_sum_inst_decod                               ,_nb_front_end);
    DELETE2(_front_end_nb_inst_decod                                ,_nb_front_end,_nb_decod_unit[it1]);
    DELETE2(_front_end_decod_queue_scheme                           ,_nb_front_end,_nb_decod_unit[it1]);
    DELETE2(_front_end_size_decod_queue                             ,_nb_front_end,_nb_decod_unit[it1]);
    DELETE1(_front_end_nb_inst_branch_complete                      ,_nb_front_end);
    DELETE3(_front_end_instruction_implemeted                       ,_nb_front_end,_nb_context[it1],NB_INSTRUCTION);
    DELETE2(_front_end_ufpt_size_queue                              ,_nb_front_end,_nb_context[it1]);
    DELETE2(_front_end_upt_size_queue                               ,_nb_front_end,_nb_context[it1]);
    DELETE2(_front_end_ras_size_queue                               ,_nb_front_end,_nb_context[it1]);
    DELETE2(_front_end_link_decod_unit_with_context                 ,_nb_front_end,_nb_context[it1]);
    DELETE2(_front_end_nb_inst_fetch                                ,_nb_front_end,_nb_context[it1]);
    DELETE2(_front_end_ifetch_queue_scheme                          ,_nb_front_end,_nb_ifetch_unit[it1]);
    DELETE2(_front_end_size_ifetch_queue                            ,_nb_front_end,_nb_context[it1]);
    DELETE1(_list_load_store_unit_with_execute_unit                 ,_nb_execute_loop);
    DELETE1(_list_functionnal_unit_with_execute_unit                ,_nb_execute_loop);
    DELETE2(_link_load_store_unit_with_execute_unit                 ,_nb_execute_loop,_nb_execute_unit[it1]);
    DELETE2(_link_functionnal_unit_with_execute_unit                ,_nb_execute_loop,_nb_execute_unit[it1]);
    DELETE2(_link_write_bloc_with_write_unit                        ,_nb_execute_loop,_nb_write_unit[it1]);
    DELETE2(_link_read_bloc_with_read_unit                          ,_nb_execute_loop,_nb_read_unit[it1]);
    DELETE2(_link_rename_bloc_with_rename_unit                      ,_nb_ooo_engine,_nb_rename_unit[it1]);
    DELETE2(_link_decod_bloc_with_decod_unit                        ,_nb_front_end,_nb_decod_unit[it1]);
    DELETE2(_link_thread_with_context                               ,_nb_front_end,_nb_context[it1]);

    log_end(Core,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Core::copy"
  void Parameters::copy (void) 
  {
    log_begin(Core,FUNCTION);

    for (uint32_t i=0; i<_nb_front_end; ++i)
    COPY(_param_front_end [i]);
    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
    COPY(_param_ooo_engine [i]);
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
    COPY(_param_execute_loop [i]);
    COPY(_param_icache_access);
    COPY(_param_dcache_access);
    COPY(_param_glue);

    log_end(Core,FUNCTION);
  };

}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
