/*
 * $Id: RegisterFile_Monolithic_deallocation.cpp 146 2011-02-01 20:57:54Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  void RegisterFile_Monolithic::deallocation (void)
  {
    delete _component;

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK;
	delete    in_NRESET;

        DELETE1_SIGNAL( in_READ_VAL     ,_param->_nb_port_read,1);
        DELETE1_SIGNAL(out_READ_ACK     ,_param->_nb_port_read,1);
        DELETE1_SIGNAL( in_READ_ADDRESS ,_param->_nb_port_read,_param->_size_address);
        DELETE1_SIGNAL(out_READ_DATA    ,_param->_nb_port_read,_param->_size_word);
        
        DELETE1_SIGNAL( in_WRITE_VAL    ,_param->_nb_port_write,1);
        DELETE1_SIGNAL(out_WRITE_ACK    ,_param->_nb_port_write,1);
        DELETE1_SIGNAL( in_WRITE_ADDRESS,_param->_nb_port_write,_param->_size_address);
        DELETE1_SIGNAL( in_WRITE_DATA   ,_param->_nb_port_write,_param->_size_word);
                
        DELETE1(reg_DATA,_param->_nb_word);
      }
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
