//#ifdef STATISTICS
#ifndef morpheo_behavioural_Stat_binary_tree_h
#define morpheo_behavioural_Stat_binary_tree_h

#include "Behavioural/include/Stat_type.h"
#include "Common/include/ErrorMorpheo.h"
#include "Common/include/Message.h"
#include <string>
#include <map>
#include <list>
#include <iostream>

namespace morpheo {
namespace behavioural {

  typedef enum {NONE, VARIABLE, CONSTANT, OPERATOR_UNARY, OPERATOR_BINARY} data_type_t;

  typedef union 
  {
    counter_t   cst;
    counter_t * var;
    operator_t  op;
  } data_t;

class Stat_binary_tree
  {
    // arbre binaire
  private : Stat_binary_tree * _root;
  private : Stat_binary_tree * _left;
  private : Stat_binary_tree * _right;
  private : data_type_t        _data_type;
  private : data_t             _data;
    
    /*     private :  Stat_binary_tree (data_type_t data_type, data_t data); */
  public  :  Stat_binary_tree (std::string expr,
                               std::map<std::string, counter_t*> * operand);
  public  :  Stat_binary_tree (counter_t   cst);
  public  :  Stat_binary_tree (counter_t * var);
  public  :  Stat_binary_tree (operator_t  op );
    
  public  : ~Stat_binary_tree (void);
    
  private : void               insert_tree (Stat_binary_tree * tree);
  public  : Stat_binary_tree * insert_tree (counter_t   cst);
  public  : Stat_binary_tree * insert_tree (counter_t * var);
  public  : Stat_binary_tree * insert_tree (operator_t  op );

  private : void               change_type (counter_t   cst);
  private : void               change_type (counter_t * var);
  private : void               change_type (operator_t  op );
    
  public  : Stat_binary_tree * goto_top_level (void);
  public  : Stat_binary_tree * goto_next_root (void);

  public  : bool               valid    (void);

  public  : counter_t          eval     (void);

  private : counter_t          val_tree (void);
  private : counter_t          val_leaf (void);
  private : bool               is_leaf  (void);

  public  : void               import   (std::string expr,
                                         std::map<std::string, counter_t*> * operand);


  public  : void               print    (uint32_t depth=0);

//     public  : friend std::ostream& operator<< (std::ostream&, const morpheo::Stat_binary_tree &);
  };
};
};
#endif
//#endif
