/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Select_Priority_Fixed/SelfTest/include/test.h"

#define NB_PARAMS 3

void usage (int argc, char * argv[])
{
  cerr << "<Usage> " << argv[0] << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - nb_entity        (unsigned int)" << endl
       << " - encoding_one_hot (bool)" << endl
       << " - encoding_compact (bool)" << endl
       << "" << endl;

  for (int i=0; i<argc; i++)
    cerr << argv[i] << " ";
  cerr << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < 2+NB_PARAMS)
    usage (argc, argv);

  const string   name             = argv[1];
  const uint32_t nb_entity        = atoi(argv[2]);
  const bool     encoding_one_hot = atoi(argv[3]);
  const bool     encoding_compact = atoi(argv[4]);

  try 
    {
      morpheo::behavioural::generic::select::select_priority_fixed::Parameters param (nb_entity       ,
									       encoding_one_hot,
									       encoding_compact);
      
      cout << param.print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

