#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Select_Priority_Fixed/include/Select_Priority_Fixed.h"

#ifdef VHDL_TESTBENCH
# define VHDL_SET_PORT(name,direction,size) do {vhdl.set_port (name,direction,size); _vhdl_testbench->set_port (name,direction,size);} while (0)
#else
# define VHDL_SET_PORT(name,direction,size)     vhdl.set_port (name,direction,size)
#endif

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace select {
namespace select_priority_fixed {


  void Select_Priority_Fixed::vhdl_port (Vhdl & vhdl)
  {
    log_printf(FUNC,Select_Priority_Fixed,"vhdl_port","Begin");

    vhdl.set_port (" in_CLOCK ", IN, 1);
    VHDL_SET_PORT (" in_NRESET", IN, 1);
	
    for (uint32_t i=0; i<_param._nb_entity; i++)
      {
	VHDL_SET_PORT (" in_VAL_"+toString(i) , IN, 1);
	if (_param._encoding_one_hot)
	VHDL_SET_PORT ("out_ACK_"+toString(i) ,OUT, 1);
      }
    if (_param._encoding_compact)
      {
    VHDL_SET_PORT ("out_ENTITY    ",OUT,_param._size_entity);
    VHDL_SET_PORT ("out_ENTITY_ACK",OUT,1);
      }
    log_printf(FUNC,Select_Priority_Fixed,"vhdl_port","End");
  };

}; // end namespace select_priority_fixed
}; // end namespace select
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
