#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/include/Two_Level_Branch_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {


  void Two_Level_Branch_Predictor::vhdl_testbench_port ()
  {
    log_printf(FUNC,Two_Level_Branch_Predictor,"vhdl_testbench_port","Begin");

    _vhdl_testbench->set_port (" in_NRESET", IN, 1);

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	_vhdl_testbench->set_port (" in_PREDICT_VAL_"        +toString(i), IN, 1);
	_vhdl_testbench->set_port ("out_PREDICT_ACK_"        +toString(i),OUT, 1);
	_vhdl_testbench->set_port (" in_PREDICT_ADDRESS_"    +toString(i), IN,_param._size_address);
	if (_param._have_bht)
	_vhdl_testbench->set_port ("out_PREDICT_BHT_HISTORY_"+toString(i),OUT,_param._bht_size_shifter);
	if (_param._have_pht)
    	_vhdl_testbench->set_port ("out_PREDICT_PHT_HISTORY_"+toString(i),OUT,_param._pht_size_counter);
      }

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_VAL_"        +toString(i), IN, 1);
	_vhdl_testbench->set_port ("out_BRANCH_COMPLETE_ACK_"        +toString(i),OUT, 1);
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_ADDRESS_"    +toString(i), IN,_param._size_address);
	if (_param._have_bht)
    	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_BHT_HISTORY_"+toString(i), IN,_param._bht_size_shifter);
	if (_param._have_pht)
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_PHT_HISTORY_"+toString(i), IN,_param._pht_size_counter);
	_vhdl_testbench->set_port (" in_BRANCH_COMPLETE_DIRECTION_"  +toString(i), IN, 1);
      }

    log_printf(FUNC,Two_Level_Branch_Predictor,"vhdl_testbench_port","End");
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
