#ifndef SLOT_H
#define SLOT_H

#include <stdint.h>
#include <iostream>

using namespace std;

namespace hierarchy_memory
{
  namespace sort_file
  {
    template <class T>
    class slot_t
    {
    public    : uint32_t       delay;     // delay of disponibilty of data
    public    : T              data;

    public    : slot_t ()
      {
      }

    public    : slot_t (uint32_t delay, T data)
      {
	this->delay = delay;
	this->data  = data;
      }
	
    public    : friend ostream& operator<< (ostream& output_stream, const slot_t & x)
      {
	output_stream << x.delay << " " << x.data;	
	return output_stream;
      }
    };
   
  }; //sort_file
}; //hierarchy_memory
#endif //!SLOT_H
  
