#ifndef SERVICE_TIME_H
#define SERVICE_TIME_H

#include "../sim2os.h"

namespace hierarchy_memory {
  namespace sim2os {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~[service_time ]~~~~~
    void *
    Sim2os ::
    service_time ()
    {
      if (have_all_arguments(1) == false)
	{
	  cerr << "<" << NAME << "> Usage : time_t time(time_t * t);" << endl;
	  return NULL;
	}
  
      time_t     *t        = (time_t *)     convert_address(arguments[1]);
      void *      result   = (void *)       time(t);
      error                = errno;
  
      cout << "\n\t***** service : time          *****" << endl;
      cout << "\tt         : " << hex << (unsigned int) t                                      << endl;
      cout << "\tresult    : " << dec << (unsigned int) result << " - " << ctime((time_t *) t) << endl;
      cout << "\terrno     : " <<        (unsigned int) error                                  << endl;

      // Must swap, because it's a pointer
      t = (time_t *)swapBytes((char *)t,sizeof(time_t),sizeof(time_t));
  
      return      result;
    }

  };};
#endif //SERVICE_TIME_H
