/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Pseudo_LRU/include/Parameters.h"
#include "Behavioural/Generic/Select/Pseudo_LRU/include/Types.h"
#include <sstream>
using namespace std;

namespace morpheo {
namespace behavioural {
namespace generic {
namespace select {
namespace pseudo_lru {

  string Parameters::msg_error(void)
  {
    string msg = "";

    if (_nb_entity < 2)
      {
        msg += "  - nb_entity must be >= 2\n";
        msg += "    * nb_entity                       : " + toString(_nb_entity) + "\n";
      }

    if (is_positive(log2(_nb_entity)) == false)
      {
        msg += "  - nb_entity is not a power of 2\n";
        msg += "    * nb_entity                       : " + toString(_nb_entity) + "\n";
      }

    if (_nb_access <  1)
      {
        msg += "  - nb_access must be >= 1\n";
        msg += "    * nb_access                       : " + toString(_nb_access) + "\n";
      }

    if (_size_table < 1)
      {
        msg += "  - size_table must be >= 1\n";
        msg += "    * size_table                      : " + toString(_size_table) + "\n";
      }

    if (is_between_inclusive (static_cast<uint32_t>(log2(_nb_entity)),0 ,(8*sizeof(Tentity_t))) == false)
      {
        msg += "  - type \"Tentity_t\" is too little to the size defined by nb_entity\n";
        msg += "    * nb_entity                       : " + toString(_nb_entity) + "\n";
	msg += "    * Tentity_t                (bits) : " + toString(8*(sizeof(Tentity_t))) + "\n";
      }

    if (is_between_inclusive (static_cast<uint32_t>(log2(_size_table)),0 ,(8*sizeof(Taddress_t))) == false)
      {
        msg += "  - type \"Taddress_t\" is too little to the size defined by size_table\n";
        msg += "    * size_table                      : " + toString(_size_table)    + "\n";
	msg += "      > size                   (bits) : " + toString(log2(_size_table)) + "\n";
	msg += "    * Taddress_t               (bits) : " + toString(8*(sizeof(Taddress_t))) + "\n";
      }



    return msg;
  };

}; // end namespace pseudo_lru
}; // end namespace select
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
