%{
#include <iostream>
#include <list>

  using namespace std;
  
  list<int> list_token;
      
  // define in the lexer
  extern unsigned int lineno;
  
  int  yylex   ();
  void yyerror ( const char *);
%}

// Type of yylval
%union
{
  unsigned int value_int;
  float        value_float;
  char *       name ;
  char *       token;
}

// Dfinition des Tokens
// TOKEN

// Nom de balises
%token BEGIN_XML                END_XML
%token BEGIN_CPU                END_CPU
%token BEGIN_DEFINITION         END_DEFINITION
%token BEGIN_INTERNAL           END_INTERNAL
%token BEGIN_TYPE               END_TYPE      
%token BEGIN_LATENCE            END_LATENCE   
%token BEGIN_GLOBAL             END_GLOBAL
%token BEGIN_ISA                END_ISA
%token BEGIN_CACHE              END_CACHE
%token BEGIN_ICACHE             END_ICACHE
%token BEGIN_DCACHE             END_DCACHE
%token BEGIN_IFETCH             END_IFETCH
%token BEGIN_AFFECTATION
%token BEGIN_OPERATION
%token BEGIN_ALLOW
%token BEGIN_ORBIS
%token BEGIN_ORFPX
%token BEGIN_ORVDX
%token BEGIN_SIZE_DATA    
%token BEGIN_SCHEME_BYPASS
%token BEGIN_ARBITER
%token BEGIN_NB_PORT
%token BEGIN_NB_INST_FETCH   
%token BEGIN_SIZE_FETCH_QUEUE
%token BEGIN_LINK_ICACHE     
%token BEGIN_LINK_PREDICTOR  
%token BEGIN_LINK_DECOD      
%token                          END_SINGLETON
%token                          END_BALISE_DUAL

// Nom d'attribut
%token VERSION ENCODING NAME ID DELAY LATENCE TYPE VALUE ALGO

// Symbole
%token EQUAL QUOTE
// Type
%token INTEGER FLOAT STRING;

%type  <value_float> FLOAT   attribut_float;
%type  <value_int>   INTEGER attribut_integer;
%type  <name>        STRING  attribut_string;

%type  <value_int>   attribut_id attribut_delay attribut_latence attribut_type attribut_value
%type  <name>        attribut_name attribut_algo

%start file

// Rule to the grammar
%%

// *****{ Fichier }*****
file                             : file_header file_body 
                                 {
		                   cout << "file" << endl;
		                 }
                                 ;
		                 
file_header                      : balise_xml
                                 ;                     
		                 
file_body                        : balise_cpu
                                 ;

// ====={Balise "xml" }=====
balise_xml                       : begin_xml liste_attributs_xml end_xml
                                 ;
		                 
begin_xml                        : _begin_xml
                                 ;
		                 
_begin_xml                       : BEGIN_XML
                                 {
				   list_token.push_back(BEGIN_XML);
				 }
                                 ;

liste_attributs_xml              : VERSION attribut_float ENCODING attribut_string 
                                 {
		                   // Test
		                   if ($2 != 1.0)
		                     yyerror ("balise \"xml\" - attribut \"version\" - value is always equal at \"1.0\"");
		                   
		                   if (strcmp($4,"ISO-8859-1") != 0)
		                     yyerror ("balise \"xml\" - attribut \"version\" - value is always equal at \"ISO-8859-1\"");
		                 }
                                 ;
		                 
end_xml                          : _end_xml
                                 ;

// ====={Balise "cpu" }=====
// <cpu>
balise_cpu                       : begin_cpu body_cpu end_cpu
                                 ;
		                 
begin_cpu                        : _begin_cpu liste_attributs_cpu END_BALISE_DUAL
                                 ;
		                 
_begin_cpu                       : BEGIN_CPU
                                 {
				   list_token.push_back(BEGIN_CPU);
				 }
                                 ;

liste_attributs_cpu              : attribut_optionnel_name
                                 ;
		                 
body_cpu                         : empty
                                 | balise_internal body_cpu
                                 | balise_type     body_cpu
                                 | balises_latence body_cpu
                                 ;
		                 
end_cpu                          : END_CPU _end_balise_dual
                                 ;
	                 
// ====={Balise "type" }=====
// <cpu>
// +- <type>

balise_type                      : begin_type body_type end_type
                                 ;
	                         	     
begin_type                       : _begin_type liste_attributs_type END_BALISE_DUAL
                                 ;
	                         	     
_begin_type                      : BEGIN_TYPE
                                 {
				   list_token.push_back(BEGIN_TYPE);
				 }
                                 ;

liste_attributs_type             : empty
                                 ;
	                         	     
body_type                        : empty
                                 | balises_definition           body_type
                                 | balise_optionnel_affectation body_type
                                 ;

end_type                         : END_TYPE _end_balise_dual
                                 ;

// ====={Balise "definition" }=====
// <cpu> 
// +- <type>
//    +- <definition>

balises_definition               : balise_definition
                                 | balise_definition balises_definition
                                 ;
		                 
balise_definition                : begin_definition body_definition end_definition
                                 ;
		                   
begin_definition                 : _begin_definition liste_attributs_definition END_BALISE_DUAL
                                 ;
		                   
_begin_definition                : BEGIN_DEFINITION
                                 {
				   list_token.push_back(BEGIN_DEFINITION);
				 }
                                 ;

liste_attributs_definition       : attribut_id
                                 ;

body_definition                  : balises_allow
                                 ;

end_definition                   : END_DEFINITION _end_balise_dual
                                 ;

// ====={Balise "allow" }=====
// <cpu> 
// +- <type>
//    +- <definition>
//       +- <allow>

balises_allow                    : balise_allow
                                 | balise_allow balises_allow
                                 ;
		                 
balise_allow                     : _begin_allow liste_attributs_allow _end_singleton
                                 ;
		                   
_begin_allow                     : BEGIN_ALLOW
                                 {
				   list_token.push_back(BEGIN_ALLOW);
				 }
                                 ;

liste_attributs_allow            : attribut_id
                                 ;

// ====={Balise "affectation" }=====
// <cpu> 
// +- <type>
//    +- <affectation>

balise_optionnel_affectation     : empty
                                 | balise_affectation balise_optionnel_affectation
                                 ;
		                    
balise_affectation               : _begin_affectation liste_attributs_affectation _end_singleton
                                 ;
		                    
_begin_affectation               : BEGIN_AFFECTATION
                                 {
				   list_token.push_back(BEGIN_AFFECTATION);
				 }
                                 ;

liste_attributs_affectation      : attribut_name           attribut_optionnel_type    
                                 | attribut_optionnel_type attribut_name
                                 ;

// ====={Balise "latence" }=====
// <cpu> 
// +- <latence>

balises_latence                  : balise_latence
                                 | balise_latence balises_latence
                                 ;

balise_latence                   : begin_latence body_latence end_latence
                                 ;
		                    
begin_latence                    : _begin_latence liste_attributs_latence END_BALISE_DUAL
                                 ;
		                    
_begin_latence                   : BEGIN_LATENCE
                                 {
				   list_token.push_back(BEGIN_LATENCE);
				 }
                                 ;

liste_attributs_latence          : attribut_id
                                 ;
		                    
body_latence                     : balises_operation
                                 ;
		                    
end_latence                      : END_LATENCE _end_balise_dual
                                 ;

// ====={Balise "operation" }=====
// <cpu> 
// +- <latence>
//    +- <operation>

balises_operation                : empty
                                 | balise_operation balises_operation
                                 ;
		                 
balise_operation                 : _begin_operation liste_attributs_operation _end_singleton
                                 ;

_begin_operation                 : BEGIN_OPERATION
                                 {
				   list_token.push_back(BEGIN_OPERATION);
				 }
                                 ;
		                   
liste_attributs_operation        : attribut_name              attribut_optionnel_delay   attribut_optionnel_latence
                                 | attribut_name              attribut_optionnel_latence attribut_optionnel_delay
                                 | attribut_optionnel_delay   attribut_optionnel_latence attribut_name
                                 | attribut_optionnel_delay   attribut_name              attribut_optionnel_latence 
                                 | attribut_optionnel_latence attribut_optionnel_delay   attribut_name
                                 | attribut_optionnel_latence attribut_name              attribut_optionnel_delay   
                                 ;

// ====={Balise "internal" }=====
// <cpu> 
// +- <internal>

balise_internal                  : begin_internal body_internal end_internal
                                 ;

begin_internal                   : _begin_internal liste_attributs_internal END_BALISE_DUAL
                                 ;

_begin_internal                  : BEGIN_INTERNAL
                                 {
				   list_token.push_back(BEGIN_INTERNAL);
				 }
                                 ;
		                    
liste_attributs_internal         : empty
                                 ;
		                    
body_internal                    : empty
                                 | balise_global  body_internal
                                 | balise_cache   body_internal
                                 | balises_ifetch body_internal
                                 ;

end_internal                     : END_INTERNAL _end_balise_dual
                                 ;

// ====={Balise "global" }=====
// <cpu> 
// +- <internal>
//    +- <global>

balise_global                    : begin_global body_global end_global
                                 ;
		                    
begin_global                     : _begin_global liste_attributs_global END_BALISE_DUAL
                                 ;

_begin_global                    : BEGIN_GLOBAL
                                 {
				   list_token.push_back(BEGIN_GLOBAL);
				 }
                                 ;
		                    
liste_attributs_global           : empty
                                 ;
		                    
body_global                      : empty
                                 | balise_optionnel_isa body_global
                                 | balise_size_data     body_global
                                 | balise_scheme_bypass body_global
                                 ;
		                    
end_global                       : END_GLOBAL _end_balise_dual
                                 ;

// ====={Balise "isa" }=====
// <cpu> 
// +- <internal>
//    +- <global>
//       +- <isa>

balise_optionnel_isa             : empty
                                 | balise_isa  
                                 ;

balise_isa                       : begin_isa body_isa end_isa
                                 ;
		                    
begin_isa                        : _begin_isa liste_attributs_isa END_BALISE_DUAL
                                 ;
		                    
_begin_isa                       : BEGIN_ISA  
                                 {
				   list_token.push_back(BEGIN_ISA);
				 }
                                 ;

liste_attributs_isa              : empty
                                 ;
		                    
body_isa                         : empty
                                 | balise_optionnel_orbis body_isa
                                 | balise_optionnel_orfpx body_isa
                                 | balise_optionnel_orvdx body_isa
                                 ;
		                    
end_isa                          : END_ISA _end_balise_dual
                                 ;

// ====={Balise "orbis" }=====
// <cpu> 
// +- <internal>
//    +- <global>
//       +- <isa>
//          +- <orbis>

balise_optionnel_orbis           : empty
                                 | balise_orbis
                                 ;
		                 
balise_orbis                     : _begin_orbis liste_attributs_orbis _end_singleton
                                 ;

_begin_orbis                     : BEGIN_ORBIS
                                 {
				   list_token.push_back(BEGIN_ORBIS);
				 }
                                 ;
		                   
liste_attributs_orbis            : attribut_value          attribut_optionnel_type 
                                 | attribut_optionnel_type attribut_value
                                 ;

// ====={Balise "orfpx" }=====
// <cpu> 
// +- <internal>
//    +- <global>
//       +- <isa>
//          +- <orfpx>

balise_optionnel_orfpx           : empty
                                 | balise_orfpx
                                 ;
		                 
balise_orfpx                     : _begin_orfpx liste_attributs_orfpx _end_singleton
                                 ;
		                   
_begin_orfpx                     : BEGIN_ORFPX
                                 {
				   list_token.push_back(BEGIN_ORFPX);
				 }
                                 ;

liste_attributs_orfpx            : attribut_value          attribut_optionnel_type 
                                 | attribut_optionnel_type attribut_value
                                 ;

// ====={Balise "orvdx" }=====
// <cpu> 
// +- <internal>
//    +- <global>
//       +- <isa>
//          +- <orvdx>

balise_optionnel_orvdx           : empty
                                 | balise_orvdx
                                 ;
		                 
balise_orvdx                     : _begin_orvdx liste_attributs_orvdx _end_singleton
                                 ;

_begin_orvdx                     : BEGIN_ORVDX
                                 {
				   list_token.push_back(BEGIN_ORVDX);
				 }
                                 ;
		                   
liste_attributs_orvdx            : attribut_value          attribut_optionnel_type 
                                 | attribut_optionnel_type attribut_value
                                 ;

// ====={Balise "size_data" }=====
// <cpu> 
// +- <internal>
//    +- <global>
//       +- <size_data>

balise_size_data                 : _begin_size_data liste_attributs_size_data _end_singleton
                                 ;

_begin_size_data                 : BEGIN_SIZE_DATA
                                 {
				   list_token.push_back(BEGIN_SIZE_DATA);
				 }
                                 ;
		                   
liste_attributs_size_data        : attribut_value
                                 ;

// ====={Balise "scheme_bypass" }=====
// <cpu> 
// +- <internal>
//    +- <global>
//       +- <scheme_bypass>

balise_scheme_bypass             : _begin_scheme_bypass liste_attributs_scheme_bypass _end_singleton
                                 ;

_begin_scheme_bypass             : BEGIN_SCHEME_BYPASS
                                 {
				   list_token.push_back(BEGIN_SCHEME_BYPASS);
				 }
                                 ;
		                   
liste_attributs_scheme_bypass    : attribut_algo
                                 ;

// ====={Balise "cache" }=====
// <cpu> 
// +- <internal>
//    +- <cache>

balise_cache                     : begin_cache body_cache end_cache
                                 ;
		                    
begin_cache                      : _begin_cache liste_attributs_cache END_BALISE_DUAL
                                 ;
		                    
_begin_cache                     : BEGIN_CACHE
                                 {
				   list_token.push_back(BEGIN_CACHE);
				 }
                                 ;

liste_attributs_cache            : empty
                                 ;
		                    
body_cache                       : empty
                                 | balises_icache body_cache
                                 | balises_dcache body_cache
                                 ;
		                    
end_cache                        : END_CACHE _end_balise_dual
                                 ;

// ====={Balise "icache" }=====
// <cpu> 
// +- <internal>
//    +- <cache>
//       +- <icache>

balises_icache                   : balise_icache
                                 | balise_icache balises_icache
                                 ;

balise_icache                    : begin_icache body_icache end_icache
                                 ;
		                    
begin_icache                     : _begin_icache liste_attributs_icache END_BALISE_DUAL
                                 ;

_begin_icache                    : BEGIN_ICACHE
                                 {
				   list_token.push_back(BEGIN_ICACHE);
				 }
                                 ;
		                    
liste_attributs_icache           : attribut_id
                                 ;
		                    
body_icache                      : empty
                                 | balise_optionnel_arbiter body_icache
                                 | balise_optionnel_nb_port body_icache
                                 ;
		                    
end_icache                       : END_ICACHE _end_balise_dual
                                 ;

// ====={Balise "dcache" }=====
// <cpu> 
// +- <internal>
//    +- <cache>
//       +- <dcache>

balises_dcache                   : balise_dcache
                                 | balise_dcache balises_dcache
                                 ;

balise_dcache                    : begin_dcache body_dcache end_dcache
                                 ;
		                    
begin_dcache                     : _begin_dcache liste_attributs_dcache END_BALISE_DUAL
                                 ;
		                    
_begin_dcache                    : BEGIN_DCACHE
                                 {
				   list_token.push_back(BEGIN_DCACHE);
				 }
                                 ;

liste_attributs_dcache           : attribut_id
                                 ;
		                    
body_dcache                      : body_icache
                                 ;
		                    
end_dcache                       : END_DCACHE _end_balise_dual
                                 ;

// ====={Balise "arbiter" }=====
// <cpu> 
// +- <internal>
//    +- <cache>
//       +- <icache>
//       |  +- <arbiter>
//       +- <dcache>
//          +- <arbiter>

balise_optionnel_arbiter         : empty
                                 | balise_arbiter
                                 ;
		                 
balise_arbiter                   : _begin_arbiter liste_attributs_arbiter _end_singleton
                                 ;
		                   
_begin_arbiter                   : BEGIN_ARBITER
                                 {
				   list_token.push_back(BEGIN_ARBITER);
				 }
                                 ;

liste_attributs_arbiter          : attribut_algo
                                 ;

// ====={Balise "nb_port" }=====
// <cpu> 
// +- <internal>
//    +- <cache>
//       +- <icache>
//       |  +- <arbiter>
//       +- <dcache>
//          +- <arbiter>

balise_optionnel_nb_port         : empty
                                 | balise_nb_port
                                 ;
		                 
balise_nb_port                   : _begin_nb_port liste_attributs_nb_port _end_singleton
                                 ;

_begin_nb_port                   : BEGIN_NB_PORT
                                 {
				   list_token.push_back(BEGIN_NB_PORT);
				 }
                                 ;
		                   
liste_attributs_nb_port          : attribut_value
                                 ;

// ====={Balise "ifetch" }=====
// <cpu> 
// +- <internal>
//     +- <ifetch>

balises_ifetch                   : balise_ifetch
                                 | balise_ifetch balises_ifetch
                                 ;

balise_ifetch                    : begin_ifetch body_ifetch end_ifetch
                                 ;
		                    
begin_ifetch                     : _begin_ifetch liste_attributs_ifetch END_BALISE_DUAL
                                 ;

_begin_ifetch                    : BEGIN_IFETCH
                                 {
				   list_token.push_back(BEGIN_IFETCH);
				 }
                                 ;
		                    
liste_attributs_ifetch           : attribut_id
                                 ;
		                    
body_ifetch                      : empty
                                 | balise_optionnel_nb_inst_fetch    body_ifetch 
                                 | balise_optionnel_size_fetch_queue body_ifetch 
                                 | balise_link_icache                body_ifetch 
                                 | balise_link_predictor             body_ifetch 
                                 | balise_link_decod                 body_ifetch 
                                 ;
		                    
end_ifetch                       : END_IFETCH _end_balise_dual
                                 ;

// ====={Balise "nb_inst_fetch" }=====
// <cpu> 
// +- <internal>
//     +- <ifetch>
//        +- <nb_inst_fetch>

balise_optionnel_nb_inst_fetch   : empty
                                 | balise_nb_inst_fetch
                                 ;
		                 
balise_nb_inst_fetch             : _begin_nb_inst_fetch liste_attributs_nb_inst_fetch _end_singleton
                                 ;

_begin_nb_inst_fetch             : BEGIN_NB_INST_FETCH
                                 {
				   list_token.push_back(BEGIN_NB_INST_FETCH);
				 }
                                 ;
		                   
liste_attributs_nb_inst_fetch    : attribut_value
                                 ;

// ====={Balise "size_fetch_queue" }=====
// <cpu> 
// +- <internal>
//     +- <ifetch>
//        +- <size_fetch_queue>

balise_optionnel_size_fetch_queue: empty
                                 | balise_size_fetch_queue
                                 ;
		                 
balise_size_fetch_queue          : _begin_size_fetch_queue liste_attributs_size_fetch_queue _end_singleton
                                 ;

_begin_size_fetch_queue          : BEGIN_SIZE_FETCH_QUEUE
                                 {
				   list_token.push_back(BEGIN_SIZE_FETCH_QUEUE);
				 }
                                 ;
		                   
liste_attributs_size_fetch_queue : attribut_value
                                 ;
// ====={Balise "link_icache" }=====
// <cpu> 
// +- <internal>
//     +- <ifetch>
//        +- <link_icache>
		                 
balise_link_icache               : _begin_link_icache liste_attributs_link_icache _end_singleton
                                 ;

_begin_link_icache               : BEGIN_LINK_ICACHE
                                 {
				   list_token.push_back(BEGIN_LINK_ICACHE);
				 }
                                 ;
		                   
liste_attributs_link_icache      : attribut_id
                                 ;

// ====={Balise "link_predictor" }=====
// <cpu> 
// +- <internal>
//     +- <ifetch>
//        +- <link_predictor>
		                 
balise_link_predictor            : _begin_link_predictor liste_attributs_link_predictor _end_singleton
                                 ;

_begin_link_predictor            : BEGIN_LINK_PREDICTOR
                                 {
				   list_token.push_back(BEGIN_LINK_PREDICTOR);
				 }
                                 ;
		                   
liste_attributs_link_predictor   : attribut_id
                                 ;

// ====={Balise "link_decod" }=====
// <cpu> 
// +- <internal>
//     +- <ifetch>
//        +- <link_decod>
		                 
balise_link_decod                : _begin_link_decod liste_attributs_link_decod _end_singleton
                                 ;

_begin_link_decod                : BEGIN_LINK_DECOD
                                 {
				   list_token.push_back(BEGIN_LINK_DECOD);
				 }
                                 ;
		                   
liste_attributs_link_decod       : attribut_id
                                 ;

// *****{balise "_end_xml" }*****		       

_end_xml                         : END_XML       
                                 {
				   list_token.pop_back();
				 }

// *****{balise "_end_balise_dual" }*****		       

_end_balise_dual                 : END_BALISE_DUAL
                                 {
				   list_token.pop_back();
				 }

// *****{balise "_end_singleton" }*****		       

_end_singleton                   : END_SINGLETON
                                 {
				   list_token.pop_back();
				 }

// *****{Attribut_Optionnel }*****		       
attribut_optionnel_name          : empty
                                 | attribut_name   
                                 ;

attribut_optionnel_delay         : empty
                                 | attribut_delay
                                 ;

attribut_optionnel_latence       : empty
                                 | attribut_latence
                                 ;

attribut_optionnel_type          : empty
                                 | attribut_type
                                 ;

// *****{Type Attribut - Top level }*****
attribut_name                    : NAME    attribut_string
                                 {
		                   $$ = $2;
		                 }
                                 ;

attribut_algo                    : ALGO    attribut_string
                                 {
		                   $$ = $2;
		                 }
                                 ;

attribut_value                   : VALUE   attribut_integer
                                 {
		                   $$ = $2;
		                 }
                                 ;

attribut_type                    : TYPE    attribut_integer
                                 {
		                   $$ = $2;
		                 }
                                 ;
		                 
attribut_id                      : ID      attribut_integer
                                 {
		                   $$ = $2;
		                 }
                                 ;
		                 
attribut_delay                   : DELAY   attribut_integer
                                 {
		                   $$ = $2;
		                 }
                                 ;
		                 
attribut_latence                 : LATENCE attribut_integer
                                 {
		                   $$ = $2;
		                 }
                                 ;

// *****{Type Attribut - Bottom Level }*****
attribut_string                  : EQUAL QUOTE STRING QUOTE
                                 {
		                   $$ = $3;
		                 }
                                 ;
		                 
attribut_integer                 : EQUAL QUOTE INTEGER QUOTE
                                 {
		                   $$ = $3;
		                 }
                                 ;
		                 
attribut_float                   : EQUAL QUOTE FLOAT QUOTE
                                 {
		                   $$ = $3;
		                 }
                                 ;

empty                            : /* vide */
%%

// *** Fct auxilaire

void yyerror (const char * message) 
{
  cerr << "Line " << lineno << " : " << message << endl;
  cerr << "Near of token \"" << yylval.token << "\"" << endl;
  cerr << endl;
  
  if (list_token.empty() == true)
    {
      cerr << "Invalid file, the format is :" << endl;
      cerr << endl;
      cerr << "  <?xml _attributs_xml ?>" << endl;
      cerr << "  <cpu  _attributs_cpu  > _body_cpu </cpu>" << endl;

      exit(-1);
    }
  
  int token = list_token.back();
  
  switch (token)
    {
    case BEGIN_XML           :
      {
	cerr << "In balise <xml>, the format is :" << endl;
	cerr << endl;
	cerr << "  <?xml _attribut ?>" << endl;
	cerr << endl;
	cerr << "  _attribut ::= _value _encoding" << endl;
	cerr << "  _value    ::= value=\"_float\"" << endl;
	cerr << "  _encoding ::= encoding=\"_string\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_CPU           :
      {
	cerr << "In balise <cpu>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <cpu _attribut_cpu > _body_cpu </cpu>"  << endl;
	cerr << endl;
	cerr << "  _attribut_cpu ::= _name"                << endl;
	cerr << "  _name         ::= name=\"_string\""     << endl;
	cerr << endl;
	cerr << "  _body_cpu     ::= _type"                << endl;
	cerr << "                  | _latence"              << endl;
	cerr << "                  | _internal"             << endl;
	cerr << "  _type         ::= <type     _attribut_type >     _body_type     </type>"     << endl;
	cerr << "  _latence      ::= <latence  _attribut_latence >  _body_latence  </latence>"  << endl;
	cerr << "  _internal     ::= <internal _attribut_internal > _body_internal </internal>" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_TYPE          :
      {
	cerr << "In balise <type>, the format is :"    << endl;
	cerr << endl;
	cerr << "  <type> _body_type </type>"          << endl;
	cerr << endl;
	cerr << "  _body_type    ::= [_definition]+"   << endl;
	cerr << "                  | [_affectation]*"  << endl;
	cerr << "  _definition   ::= <definition  _attribut_definition >  _body_definition  </definition>"  << endl;
	cerr << "  _affectation  ::= <affectation _attribut_affectation />"                                 << endl;
	cerr << endl;
	break;
      }
    case BEGIN_DEFINITION    :
      {
	cerr << "In balise <definition>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <definition _attribut_definition > _body_definition </definition>"  << endl;
	cerr << endl;
	cerr << "  _attribut_definition ::= _id"                                           << endl;
	cerr << "  _id                  ::= id=\"_integer\""                               << endl;
	cerr << endl;
	cerr << "  _body_definition     ::= [_allow]+"                                     << endl;
	cerr << "  _allow               ::= <allow _attribut_allow />"                     << endl;
	cerr << endl;
	break;
      }
    case BEGIN_ALLOW         :
      {
	cerr << "In balise <allow>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <allow _attribut_allow />"  << endl;
	cerr << endl;
	cerr << "  _attribut_allow ::= _id"               << endl;
	cerr << "  _id             ::= type=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_AFFECTATION   :
      {
	cerr << "In balise <affectation>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <affectation _attribut_affectation />"  << endl;
	cerr << endl;
	cerr << "  _attribut_affectation ::= [_name]"           << endl;
	cerr << "                          | [_type]"           << endl;
	cerr << "  _name                 ::= name=\"_string\""  << endl;
	cerr << "  _type                 ::= type=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_LATENCE       :
      {
	cerr << "In balise <latence>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <latence _attribut_latence > _body_latence </latence>"  << endl;
	cerr << endl;
	cerr << "  _attribut_latence ::= _id"                               << endl;
	cerr << "  _id               ::= id=\"_integer\""                   << endl;
	cerr << endl;
	cerr << "  _body_latence     ::= [_operation]*"                     << endl;
	cerr << "  _operation        ::= <operation _attribut_operation />" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_OPERATION     :
      {
	cerr << "In balise <operation>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <operation _attribut_operation />"  << endl;
	cerr << endl;
	cerr << "  _attribut_operation ::= [_name]"              << endl;
	cerr << "                        | [_delay]"             << endl;
	cerr << "                        | [_latence]"           << endl;
	cerr << "  _name               ::= name=\"_string\""     << endl;
	cerr << "  _delay              ::= delay=\"_integer\""   << endl;
	cerr << "  _latence            ::= latence=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_INTERNAL      :
      {
	cerr << "In balise <internal>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <internal> _body_internal </internal>"  << endl;
	cerr << endl;
	cerr << "  _body_internal    ::= _global"                           << endl;
	cerr << "                      | _cache"                            << endl;
	cerr << "                      | _ifetch"                           << endl;
	cerr << "                      | ..."                               << endl;
	cerr << "  _global           ::= <global _attribut_global> _body_global </global>" << endl;
	cerr << "  _cache            ::= <cache _attribut_cache>   _body_cache  </cache>" << endl;
	cerr << "  _ifetch           ::= <ifetch _attribut_ifetch> _body_ifetch </ifetch>" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_GLOBAL        :
      {
	cerr << "In balise <global>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <global> _body_global </global>"  << endl;
	cerr << endl;
	cerr << "  _body_global    ::= _size_data"                       << endl;
	cerr << "                    | _scheme_bypass"                   << endl;
	cerr << "                    | [_isa]*"                          << endl;
	cerr << "  _size_data        ::= <size_data     _attribut_size_data />" << endl;
	cerr << "  _scheme_bypass    ::= <scheme_bypass _attribut_scheme_bypass />" << endl;
	cerr << "  _isa              ::= <isa           _attribut_isa> _body_isa </isa>" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_SIZE_DATA     :
      {
	cerr << "In balise <size_data>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <size_data _attribut_size_data />"  << endl;
	cerr << endl;
	cerr << "  _attribut_size_data ::= _value"             << endl;
	cerr << "  _value              ::= value=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_SCHEME_BYPASS :
      {
	cerr << "In balise <scheme_bypass>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <scheme_bypass _attribut_scheme_bypass />"  << endl;
	cerr << endl;
	cerr << "  _attribut_scheme_bypass ::= _algo"             << endl;
	cerr << "  _algo                   ::= algo =\"_string\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_ISA           :
      {
	cerr << "In balise <isa>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <isa> _body_isa </isa>"  << endl;
	cerr << endl;
	cerr << "  _body_isa    ::= [_orbis]"                  << endl;
	cerr << "                 | [_orfpx]"                  << endl;
	cerr << "                 | [_orvdx]"                  << endl;
	cerr << "  _orbis       ::= <ORBIS _attribut_orbis />" << endl;
	cerr << "  _orfpx       ::= <ORFPX _attribut_orfpx />" << endl;
	cerr << "  _orvdx       ::= <ORVDX _attribut_orvdx />" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_ORBIS         :
      {
	cerr << "In balise <ORBIS>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <ORBIS _attribut_orbis />"  << endl;
	cerr << endl;
	cerr << "  _attribut_orbis ::= _value"             << endl;
	cerr << "                    | [_type]"            << endl;
	cerr << "  _type           ::= type=\"_integer\""  << endl;
	cerr << "  _value          ::= value=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_ORFPX         :
      {
	cerr << "In balise <ORFPX>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <ORFPX _attribut_orfpx />"  << endl;
	cerr << endl;
	cerr << "  _attribut_orfpx ::= [_type]"            << endl;
	cerr << "                    | [_value]"           << endl;
	cerr << "  _type           ::= type=\"_integer\""  << endl;
	cerr << "  _value          ::= value=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_ORVDX         :
      {
	cerr << "In balise <ORVDX>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <ORVDX _attribut_orvdx />"  << endl;
	cerr << endl;
	cerr << "  _attribut_orvdx ::= [_type]"            << endl;
	cerr << "                    | [_value]"           << endl;
	cerr << "  _type           ::= type=\"_integer\""  << endl;
	cerr << "  _value          ::= value=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_CACHE         :
      {
	cerr << "In balise <cache>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <cache> _body_cache </cache>"  << endl;
	cerr << endl;
	cerr << "  _body_cache    ::= [_icache]+"                  << endl;
	cerr << "                   | [_dcache]+"                  << endl;
	cerr << "  _icache        ::= <icache _attribut_icache /> _body_icache </icache>" << endl;
	cerr << "  _dcache        ::= <dcache _attribut_dcache /> _body_dcache </dcache>" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_ICACHE        :
      {
	cerr << "In balise <icache>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <icache _attribut_icache > _body_icache </icache>"  << endl;
	cerr << endl;
	cerr << "  _attribut_icache ::= _id"                           << endl;
	cerr << "  _id              ::= id=\"_integer\""               << endl;
	cerr << endl;
	cerr << "  _body_icache     ::= [_arbiter]"                    << endl;
	cerr << "                     | [_nb_port]"                    << endl;
	cerr << "  _arbiter         ::= <arbiter _attribut_arbiter />" << endl;
	cerr << "  _nb_port         ::= <nb_port _attribut_nb_port />" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_DCACHE        :
      {
	cerr << "In balise <dcache>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <dcache _attribut_dcache > _body_dcache </dcache>"  << endl;
	cerr << endl;
	cerr << "  _attribut_dcache ::= _id"                           << endl;
	cerr << "  _id              ::= id=\"_integer\""               << endl;
	cerr << endl;
	cerr << "  _body_dcache     ::= [_arbiter]"                    << endl;
	cerr << "                     | [_nb_port]"                    << endl;
	cerr << "  _arbiter         ::= <arbiter _attribut_arbiter />" << endl;
	cerr << "  _nb_port         ::= <nb_port _attribut_nb_port />" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_ARBITER	     :
      {
	cerr << "In balise <arbiter>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <arbiter _attribut_arbiter />"  << endl;
	cerr << endl;
	cerr << "  _attribut_arbiter ::= _algo"            << endl;
	cerr << "  _algo             ::= algo=\"_string\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_NB_PORT       :
      {
	cerr << "In balise <nb_port>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <nb_port _attribut_nb_port />"  << endl;
	cerr << endl;
	cerr << "  _attribut_nb_port ::= _value"             << endl;
	cerr << "  _value            ::= value=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_IFETCH        :
      {
	cerr << "In balise <ifetch>, the format is :"         << endl;
	cerr << endl;
	cerr << "  <ifetch _attribut_ifetch > _body_ifetch </ifetch>"  << endl;
	cerr << endl;
	cerr << "  _attribut_ifetch  ::= _id"                           << endl;
	cerr << "  _id               ::= id=\"_integer\""               << endl;
	cerr << endl;
	cerr << "  _body_ifetch      ::= [_nb_inst_fetch]"              << endl;
	cerr << "                      | [_size_fetch_queue]"           << endl;
	cerr << "                      | _link_icache"                  << endl;
	cerr << "                      | _link_predictor"               << endl;
	cerr << "                      | _link_decod"                   << endl;
	cerr << "  _nb_inst_fetch    ::= <nb_inst_fetch    _attribut_nb_inst_fetch    />" << endl;
	cerr << "  _size_fetch_queue ::= <size_fetch_queue _attribut_size_fetch_queue />" << endl;
	cerr << "  _link_icache      ::= <link_icache      _attribut_link_icache      />" << endl;
	cerr << "  _link_predictor   ::= <link_predictor   _attribut_link_predictor   />" << endl;
	cerr << "  _link_decod       ::= <link_decod       _attribut_link_decod       />" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_NB_INST_FETCH :
      {
	cerr << "In balise <nb_inst_fetch>, the format is :"       << endl;
	cerr << endl;
	cerr << "  <nb_inst_fetch _attribut_nb_inst_fetch />"      << endl;
	cerr << endl;
	cerr << "  _attribut_nb_inst_fetch ::= _value"             << endl;
	cerr << "  _value                  ::= value=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_SIZE_FETCH_QUEUE :
      {
	cerr << "In balise <size_fetch_queue>, the format is :"       << endl;
	cerr << endl;
	cerr << "  <size_fetch_queue _attribut_size_fetch_queue />"   << endl;
	cerr << endl;
	cerr << "  _attribut_size_fetch_queue ::= _value"             << endl;
	cerr << "  _value                     ::= value=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_LINK_ICACHE         :
      {
	cerr << "In balise <link_icache>, the format is :"      << endl;
	cerr << endl;
	cerr << "  <link_icache _attribut_link_icache />"       << endl;
	cerr << endl;
	cerr << "  _attribut_link_icache ::= _id"               << endl;
	cerr << "  _id                   ::= type=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_LINK_PREDICTOR         :
      {
	cerr << "In balise <link_predictor>, the format is :"      << endl;
	cerr << endl;
	cerr << "  <link_predictor _attribut_link_predictor />"    << endl;
	cerr << endl;
	cerr << "  _attribut_link_predictor ::= _id"               << endl;
	cerr << "  _id                      ::= type=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    case BEGIN_LINK_DECOD         :
      {
	cerr << "In balise <link_decod>, the format is :"      << endl;
	cerr << endl;
	cerr << "  <link_decod _attribut_link_decod />"        << endl;
	cerr << endl;
	cerr << "  _attribut_link_decod ::= _id"               << endl;
	cerr << "  _id                  ::= type=\"_integer\"" << endl;
	cerr << endl;
	break;
      }
    default                  :
      {
	cerr << "Internal error : Unknow token (" << token << "). Please contact the Tools maintener" << endl;
      }
    }// end switch
  
  exit (1);
}
