#ifdef STATISTICS
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Group/include/Statistics.h"

#include <sstream>
using namespace std;

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace group                      {

  string Statistics::print_body (uint32_t depth)
  {
    string        tab = string(depth,'\t');
    ostringstream msg;
    
    for (uint32_t i=0; i<_nb_statistics; i++)
      {
	uint32_t nb_cycle    = (_counters[i]->_nb_cycle_none_use + 
				_counters[i]->_nb_cycle_full_use + 
				_counters[i]->_nb_cycle_normal_use);
	
	uint32_t cycle_begin = compute_cycle_begin(i);
	uint32_t cycle_end   = compute_cycle_end  (i,nb_cycle);

	msg << tab << "\t<cycle begin=\"" << cycle_begin << "\" end=\"" << cycle_end << "\">" << endl
	           << tab << "\t\t<nb_cycle_none_use   value=\"" 
	                  << _counters[i]->_nb_cycle_none_use                     << "\" /> <!-- " 
	                  << percent(_counters[i]->_nb_cycle_none_use  ,nb_cycle) << "% -->" << endl
	           << tab << "\t\t<nb_cycle_full_use   value=\"" 
	                  << _counters[i]->_nb_cycle_full_use                     << "\" /> <!-- " 
	                  << percent(_counters[i]->_nb_cycle_full_use  ,nb_cycle) << "% -->" << endl
	           << tab << "\t\t<nb_cycle_normal_use value=\"" 
	                  << _counters[i]->_nb_cycle_normal_use                   << "\" /> <!-- " 
	                  << percent(_counters[i]->_nb_cycle_normal_use,nb_cycle) << "% -->" << endl
	           << tab << "\t\t<nb_use              value=\"" 
	                  << _counters[i]->_nb_use                                << "\" /> <!-- average : " 
	                  << average(_counters[i]->_nb_use,                    nb_cycle)      << " - " 
	                  << percent(_counters[i]->_nb_use,_parameters._nb_elt*nb_cycle)      << "% -->" << endl
	    << tab << "\t</cycle>" << endl;
      }
    
    return msg.str();
  };
}; // end namespace group 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
