#ifndef DEBUG_H
#define DEBUG_H

#include "Behavioural/include/Debug_component.h"
#include <stdio.h>
#include <string.h>
#include <iostream>
#include <sstream>
#include <string>
using namespace std;

enum _debug_verbosity 
  {
    DEBUG_NONE ,
    DEBUG_INFO ,
    DEBUG_TRACE,
    DEBUG_FUNC ,
    DEBUG_ALL
  };

#ifdef DEBUG
//Debug
/*
#  define log_printf(level, component, str... )                                       \
do                                                                                    \
{                                                                                     \
    if ( ( DEBUG_ ## level     <= DEBUG) and                                          \
         ( DEBUG_ ## component == true ) )                                            \
      {                                                                               \
        fprintf(stdout,"<%s> line %d : ",__FILE__,__LINE__);                          \
        fprintf(stdout,str);                                                          \
        fprintf(stdout,"\n");                                                         \
      }                                                                               \
} while(0)								            
*/			
					            
#  define log_printf(level, component, func, str... )                                 \
do                                                                                    \
{                                                                                     \
    if ( ( DEBUG_ ## level     <= DEBUG) and                                          \
         ( DEBUG_ ## component == true ) )                                            \
      {                                                                               \
        fprintf(stdout,"In file %s, ",__FILE__);                                      \
        fprintf(stdout,"at line %d, ",__LINE__);                                      \
        fprintf(stdout,"in function \"%s\" : ",func);                                \
        fprintf(stdout,str);                                                          \
        fprintf(stdout,"\n");                                                         \
      }                                                                               \
} while(0)

#else
// No debug
/*
#  define log_printf(level, component, str... )                                       \
do                                                                                    \
{                                                                                     \
} while(0)									      
*/									      
#  define log_printf(level, component, func, str... )                                 \
do                                                                                    \
{                                                                                     \
} while(0)

#endif // DEBUG

#endif // !DEBUG_H
