/*
 *
 * [desc.]
 */
#include "Tools/Viewer/Parser/include/parser.h"
using namespace morpheo::tools::viewer::bdd;
namespace morpheo{
namespace tools{
namespace viewer{
namespace parser{     

  void Parse::parser_pos(QDomNode n){
       while( !n.isNull() )
      {
	QDomElement e = n.toElement();
	if( !e.isNull() )
	  {
	    
	    if( e.tagName() == "comment" )
	      {
		#ifdef DBUG_PARSE
		cout << "comment" <<endl;
		cout <<  e.text().toStdString() <<endl;
		#endif
		//BaseP
		pos->setComment(e.text().toStdString());
	      }
	    if (e.tagName() == "entity" )
	      {
                #ifdef DBUG_PARSE
		cout << "entity" <<endl;
		cout << e.attribute("name","").toStdString() <<endl;
		#endif
		ent=new morpheo::tools::viewer::bdd::Entity\
		  (e.attribute("name","").toStdString(),\
		   e.attribute("schema","").toInt(0,10));
		s=e.attribute("type","").toStdString();
		pos->setEntity(ent);
		parser_pos(n.firstChild());
		
		if((n.nextSiblingElement()).tagName() !="architecture")
      		  {
		    #ifdef DBUG_PARSE
		    cout << "pas d'archi" <<endl;
		    #endif
		    base->addBaseP(pos,s);
		    
		  }
	      } 
	    if (e.tagName() == "port" )
	      {
		#ifdef DBUG_PARSE
		cout << "port" <<endl;
		#endif
		morpheo::tools::viewer::bdd::Port \
		  *p=new morpheo::tools::viewer::bdd::\
		  Port(e.attribute("name","").toStdString(),\
		       e.attribute("direction","").toStdString(),\
		       e.attribute("localisation","").toStdString());
		p->setComment(e.text().toStdString());
		ent->addport(p);
	      } 
	    if (e.tagName() == "architecture" )
	      {
                #ifdef DBUG_PARSE
		cout << "architecture" <<endl;
		#endif
		arch=new morpheo::tools::viewer::bdd::Architecture();
		pos->setArchitecture(arch);
		
		base->addBaseP(pos,s);

		parser_pos(n.firstChild());    
	      } 
	    if (e.tagName() == "component" )
	      {
		#ifdef DBUG_PARSE
		cout << "component" <<endl;
		#endif
		morpheo::tools::viewer::bdd::Component \
		  *comp=new morpheo::tools::viewer::bdd::\
		  Component(e.attribute("name","").toStdString(),\
			    e.attribute("type","").toStdString(),\
			    e.attribute("pos_x","").toInt(0,10),\
			    e.attribute("pos_y","").toInt(0,10),\
			    e.attribute("size_x","").toInt(0,10),\
			    e.attribute("size_y","").toInt(0,10));
		arch->addComponent(comp, e.attribute("type","").toStdString());
		ctemp=comp;
		
		string fichier=absolutePath;
		fichier.append(e.attribute("type","").toStdString());
		fichier.append(".pos");
		#ifdef DBUG_PARSE
		cout << fichier <<endl;
		#endif
		open_file(fichier);
		parser_pos(n.firstChild());    
		//ajout ptr Port du sous composant
		BaseP pt=base->get_BasePos(e.attribute("type","").toStdString());
		QList<Port> *sspor= (pt.getEntity())->getPort();
		for(QList<Port>::iterator it=sspor->begin();it!=sspor->end();++it)
		  ctemp->addport(new Port(*it));
		
	      } 
	    if (e.tagName() == "port_map" )
	      {
                #ifdef DBUG_PARSE
		cout << "port_map" <<endl;
                #endif
		morpheo::tools::viewer::bdd::PortMap \
		  *p=new morpheo::tools::viewer::bdd::\
		  PortMap(e.attribute("name","").toStdString(),\
			  e.attribute("component","").toStdString(),\
			  e.attribute("port","").toStdString());
		
		ctemp->addPortMap(p);
		
	      } 
      
	  }
	n = n.nextSibling(); //next channel
	    
      }	
      
  }

};//end parser
};//end viewer
};//end tools
};//end morpheo

