/******************************************************/
/*                                                    */
/*  this class creates the application windows :      */
/*  - the main window where composants are drawn,     */
/*  - the parameters window,                          */
/*  - and the informations window.                    */
/*                                                    */
/******************************************************/


#ifndef WINDOW_H
#define WINDOW_H


#include <iostream>
#include <qstring.h>
#include <qapplication.h>
#include <qmetaobject.h>
#include <qmenu.h>
#include <qmenubar.h>
#include <qmainwindow.h>
#include <qwidget.h>
#include <qboxlayout.h> 
#include <qpainter.h>
#include <qcolor.h>
#include <qlabel.h>
#include <qstatusbar.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qwindowsstyle.h>
#include <qplastiquestyle.h>
#include <qlist.h>
#include <qrect.h>
#include <string.h>
#include <qtreeview.h>
#include <qdirmodel.h>

#include "Tools/Viewer/Parser/include/parser.h"


#define NORTH 0
#define SOUTH 1
#define EAST 2
#define WEST 3

using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace std;

namespace morpheo{
  namespace tools{
    namespace viewer{
      namespace graphics{

class Window : public QMainWindow
{
  
  Q_OBJECT

 public:

  Window(QString name);
  void _setParse(Parse *p);  
  void _init_file();    
 private slots:
    
  void _open();
  void _open_end();
  void _open_error();

  void _save();
  void _saveAs();
  void _saveAsOk();
  void _close();
  void _quit();
  void _quit2();
  void _zoomIn();
  void _zoomOut();
  void _defautZoom();
  void _level();
  void _informations();
  void _parameters();
  void _about();

 private:

  void wparameters();
  void winformations();
  void paintEvent( QPaintEvent * );
  void repaint();
  void drawPort(int x,int y,int pos,string dir);

  QList <Port> port_east;
  QList <Port> port_west;
  QList <Port> port_north;
  QList <Port> port_south;
  QList <Component> *compo;

  QWidget *wparam;
  QWidget *winfo;
  QWidget *ws;
  QWidget *wq;
  QWidget *wo;
  QWidget *wa;

  Parse *parse;
  BaseV *base;
  BaseP p;
  Entity *entity;
  Coord *c;
 
  QPainter painter;

  QStatusBar *status;

  QLineEdit *file_name;
  QString current_name;

  int window_height;
  int window_width;
  int panel_heigth;
  int panel_width;
  int margeX;
  int margeY;
  int portX;
  int portY;
  int posX;
  int posY;
  int tailleX;
  int tailleY;

  bool save_as;
  bool first_save;
  bool info_open;
  bool param_open;
  bool is_save;
  bool paint;
  bool wq_open;
  bool wo_open;
  bool ws_open;
  bool wa_open;
  bool quit_demand;
  bool file_open;
  bool is_parse;
};
      };
    };
  };
};

#endif
