#include "window.h"


using namespace std;
using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;

Window::Window(QString name)
{
  paint = false;
  is_parse = false;
  window_height = 620;
  window_width = 620;
  charg_open = false;
  mess_open = false; 
 
  /*menu bar*/
  QMenuBar *menu_bar = new QMenuBar(this);
  
  /*items of the menu bar*/
  QMenu *file = new QMenu();
  QMenu *tools = new QMenu();
  QMenu *help = new QMenu();
  
  /*connect signals of "file" menu with items of the menu bar*/
  QAction *openAct;
  openAct = new QAction(tr("&open"),this);
  connect(openAct,SIGNAL(triggered()),this,SLOT(_open()));
  
  QAction *closeAct;
  closeAct = new QAction(tr("&close"),this);
  connect(closeAct,SIGNAL(triggered()),this,SLOT(_close()));
  
  QAction *saveAct;
  saveAct = new QAction(tr("&save"),this);
  connect(saveAct,SIGNAL(triggered()),this,SLOT(_save()));
  
  QAction *saveAsAct;
  saveAsAct = new QAction(tr("&save_as"),this);
  connect(saveAsAct,SIGNAL(triggered()),this,SLOT(_saveAs()));
  
  QAction *quitAct;
  quitAct = new QAction(tr("&quit"),this);
  connect(quitAct,SIGNAL(triggered()),this,SLOT(_quit()));
  
  /*add the menu "file" to the menu bar*/
  file = menu_bar->addMenu(tr("&File"));
  file->addAction(openAct);
  file->addAction(saveAct);
  file->addAction(saveAsAct);
  file->addAction(closeAct);
  file->addAction(quitAct);

  /*connect signals of the menu "tools"  with items of the menu bar*/
  QAction *zoomInAct;
  zoomInAct = new QAction(tr("&zoom in"),this);
  connect(zoomInAct,SIGNAL(triggered()),this,SLOT(_zoomIn()));

  QAction *zoomOutAct;
  zoomOutAct = new QAction(tr("&zoom out"),this);
  connect(zoomOutAct,SIGNAL(triggered()),this,SLOT(_zoomOut()));

  QAction *defautZoomAct;
  defautZoomAct = new QAction(tr("&defaut zoom"),this);
  connect(defautZoomAct,SIGNAL(triggered()),this,SLOT(_defautZoom()));

  QAction *levelAct;
  levelAct = new QAction(tr("&level"),this);
  connect(levelAct,SIGNAL(triggered()),this,SLOT(_level()));

  QAction *infoAct;
  infoAct = new QAction(tr("&informations"),this);
  connect(infoAct,SIGNAL(triggered()),this,SLOT(_informations()));

  QAction *paramAct;
  paramAct = new QAction(tr("&parameters"),this);
  connect(paramAct,SIGNAL(triggered()),this,SLOT(_parameters()));


  QAction *compoNameAct;
  compoNameAct = new QAction(tr("&components name"),this);
  connect(compoNameAct,SIGNAL(triggered()),this,SLOT(_component_name()));

  QAction *signalNameAct;
  signalNameAct = new QAction(tr("&signals name"),this);
  connect(signalNameAct,SIGNAL(triggered()),this,SLOT(_signal_name()));

  /*add the menu "tools" to the menu bar*/
  tools = menu_bar->addMenu(tr("&Tools"));
  //tools->addAction(zoomInAct);
  //tools->addAction(zoomOutAct);
  //tools->addAction(defautZoomAct);
  tools->addAction(compoNameAct);
  tools->addAction(signalNameAct);
  //tools->addAction(levelAct);
  tools->addAction(infoAct);
  tools->addAction(paramAct);

  /*connect the menu "about" with items of the menu bar*/
  QAction *aboutAct;
  aboutAct = new QAction(tr("&about"),this);
  connect(aboutAct,SIGNAL(triggered()),this,SLOT(_about()));
  
  /*add the emenu "about" yo yhe menu bar*/
  help = menu_bar->addMenu(tr("&About"));
  help->addAction(aboutAct);
 
  /*add the menu bar to the main window*/
  this->setMenuWidget(menu_bar);

  /*add a status bar to the main menu*/
  status = new QStatusBar();
  this->setStatusBar(status);

  /*defaut size*/
  this->setFixedSize(window_width,window_height);

  /*defaut position*/
  this->move(50,50);    

  /*main window title*/
  this->setWindowTitle("Viewer");
   
  /*parameters window creation*/
  this->wparameters();
  param_open = true;

  /*informations window creation*/
  this->winformations();
  info_open = true;

  /*if quit_demand = true, then the user clicked on "quit"*/
  quit_demand = false;

  /*little windows (open, save...), closed at init*/
  wo_open = false;
  wq_open = false;
  ws_open = false;
  wa_open = false;

  signalName = true;
  componentName = true;

  /*file unsaved at init*/
  save_as = false;
  first_save = false; //first_save = true for a new file
  

  current_name = name;
  if(current_name != NULL){
    is_save = true;
  }
  else {
    file_open = false;
    paint = false;
    is_save = false;
  }
}
