#include "window.h"

using namespace std;

using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;

void Window::wparameters()
{
  wparam = new QWidget();
  parameters = new QBoxLayout(QBoxLayout::TopToBottom,0);
  wparam->setWindowTitle("parameters");
  wparam->setFixedSize(250,300);
  wparam->move(678,370);

  lname = new QLabel(wparam);
  lname->setText("");

  QBoxLayout *bpos = new QBoxLayout(QBoxLayout::LeftToRight,0);
  QLabel *lx = new QLabel();
  lx->setText("position x : ");
  positionX = new QLineEdit();
  positionX->setText("");
  bpos->addWidget(lx);
  bpos->addWidget(positionX);
  
  QBoxLayout *bpos2 = new QBoxLayout(QBoxLayout::LeftToRight,0);
  QLabel *ly = new QLabel();
  ly->setText("position y : ");
  positionY = new QLineEdit();
  positionY->setText("");
  bpos2->addWidget(ly);
  bpos2->addWidget(positionY);
  
  QBoxLayout *bsize = new QBoxLayout(QBoxLayout::LeftToRight,0);
  QLabel *sx = new QLabel();
  sx->setText("size x : ");
  sizeX = new QLineEdit();
  sizeX->setText("");
  bsize->addWidget(sx);
  bsize->addWidget(sizeX);
  
  QBoxLayout *bsize2 = new QBoxLayout(QBoxLayout::LeftToRight,0);
  QLabel *sy = new QLabel();
  sy->setText("size y : ");
  sizeY = new QLineEdit();
  sizeY->setText("");
  bsize2->addWidget(sy);
  bsize2->addWidget(sizeY);
  
  QBoxLayout *bport = new QBoxLayout(QBoxLayout::LeftToRight,0);
  QLabel *lport = new QLabel();
  lport->setText("nb ports : ");
  nb_ports = new QLineEdit();
  nb_ports->setText("");
  bport->addWidget(lport);
  bport->addWidget(nb_ports);

  parameters->addWidget(lname);
  parameters->addLayout(bpos);
  parameters->addLayout(bpos2);
  parameters->addLayout(bsize);
  parameters->addLayout(bsize2);
  parameters->addLayout(bport);
  QPushButton *back = new QPushButton("back",wparam);
  QPushButton *apply = new QPushButton("apply",wparam);
  connect(back,SIGNAL(clicked()),this,SLOT(_back()));
  parameters->addWidget(back);
  parameters->addWidget(apply);

  wparam->setLayout(parameters);
  wparam->show();
}

void Window::write_name(string name){
  QString n = QString::fromStdString(name);
  lname->setText(n);
  
}

void Window::write_position(int x, int y){
  stringstream out;
  string str;
  out << x;
  str = out.str();
  positionX->setText( QString::fromStdString(str));
  stringstream out2;
  string str2;
  out2 << y;
  str2 = out2.str();
  positionY->setText(QString::fromStdString(str2));
  
}

void Window::write_size(int x,int y){
  stringstream out;
  string str;
  out << x;
  str = out.str();
  sizeX->setText(QString::fromStdString(str)); 
  stringstream out2;
  string str2;
  out2 << y;
  str2 = out2.str();
  sizeY->setText(QString::fromStdString(str2));
}

void Window::write_ports(int x){
  stringstream out;
  string str;
  out << x;
  str = out.str();
  nb_ports->setText(QString::fromStdString(str));
  wparam->show();
}


