#include "window.h"

using namespace std;
using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;

void Window::mousePressEvent (QMouseEvent *e){
  
  if(paint && (p.getArchitecture() != NULL)){

    compo = p.getComponent();
    
    
    QMouseEvent *mouseEvent = (QMouseEvent *) e;
    
    mouseX = mouseEvent->x();
    mouseY = mouseEvent->y();
    
    
    for(QList<Component>::iterator it=compo->begin();it!=compo->end();++it){
      Coord *co = it->get_Position();
      int px = co->get_hg_x();
      int py = co->get_hg_y();
      int taillex = co->get_size_x();
      int tailley = co->get_size_y();
      
      if(e->type() == QMouseEvent::MouseButtonDblClick && e->button() == Qt::LeftButton){
	
	if(mouseX >= px + MARGEX  && mouseY >= py +MARGEY && mouseX <= px+taillex + MARGEX  && mouseY <= py+tailley + MARGEY) {
	  
	  paint = false;
	  repaint();
	   
	  mess = new QWidget();
      	  mess->setFixedSize(200,50);
	  mess->move(200,50);
	  QBoxLayout *b = new QBoxLayout(QBoxLayout::TopToBottom,0);
   	  QLabel *l = new QLabel();
	  l->setText("please wait while charging");
	  b->addWidget(l);
 	  mess->setLayout(b);
	  mess->show();
	  mess_open = true;
	  
	  p=base->get_BasePos(it->getType());
	  entity = p.getEntity();
	  c = new Coord(250,250,250,250);
	  port_east = entity->getPortEast(c);
	  port_west = entity->getPortWest(c);
	  port_north = entity->getPortNorth(c);
	  port_south = entity->getPortSouth(c);
	  paint = true;
	  father = current;
	  current = QString::fromStdString(it->getName());
	  repaint();
	}
      }

      if(e->type() == QMouseEvent::MouseButtonPress && e->button() == Qt::LeftButton){
	if(mouseX >= px + MARGEX  && mouseY >= py +MARGEY && mouseX <= px+taillex + MARGEX  && mouseY <= py+tailley + MARGEY) {
	  write_name(it->getName());
	  write_position(px,py);
	  write_size(taillex,tailley);
	  write_ports(cpt_ports);
	}	
      }
      
    }
  }
}

  
void Window::_back(){
  
  paint = false;
  repaint();
  mess_charg = new QWidget();
  mess_charg->setFixedSize(200,50);
  mess_charg->move(200,50);
  charg_open = true;
  QBoxLayout *b = new QBoxLayout(QBoxLayout::TopToBottom,0);
  QLabel *l = new QLabel();
  l->setText("please wait while charging");
  b->addWidget(l);
  mess_charg->setLayout(b);
  mess_charg->show();
  
  
  
  if(father==" "){
    QList <BaseP> *liste_compo = base->getBaseP();  
    p = liste_compo->at(0);  
  }

  else{
    p = base->get_BasePos(father.toStdString());
  }

  entity = p.getEntity();
  c = new Coord(250,250,250,250);
  port_east = entity->getPortEast(c);
  port_west = entity->getPortWest(c);
  port_north = entity->getPortNorth(c);
  port_south = entity->getPortSouth(c);
  father = current;
  current = QString::fromStdString(entity->getName());
  paint = true;
  repaint();
}

