#include "window.h"

using namespace std;

using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;

void Window::wparameters()
{
  wparam = new QWidget();
  parameters = new QBoxLayout(QBoxLayout::TopToBottom,0);
  wparam->setWindowTitle("parameters");
  wparam->setFixedSize(350,300);
  wparam->move(628,370);

  QBoxLayout *bpos = new QBoxLayout(QBoxLayout::LeftToRight,0);
  QLabel *lx = new QLabel();
  lx->setText("position x : ");
  positionX = new QLineEdit();
  positionX->setText("");
  bpos->addWidget(lx);
  bpos->addWidget(positionX);
  
  QBoxLayout *bpos2 = new QBoxLayout(QBoxLayout::LeftToRight,0);
  QLabel *ly = new QLabel();
  ly->setText("position y : ");
  positionY = new QLineEdit();
  positionY->setText("");
  bpos2->addWidget(ly);
  bpos2->addWidget(positionY);
  
  QBoxLayout *bsize = new QBoxLayout(QBoxLayout::LeftToRight,0);
  QLabel *sx = new QLabel();
  sx->setText("size x : ");
  sizeX = new QLineEdit();
  sizeX->setText("");
  bsize->addWidget(sx);
  bsize->addWidget(sizeX);
  
  QBoxLayout *bsize2 = new QBoxLayout(QBoxLayout::LeftToRight,0);
  QLabel *sy = new QLabel();
  sy->setText("size y : ");
  sizeY = new QLineEdit();
  sizeY->setText("");
  bsize2->addWidget(sy);
  bsize2->addWidget(sizeY);
  parameters->addLayout(bpos);
  parameters->addLayout(bpos2);
  parameters->addLayout(bsize);
  parameters->addLayout(bsize2);
  QPushButton *noselect = new QPushButton("cancel selection",wparam);
  QPushButton *back = new QPushButton("back",wparam);
  QPushButton *apply = new QPushButton("apply",wparam);
  connect(back,SIGNAL(clicked()),this,SLOT(_back()));
  connect(noselect,SIGNAL(clicked()),this,SLOT(_cancel_selection()));
  connect(apply,SIGNAL(clicked()),this,SLOT(_apply()));
  
  parameters->addWidget(noselect);
  parameters->addWidget(back);
  parameters->addWidget(apply);

  wparam->setLayout(parameters);
  wparam->show();
}

void Window::write_position(int x, int y){
  stringstream out;
  string str;
  out << x;
  str = out.str();
  positionX->setText( QString::fromStdString(str));
  stringstream out2;
  string str2;
  out2 << y;
  str2 = out2.str();
  positionY->setText(QString::fromStdString(str2));
}

void Window::erase_position(){
  positionX->setText("");
  positionY->setText("");
}

void Window::write_size(int x,int y){
  stringstream out;
  string str;
  out << x;
  str = out.str();
  sizeX->setText(QString::fromStdString(str)); 
  stringstream out2;
  string str2;
  out2 << y;
  str2 = out2.str();
  sizeY->setText(QString::fromStdString(str2));
}

void Window::erase_size(){
  sizeX->setText("");
  sizeY->setText("");
}

void Window::_cancel_selection(){
  component_clicked = false;
}

void Window::_apply(){
  if(positionX->isModified())
    cout << "positionX modified : " << positionX->text().toStdString() << endl;
  if(positionY->isModified())
    cout << "positionY modified : " << positionX->text().toStdString() << endl;
  if(sizeX->isModified())
    cout << "sizeX modified : " << sizeX->text().toStdString() << endl;
  if(sizeY->isModified())
    cout << "sizeY modified : " << sizeY->text().toStdString() << endl;
}
