/*
 *
 * [desc.]
 */
#include "Tools/Viewer/Parser/include/parser.h"

namespace morpheo{
namespace tools{
namespace viewer{
namespace parser{

   int Parse::open_file(string name,int level){

    QFile file(QString::fromStdString(name));
    QString testname,testname2;
    QString tmppath=QString::fromStdString(name);
    QString path=tmppath.left(tmppath.lastIndexOf('/',-1,Qt::CaseSensitive)+1);
    absolutePath=path.toStdString();
    testname=tmppath.right(tmppath.lastIndexOf('.',-1,Qt::CaseSensitive)-1);
    testname2=testname.left(testname.lastIndexOf('.',-1,Qt::CaseSensitive));
    
    if(tmppath.contains('-') && level==0) //file not top level (first open file)
      {
	testname2=testname2.left(testname2.lastIndexOf('-',-1,Qt::CaseSensitive));
      }
    
    
     if( !file.open( QIODevice::ReadOnly ) )
       {
	 cout << "Failed to load file. 1\n";
	 return -1;
       }

     QDomDocument doc( "pos" );
     if( !doc.setContent( &file ) )
      {
	cout <<  "Failed to load file.2\n";
	file.close();
	return -1;
      }
     file.close();
     QDomElement root = doc.documentElement();
     if( root.tagName() != "description" )
       {
	 cout <<"Invalid file.\n";
	 return -1;
       }
     else
       {
         #ifdef DBUG_PARSE
	 cout << "description" <<endl;
         #endif
	 //BaseP
	 if(!base){
	   base=new morpheo::tools::viewer::bdd::BaseV(); 
	   toplevel=testname2.toStdString();
	 }
	 pos=new morpheo::tools::viewer::bdd::BaseP();
	 //base->addBaseP(pos);
	 parser_pos(root.firstChild(),level);    
	 
       }

     //     delete pos;
     //delete ctemp;
     return 0;
   }


};//end parser
};//end viewer
};//end tools
};//end morpheo

