#include "window.h"

using namespace std;
using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;


/*signals actions implementation*/

void Window::_open(){
  //if no file open or if the file opened has been saved -> open other file, else -> ask for saving file
  if(!file_open || is_save){
    wo = new QWidget();
    wo_open = true; //the "open" window is open
    if(wa_open)
      wa->close();
    QBoxLayout *open_box = new QBoxLayout(QBoxLayout::TopToBottom,0);
    wo->setWindowTitle("open : file name");
    wo->setFixedSize(500,500);
    wo->move(50,100);
    QDirModel *dir = new QDirModel();
    QTreeView *tree = new QTreeView(wo);
    tree->resize(400,400);
    tree->setModel(dir);
    tree->setRootIndex(dir->index("./data/"));
    file_name = new QLineEdit(wo);
    QPushButton *ok_open = new QPushButton("ok",wo);
    connect(ok_open,SIGNAL(clicked()),this,SLOT(_open_end()));
    open_box->addWidget(tree);
    open_box->addWidget(file_name);
    open_box->addWidget(ok_open);
    wo->setLayout(open_box);
    wo->show();
  }
  else{
    wa_open = true;
    file_open = false;
    wa = new QWidget();
    QBoxLayout *other_box = new QBoxLayout(QBoxLayout::LeftToRight,0);
    wa->setFixedSize(500,60);
    wa->move(50,100);
    QLabel *label = new QLabel("do you want to save this file?");
    QPushButton *yes_save = new QPushButton("yes",wa);
    QPushButton *no_save = new QPushButton("no",wa);
    if(current_name!=NULL)
      connect(yes_save,SIGNAL(clicked()),this,SLOT(_save()));
    else 
      connect(yes_save,SIGNAL(clicked()),this,SLOT(_saveAs()));
    connect(no_save,SIGNAL(clicked()),this,SLOT(_open()));
    other_box->addWidget(label);
    other_box->addWidget(yes_save);
    other_box->addWidget(no_save);
    wa->setLayout(other_box);
    wa->show();
  }
}


void Window::_open_end(){
  current_name=file_name->text();
  wo->close();
  wo_open = false;//the "open" window is now closed
  if(!is_parse){
    parse = new Parse();
    is_parse=true;
  }
  if(parse->open_file( current_name.toStdString(),0)==-1)
    _open_error();
  else{
  paint = false;
  repaint();
  _init_file();
  }
}

void Window::_init_file(){
  is_save = true;
  base = parse->getBaseV();//parse the base and open the file
  #ifdef DEBUG_ALL
  base->afficheBaseConsole();
  #endif
  cpt_level = 0;
  
  tab[cpt_level] = "";
  file_open = true;
  QList <BaseP> *liste_compo = base->getBaseP();
  p = liste_compo->at(0);
  entity = p.getEntity();
  current = QString::fromStdString(entity->getName());
  c = new Coord(250,250,250,250);
  port_east = entity->getPortEast(c);
  port_west = entity->getPortWest(c);
  port_north = entity->getPortNorth(c);
  port_south = entity->getPortSouth(c);
  paint = true;
  repaint();
  setMouseTracking(true);
}

void Window::_open_error(){
  QMessageBox *error = new QMessageBox(this);
  error->setText("error : file doesn't exist or is not a valid format");
  error->addButton("ok",QMessageBox::YesRole);
  error->show();  
}  


void Window::_save(){
  if(file_open){
    if (wa_open)
      wa->close();
    if(save_as || first_save || (current_name==NULL)){//if "save as" or if it's the first time the user click on save (new file) -> save as
      ws = new QWidget();
      ws_open = true;//the "save" window is open
      QBoxLayout *save_box = new QBoxLayout(QBoxLayout::LeftToRight,0);
      ws->setWindowTitle("save : file name");
      ws->setFixedSize(300,60);
      ws->move(50,100);
      file_name = new QLineEdit(ws);
      QPushButton *ok_save = new QPushButton("ok",ws);
      connect(ok_save,SIGNAL(clicked()),this,SLOT(_saveAsOk()));
      save_box->addWidget(file_name);
      save_box->addWidget(ok_save);
      ws->setLayout(save_box);
      ws->show();
      save_as = false;
      first_save = false;
    }
    else {
      status->showMessage("file " + current_name + " saved",900);
      is_save = true;//file saved
    }
    if(wa_open){
      wa_open = false;
      _open();
    }
  }
  else{
    QMessageBox *mess = new QMessageBox(this);
    mess->setText("no file opened");
    mess->addButton("ok",QMessageBox::YesRole);
    mess->show(); 
  }
}

void Window::_saveAs(){
  if (wq_open){//if "quit" window is open, close it
    wq->close();
    wq_open = false;
  }
  save_as = true;
  _save();
}

void Window::_saveAsOk(){
  current_name = file_name->text();
  ws->close();//close the "save" window
  ws_open = false;
  is_save = true;
  status->showMessage("file " + current_name + " saved",900);
  if(wa_open){
    wa_open = false;
    _open();
  }
  if(quit_demand)//if the user clicked on "quit" (but saved the file just before) -> quit the application
    _quit2();
}

void Window::_close(){
  paint = false;
  lname->setText("");
  winfo->show();
  file_open = false;
  repaint();
}

void Window::_quit(){
  //if the file is not saved -> ask to the user if he wants to save it. If yes -> save, else quit.
  if(file_open && !is_save){
    wq_open = true;
    quit_demand = true;
    wq = new QWidget();
    QBoxLayout *quit_box = new QBoxLayout(QBoxLayout::LeftToRight,0);
    wq->setWindowTitle("save : file name");
    wq->setFixedSize(500,60);
    wq->move(50,100);
    QLabel *label = new QLabel("do you want to save this file?");
    QPushButton *yes_save = new QPushButton("yes",wq);
    QPushButton *no_save = new QPushButton("no",wq);
    connect(yes_save,SIGNAL(clicked()),this,SLOT(_saveAs()));
    connect(no_save,SIGNAL(clicked()),this,SLOT(_quit2()));
    quit_box->addWidget(label);
    quit_box->addWidget(yes_save);
    quit_box->addWidget(no_save);
    wq->setLayout(quit_box);
    wq->show();
  }
  else
    _quit2();
}
  
void Window::_quit2(){
  /*test if there are windows (other than the main window) opened*/

  if(wq_open)
    wq->close();
  if(wo_open)
    wo->close();
  if(ws_open)
    ws->close();
  if(wa_open)
    wa->close();
  if(param_open)
    wparam->close();
  if(info_open)
    winfo->close();
  close();
}




