#include "window.h"

using namespace std;
using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;

void Window::mousePressEvent (QMouseEvent *e){
  
  if(paint && (p.getArchitecture() != NULL)){

    compo = p.getComponent();
    
    
    QMouseEvent *mouseEvent = (QMouseEvent *) e;
    
    mouseX = mouseEvent->x();
    mouseY = mouseEvent->y();
    
    bool bc = false;
    int cx,cy,tx,ty;
    string cc,nc;
    bool found = false;

    for(QList<Component>::iterator it=compo->begin();it!=compo->end();++it){
      Coord *co = it->get_Position();
      int px = co->get_hg_x();
      int py = co->get_hg_y();
      int taillex = co->get_size_x();
      int tailley = co->get_size_y();
      QString t=QString::fromStdString(it->getType()).toLower();
      if(e->type() == QMouseEvent::MouseButtonDblClick && e->button() == Qt::LeftButton){
	
	if(mouseX >= px + MARGEX  && mouseY >= py +MARGEY && mouseX <= px+taillex + MARGEX  && mouseY <= py+tailley + MARGEY) {
	  
	  bc = false;
	  paint = false;
	  repaint();
          found=true;
	  this->setDisabled(true);
	}
      }
      if(found){  
       	mess = new QWidget();
	mess->setFixedSize(200,50);
	mess->move(200,50);
	QBoxLayout *b = new QBoxLayout(QBoxLayout::TopToBottom,0);
	QLabel *l = new QLabel();
	l->setText("please wait while charging");
	b->addWidget(l);
	mess->setLayout(b);
	mess->show();
	mess_open = true;

	p=base->get_BasePos(t.toStdString());
	entity = p.getEntity();
	c = new Coord(250,250,250,250);
	port_east = entity->getPortEast(c);
	port_west = entity->getPortWest(c);
	port_north = entity->getPortNorth(c);
	port_south = entity->getPortSouth(c);
	if(cpt_level!=0)
	  tab[cpt_level]=father;
	father = current;
	current = QString::fromStdString(t.toStdString());
	cpt_level++;
	tab[cpt_level] = father;
	paint = true;
	this->releaseMouse();
	repaint();
	write_name("");
	write_comment("");
	erase_position();
	erase_size();
	found = false;
	this->setDisabled(false);
      }
      
      if(e->type() == QMouseEvent::MouseButtonPress && e->button() == Qt::LeftButton){
	if(mouseX >= px + MARGEX  && mouseY >= py +MARGEY && mouseX <= px+taillex + MARGEX  && mouseY <= py+tailley + MARGEY) {
	  bc = true;
	  nc = it->getName();
	  cx = px;
	  cy = py;
	  tx = taillex;
	  ty = tailley;
	  BaseP tp = base->get_BasePos(t.toStdString());
	  if(&tp != NULL)
		cc=tp.getComment();
	  component_clicked = true;
	}
      }
    }
    if(bc){
      write_name(nc);
      write_position(cx,cy);
      write_size(tx,ty);
      write_comment(cc);
    }
  }
}


void Window::mouseMoveEvent(QMouseEvent *e){

   if(paint && (p.getArchitecture() != NULL) && !component_clicked){

    compo = p.getComponent();
    
    QMouseEvent *mouseEvent = (QMouseEvent *) e;

    mouseX = mouseEvent->x();
    mouseY = mouseEvent->y();
    
    bool b  = false;
    bool b2 = false;
    int px,py,taillex,tailley,sx,sy,ppx,ppy;
    string s,c;
   
    for(QList<Component>::iterator it=compo->begin();it!=compo->end();++it){
      Coord *co = it->get_Position();
      px = co->get_hg_x();
      py = co->get_hg_y();
      taillex = co->get_size_x();
      tailley = co->get_size_y();
      
      if(e->type() == QMouseEvent::MouseMove){
	if(mouseX >= px + MARGEX  && mouseY >= py +MARGEY && mouseX <= px+taillex + MARGEX  && mouseY <= py+tailley + MARGEY) {
	  b = true;
	  s = it->getName();
	  BaseP tp=base->get_BasePos(it->getName());
	  if(&tp!=NULL)
	    c=tp.getComment();
	  ppx = px;
	  ppy = py;
	}
      }
    
    

      // QList<PortMap> *pm=it->getPortMap();
//       for (QList<PortMap>::iterator it3=pm->begin();it3!=pm->end();++it3) {
// 	Signal *sig=base->getSignal(it->getType(),new PortMap(*it3));
// 	if(e->type() == QMouseEvent::MouseMove){
// 	  if(mouseX >= sig->get_dest_x() - 5  + MARGEX  && mouseY >= sig->get_dest_x() - 5 +MARGEY && mouseX <= sig->get_dest_x() + 5  + MARGEX  && mouseY <= sig->get_dest_x() + 5 +MARGEY) {
// 	    b2 = true;
// 	    s = it3->getName();
// 	    sx = portX;
// 	    sy = portY;
// 	  }
// 	}
//       }
    }
    
    if(b){
      write_name(s);
      write_position(ppx,ppy);
      write_size(taillex,tailley);
      write_comment(c);
    }
    else{
      write_name("");
      erase_position();
      erase_size();
      write_comment("");
    }
   
    
    // if(b2){
//       write_name(s);
//       write_position(sx,sy);
//     }
//     else{
//       write_name("");
//       erase_position();
//     }
    //  }
 
//    bool b3;
//    int sx2,sy2;
//    string s2;
   
//    for(QList<Port>::iterator it=port_east.begin(); it!=port_east.end(); ++it){
//       portX = it->get_x();
//       portY = it->get_y();
//       if(mouseX >= portX - 10 && mouseY >= portY - 10 && mouseX <= portX + 10 && mouseY <= portY + 10){
// 	b3 = true;
// 	s2 = it->getName();
// 	sx2 = portX;
// 	sy2 = portY;
//       }
//     } 
    
//     for(QList<Port>::iterator it=port_west.begin(); it!=port_west.end(); ++it){
//       portX = it->get_x() ;
//       portY = it->get_y() ;
//       if(mouseX >= portX - 5 && mouseY >= portY - 5 && mouseX <= portX + 5 && mouseY <= portY + 5){
// 	b3 = true;
// 	s2 = it->getName();
// 	sx2 = portX;
// 	sy2 = portY;
//       }
//     }
    
//     for(QList<Port>::iterator it=port_north.begin(); it!=port_north.end(); ++it){
//       portX = it->get_x() ;
//       portY = it->get_y() ;
//       if(mouseX >= portX - 5 && mouseY >= portY - 5 && mouseX <= portX + 5 && mouseY <= portY + 5){
// 	b3 = true;
// 	s2 = it->getName();
// 	sx2 = portX;
// 	sy2 = portY;
//       }
//     }
    
//     for(QList<Port>::iterator it=port_south.begin(); it!=port_south.end(); ++it){
//       portX = it->get_x() ;
//       portY = it->get_y() ;
//       if(mouseX >= portX - 5 && mouseY >= portY - 5 && mouseX <= portX + 5 && mouseY <= portY + 5){
// 	b3 = true;
// 	s2 = it->getName();
// 	sx2 = portX;
// 	sy2 = portY;
//       }
//     }
   }
}
   
 
void Window::_back(){
  if(cpt_level==0){
    QMessageBox *m = new QMessageBox(this);
    m->setText("can't go up, you're on the top level !");
    m->addButton("ok",QMessageBox::YesRole);
    m->show();  
  }
  
  else{
    this->setDisabled(true);
    paint = false;
    repaint();
    cpt_level--;
    mess_charg = new QWidget();
    mess_charg->setFixedSize(200,50);
    mess_charg->move(200,50);
    charg_open = true;
    QBoxLayout *b = new QBoxLayout(QBoxLayout::TopToBottom,0);
    QLabel *l = new QLabel();
    l->setText("please wait while charging");
    b->addWidget(l);
    mess_charg->setLayout(b);
    mess_charg->show();
    
    p = base->get_BasePos(father.toStdString());
    entity = p.getEntity();
    c = new Coord(250,250,250,250);
    port_east = entity->getPortEast(c);
    port_west = entity->getPortWest(c);
    port_north = entity->getPortNorth(c);
    port_south = entity->getPortSouth(c);
    father = tab[cpt_level];
    current = QString::fromStdString(entity->getName());
    paint = true;
    repaint();
    this->setDisabled(false);
  }
}

