/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Include/ChangeCase.h"
#include "Behavioural/include/Interface.h"

namespace morpheo              {
namespace behavioural          {

  string Interface::set_signal (Signal signal)
  {
    return set_signal(signal._name     ,
		      signal._direction,
		      signal._size     );
    
  };

  string Interface::set_signal (string          name     ,
				direction_t     direction,
				uint32_t        size     ,
				presence_port_t presence_port)
  {
    string str_direction =  toString(direction);
    string str_interface = _name;
    string str_signal    =  name;

    LowerCase(str_direction);    
    UpperCase(str_interface);
    UpperCase(str_signal   );
    
    string signame = str_direction;
    if (_name != "")
      signame += "_"+str_interface;
    if (name  != "")
      signame += "_"+str_signal;
    
    _list_signal.push_back (Signal (signame      ,
				    direction    ,
				    size         ,
				    presence_port));

    return signame;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
