#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Pseudo_LRU/include/Pseudo_LRU.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace select {
namespace pseudo_lru {

  void Pseudo_LRU::allocation (void)
  {
    in_CLOCK  = new SC_CLOCK           ("in_CLOCK");

    // -----[Interface access ]-------------------------------------------
     in_ACCESS_VAL     = new SC_IN (Tcontrol_t) * [_param._nb_access];
    out_ACCESS_ACK     = new SC_OUT(Tcontrol_t) * [_param._nb_access];
    if (_param._size_table>1)
      in_ACCESS_ADDRESS = new SC_IN (Taddress_t) * [_param._nb_access];
    out_ACCESS_ENTITY  = new SC_OUT(Tentity_t ) * [_param._nb_access];
    
    for (uint32_t i=0; i<_param._nb_access; i++)
      {
        string rename;

	rename = "in_ACCESS_VAL["     + toString(i) + "]";
	 in_ACCESS_VAL     [i] = new SC_IN (Tcontrol_t) (rename.c_str());

	rename = "out_ACCESS_ACK["    + toString(i) + "]";
	out_ACCESS_ACK     [i] = new SC_OUT(Tcontrol_t) (rename.c_str());

	if (_param._size_table>1)
	  {
	    rename = "in_ACCESS_ADDRESS[" + toString(i) + "]";
	    in_ACCESS_ADDRESS [i] = new SC_IN (Taddress_t) (rename.c_str());
	  }
	rename = "out_ACCESS_ENTITY[" + toString(i) + "]";
	out_ACCESS_ENTITY  [i] = new SC_OUT(Tentity_t ) (rename.c_str());
      }

    // -----[Interface update ]-------------------------------------------
     in_UPDATE_VAL     = new SC_IN (Tcontrol_t) *  [_param._nb_update];
    out_UPDATE_ACK     = new SC_OUT(Tcontrol_t) *  [_param._nb_update];
    if (_param._size_table>1)
      in_UPDATE_ADDRESS = new SC_IN (Taddress_t) *  [_param._nb_update];
     in_UPDATE_ENTITY  = new SC_IN (Tentity_t ) *  [_param._nb_update];

    for (uint32_t i=0; i<_param._nb_update; i++)
      {
        string rename;

	rename = "in_UPDATE_VAL["     + toString(i) + "]";
 	 in_UPDATE_VAL     [i] = new SC_IN (Tcontrol_t) (rename.c_str());

	rename = "out_UPDATE_ACK["    + toString(i) + "]";;
	out_UPDATE_ACK     [i] = new SC_OUT(Tcontrol_t) (rename.c_str());

	if (_param._size_table>1)
	  {
	    rename = "in_UPDATE_ADDRESS[" + toString(i) + "]";
	    in_UPDATE_ADDRESS [i] = new SC_IN (Taddress_t) (rename.c_str());
	  }

	rename = "in_UPDATE_ENTITY["  + toString(i) + "]";
	 in_UPDATE_ENTITY  [i] = new SC_IN (Tentity_t ) (rename.c_str());
      }

    // -----[Register ]---------------------------------------------------
    reg_TABLE = new entry_t *  [_param._size_table];

    for (uint32_t i=0; i<_param._size_table; i++)
      reg_TABLE [i] = new entry_t (_param._nb_entity);
    
    // -----[Internal ]---------------------------------------------------
    internal_ACCESS_ENTITY = new Tentity_t [_param._nb_entity];
  };

}; // end namespace pseudo_lru
}; // end namespace select
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
