#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Pseudo_LRU/include/Pseudo_LRU.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace select {
namespace pseudo_lru {


  void Pseudo_LRU::vhdl_port (Vhdl & vhdl)
  {
    vhdl.set_port ("in_CLOCK" , IN, "std_logic");

    for (uint32_t i = 0; i < _param._nb_access; i ++)
      {
	vhdl.set_port (" in_ACCESS_VAL_"+toString(i)+"     ",IN ,std_logic(1));
	vhdl.set_port ("out_ACCESS_ACK_"+toString(i)+"     ",OUT,std_logic(1));
	if (_param._size_table>1)
	  vhdl.set_port (" in_ACCESS_ADDRESS_"+toString(i)+" ",IN ,std_logic(static_cast<uint32_t>(log2(_param._size_table))));
	vhdl.set_port ("out_ACCESS_ENTITY_"+toString(i)+"  ",OUT,std_logic(static_cast<uint32_t>(log2(_param._nb_entity))));
      }

    for (uint32_t i = 0; i < _param._nb_update; i ++)
      {
	vhdl.set_port (" in_UPDATE_VAL_"+toString(i)+"     ",IN ,std_logic(1));
	vhdl.set_port ("out_UPDATE_ACK_"+toString(i)+"     ",OUT,std_logic(1));
	if (_param._size_table>1)
	  vhdl.set_port (" in_UPDATE_ADDRESS_"+toString(i)+" ",IN ,std_logic(static_cast<uint32_t>(log2(_param._size_table))));
	vhdl.set_port (" in_UPDATE_ENTITY_"+toString(i)+"  ",IN ,std_logic(static_cast<uint32_t>(log2(_param._nb_entity))));
      }
  };

}; // end namespace pseudo_lru
}; // end namespace select
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
