#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table/include/Branch_History_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace branch_history_table {


  void Branch_History_Table::vhdl_port (Vhdl & vhdl)
  {
    vhdl.set_port (" in_CLOCK" , IN, 1);
    
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	vhdl.set_port(" in_PREDICT_VAL_"+toString(i)+"             ", IN, 1);
	vhdl.set_port("out_PREDICT_ACK_"+toString(i)+"             ",OUT, 1);
	vhdl.set_port(" in_PREDICT_ADDRESS_"+toString(i)+"         ", IN, static_cast<uint32_t>(ceil(log2(_param._nb_shifter))));
	vhdl.set_port("out_PREDICT_HISTORY_"+toString(i)+"         ",OUT, _param._size_shifter);
      }
     for (uint32_t i=0; i<_param._nb_branch_complete; i++)
       {
	 vhdl.set_port (" in_BRANCH_COMPLETE_VAL_"+toString(i)+"    ", IN, 1);
	 vhdl.set_port ("out_BRANCH_COMPLETE_ACK_"+toString(i)+"    ",OUT, 1);
	 vhdl.set_port (" in_BRANCH_COMPLETE_ADDRESS_"+toString(i)+"", IN, static_cast<uint32_t>(ceil(log2(_param._nb_shifter))));
	 vhdl.set_port (" in_BRANCH_COMPLETE_HISTORY_"+toString(i)+"", IN, _param._size_shifter);
	 vhdl.set_port (" in_BRANCH_COMPLETE_HIT_"+toString(i)+"    ", IN, 1);
       }
  };

}; // end namespace branch_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
