#ifdef VHDL_TESTBENCH

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl_Testbench.h"

namespace morpheo              {
namespace behavioural          {

  void Vhdl_Testbench::generate_process_clock (uint32_t counter)
  {
    _vhdl->set_body("");
    _vhdl->set_body(_clock_name+" <= not "+_clock_name+" after 50 ns;");
    _vhdl->set_body("testbench_counter <= testbench_counter+1 after 100 ns;");
    _vhdl->set_body("");

    _vhdl->set_body("process ("+_clock_name+")");
    _vhdl->set_body("begin");
    _vhdl->set_body("\tif "+_clock_name+"'event and "+_clock_name+" = '1' then");
    _vhdl->set_body("");
    _vhdl->set_body("\t\tassert (not ((testbench_must_test = '1') and not (testbench_test = testbench_output)))");
    _vhdl->set_body("\t\treport \"   Test KO - output's test is different of output's component\"");
    _vhdl->set_body("\t\tseverity FAILURE;");
    _vhdl->set_body("");
    _vhdl->set_body("\t\tassert (not ((testbench_must_test = '1') and     (testbench_test = testbench_output)))");
    _vhdl->set_body("\t\treport \"   Test OK\"");
    _vhdl->set_body("\t\tseverity NOTE;");
    _vhdl->set_body("");
    _vhdl->set_body("\t\tassert (not ( testbench_must_test = '0'))");
    _vhdl->set_body("\t\treport \"No Test\"");
    _vhdl->set_body("\t\tseverity NOTE;");
    _vhdl->set_body("");
    _vhdl->set_body("\tend if;");
    _vhdl->set_body("end process;");
    
    _vhdl->set_body("");
    _vhdl->set_body("assert (not (testbench_counter = " + toString(counter)+"))");
    _vhdl->set_body("report \"End of Simulation\"");
    _vhdl->set_body("severity FAILURE;");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
