#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table/include/Branch_History_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace branch_history_table {


  void Branch_History_Table::vhdl_testbench_transition (void)
  {
    // In order with file Branch_History_Table_vhdl_testbench_port.cpp
#ifndef SYSTEMCASS_SPECIFIC
    sc_cycle(0);
#endif    

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	_vhdl_testbench->add_input  (PORT_READ( in_PREDICT_VAL     [i]));
	_vhdl_testbench->add_output (PORT_READ(out_PREDICT_ACK     [i]));
	_vhdl_testbench->add_input  (PORT_READ( in_PREDICT_ADDRESS [i]));
	_vhdl_testbench->add_output (PORT_READ(component_RegisterFile->out_READ_DATA [i]));
      //_vhdl_testbench->add_output (PORT_READ(out_PREDICT_HISTORY [i]));
      }

     for (uint32_t i=0; i<_param._nb_branch_complete; i++)
       {
	 _vhdl_testbench->add_input  (PORT_READ( in_BRANCH_COMPLETE_VAL     [i]));
	 _vhdl_testbench->add_output (PORT_READ(out_BRANCH_COMPLETE_ACK     [i]));
	 _vhdl_testbench->add_input  (PORT_READ( in_BRANCH_COMPLETE_ADDRESS [i]));
	 _vhdl_testbench->add_input  (PORT_READ( in_BRANCH_COMPLETE_HISTORY [i]));
	 _vhdl_testbench->add_input  (PORT_READ( in_BRANCH_COMPLETE_DIRECTION[i]));
       }
    
    // add_test :
    //  - True  : the cycle must be compare with the output of systemC
    //  - False : no test
    _vhdl_testbench->add_test(true);

    _vhdl_testbench->new_cycle (); // always at the end
  };

}; // end namespace branch_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
