#ifdef POSITION
#ifndef morpheo_behavioural_Entity_h
#define morpheo_behavioural_Entity_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <list>
#include "Behavioural/include/Interfaces.h"
#include "Behavioural/include/Schema.h"
#include "Include/ErrorMorpheo.h"
#include "Include/ToString.h"
#include "Include/Debug.h"

using namespace std;

namespace morpheo              {
namespace behavioural          {

  class Entity
  {
    friend class Position;
    friend class Interface;

    // -----[fields ]----------------------------------------------------
  private   : const string          _name         ;
  private   : const string          _type         ;
  private   : const schema_t        _schema       ;
  private   : Interfaces          * _interfaces   ;
  private   : string                _comment      ;

  private   :       bool            _is_map       ;
  private   :       uint32_t        _map_size_x   ;
  private   :       uint32_t        _map_size_y   ;
  private   :       uint32_t        _map_pos_x    ;
  private   :       uint32_t        _map_pos_y    ;

    // -----[methods ]---------------------------------------------------
  public    :                       Entity            (string        name   ,
						       string        type   ,
						       schema_t      schema );
  public    :                        Entity           (const Entity & entity);
  public    :                       ~Entity           ();

  public    : void                  set_comment       (string comment);
  private   : string                get_comment       (void          );

  public    : Interfaces *          set_interfaces    (void);
  private   : string                get_interfaces    (void);

  public    : Interface  *          find_interface    (string name);

  public    : void                  mapping           (uint32_t size_x,
						       uint32_t size_y,
						       uint32_t pos_x ,
						       uint32_t pos_y );

  public    : XML                   toXML             (void);
  public    : XML                   toXML_mapping     (void);

  public    : friend ostream&       operator<<        (ostream& output_stream,
  					  	       morpheo::behavioural::Entity & x);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
#endif
