#ifdef POSITION

#ifndef morpheo_behavioural_Schema_h
#define morpheo_behavioural_Schema_h

#include "Include/ToString.h"

namespace morpheo              {
namespace behavioural          {

typedef enum { MIXTE      ,
	       COMBINATORY,
	       FIFO       ,
	       REGISTER   ,
	       SHIFTER    ,
	       ADDER      } schema_t;

}; // end namespace behavioural          
  
template<>           inline std::string toString<morpheo::behavioural::schema_t>(const morpheo::behavioural::schema_t& x)
{
  switch (x)
    {
    case morpheo::behavioural::MIXTE       : return "Mixte"      ; break;
    case morpheo::behavioural::COMBINATORY : return "Combinatory"; break;
    case morpheo::behavioural::FIFO        : return "FIFO"       ; break;
    case morpheo::behavioural::REGISTER    : return "Register"   ; break;
    case morpheo::behavioural::SHIFTER     : return "Shifter"    ; break;
    case morpheo::behavioural::ADDER       : return "Adder"      ; break;
    default                                : return ""           ; break;
    }
}

}; // end namespace morpheo

#endif
#endif
