#ifdef POSITION
#ifndef morpheo_behavioural_Position_h
#define morpheo_behavioural_Position_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <list>
#include "Behavioural/include/Entity.h"
#include "Include/ToString.h"
#include "Include/Debug.h"

using namespace std;

namespace morpheo              {
namespace behavioural          {

  class Position
  {
    // -----[fields ]----------------------------------------------------
  private   : Entity              * _entity        ;
  private   : list<Entity *>      * _list_component;
    
    // -----[methods ]---------------------------------------------------
  public    :                       Position          (void);
  public    :                       Position          (const Position & position);
  public    :                       ~Position         ();

  public    : Entity *              set_entity        (string        name   ,
						       string        type   ,
						       schema_t      schema );
  private   : string                get_entity        (void);

  public    : void                  set_component     (Entity * entity,
						       uint32_t size_x,
						       uint32_t size_y,
						       uint32_t pos_x ,
						       uint32_t pos_y );

  private   : string                get_component     (void);

  public    : void                  port_map          (string component1,
						       string signal1   ,
						       string component2,
						       string signal2   );

  public    : XML                   toXML             (void);

  private   : Entity *              find_entity       (string name);
  private   : Interface *           find_interface    (string   name  , 
						       Entity * entity);

  public    : void                  generate_file     (void);
    
  public    : friend ostream&       operator<<        (ostream& output_stream,
  					  	       morpheo::behavioural::Position & x);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
#endif
